/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.buildconfig.editor;

import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import ro.amiq.dvt.ui.buildconfig.editor.BCPartitionScanner;
import ro.amiq.dvt.ui.buildconfig.editor.MacroPositionUpdater;
import ro.amiq.dvt.ui.editor.IDVTDocumentSetupParticipant;

public class DocumentSetupParticipant
implements IDVTDocumentSetupParticipant {
    private FastPartitioner partitioner;

    public void setup(IDocument document) {
        if (document == null) {
            return;
        }
        this.addPositionCategories(document);
    }

    @Override
    public void addPositionCategories(IDocument document) {
        DefaultPositionUpdater reflectionUpdater = new DefaultPositionUpdater("REFLECTION"){

            public void update(DocumentEvent event) {
                if (event.getDocument() instanceof IDocumentExtension4 && ((IDocumentExtension4)event.getDocument()).getActiveRewriteSession() != null) {
                    return;
                }
                super.update(event);
            }
        };
        DefaultPositionUpdater foldingUpdater = new DefaultPositionUpdater("__dvt_folding_position");
        MacroPositionUpdater macroUpdater = new MacroPositionUpdater("__dvt_macro_position");
        DefaultPositionUpdater inactiveCodeUpdater = new DefaultPositionUpdater("__dvt_inactive_code_position");
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            this.partitioner = new FastPartitioner((IPartitionTokenScanner)new BCPartitionScanner(), new String[]{"__BC_sl_comment", "__BC_ml_comment", "__BC_literal", "__dftl_partition_content_type"});
            extension3.setDocumentPartitioner("__BC_partitioning", (IDocumentPartitioner)this.partitioner);
            this.partitioner.connect(document);
        }
        document.addPositionCategory("__dvt_folding_position");
        document.addPositionUpdater((IPositionUpdater)foldingUpdater);
        document.addPositionCategory("REFLECTION");
        document.addPositionUpdater((IPositionUpdater)reflectionUpdater);
        document.addPositionCategory("__dvt_macro_position");
        document.addPositionUpdater((IPositionUpdater)macroUpdater);
        document.addPositionCategory("__dvt_inactive_code_position");
        document.addPositionUpdater((IPositionUpdater)inactiveCodeUpdater);
    }

    public void disconnect() {
        if (this.partitioner != null) {
            this.partitioner.disconnect();
        }
        this.partitioner = null;
    }
}

