/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.buildconfig.editor;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.MinTypMax;
import ro.amiq.dvt.utils.DVTStringUtil;

public interface IBCConstants {
    public static final String EDT_DIRECTIVES = "+dvt_e_as_computed_translate_method+;+dvt_e_as_computed_translate_method_disable+;+dvt_test+;" + DVTStringUtil.join(IBuildConfigParserConstants.Directive.getDirectivesForLanguage(LanguageKind.E), ";") + ";";
    public static final String VLOGDT_DIRECTIVES = "+mindelays;+typdelays;+maxdelays;-sv_lib;-sv_liblist;-sv_root;-pkgsearch;-liblist;-G;-sv05compat;-sv09compat;-sv12compat;-vlog95compat;-vlog01compat;-svfilesuffix;+dvt_preprocess_translate_pragmas+;" + DVTStringUtil.join(IBuildConfigParserConstants.Directive.getDirectivesForLanguage(LanguageKind.VLOG), ";") + ";";
    public static final String VHDLDT_DIRECTIVES = "-87;-93;-2002;-2008;-w;-vhdl87;" + DVTStringUtil.join(IBuildConfigParserConstants.Directive.getDirectivesForLanguage(LanguageKind.VHDL), ";") + ";";
    public static final String DVT_DIRECTIVES = "-amscompilefile;-CFLAGS;-ccflags;-ccargs;-I;-D;-L;-l;-imacros;-include;+define+;-cuname;-define;-defineall;+disable_ext;+disable_ext+all;+dvt_prepend_init;+dvt_init;+dvt_init_auto;+dvt_init_from_simlog;+dvt_init_xilinx;+dvt_init_altera;+dvt_init_questa_libs;+dvt_init_uvvm;+dvt_init_uvvm_vvc;+dvt_init_precompiled_db_load;+dvt_init_osvvm;+dvt_env+;+dvt_setenv+;+dvt_env_no_override+;+dvt_setenv_no_override+;+dvt_ext_included+;+dvt_defparam+;+dvt_ext_map+;+dvt_cdt_file_type_map+;+dvt_ext_unmap+;+dvt_ext_unmapped_syntax+;+dvt_ext_unmap_all;+dvt_keyword_set+;+dvt_skip_compile+;+dvt_skip_compile+not+;+dvt_skip_compile+regex+;+dvt_skip_compile+regex+not+;+dvt_shallow_compile+;+dvt_skip_ext+;+dvtcompat+;+dvt_undefine+;-extinclude;+incdir+;-incdir;+libext+;-libmap;+librescan;-librescan;-ovmhome;-uvmhome;-uvmexthome;-ml_uvm;-ovm;-top;-timescale;-override_timescale;+dvt_e_vtop+;-uvm;-vmm;-pvalue+;-sverilog;+systemverilogext+;-v;+v2k;+verilog1995ext+;+verilog2001ext+;-y;-f;-F;+dvt_include_build;-work;-defparam;-vlogext;-vlog_ext;-default_ext;-v1995;-v95;-sv;-v200x;-v93;-vlog95_ext;-e_ext;-vhdl_ext;-vhdlext;-sndefine;-snpath;-snload;-ams;-amsvhdl_ext;-amsvlog_ext;-svams_2019;-sysv_ext;-asext;-ccext;-cxxext;-objext;-a_ext;-as_ext;-c_ext;-cpp_ext;-dynlib_ext;-o_ext;-spice_ext;" + DVTStringUtil.join(IBuildConfigParserConstants.Directive.getDVTLevelDirectives(), ";") + ";";
    public static final String ALL_DVT_DIRECTIVES = String.valueOf(DVT_DIRECTIVES) + EDT_DIRECTIVES + VLOGDT_DIRECTIVES + VHDLDT_DIRECTIVES;
    public static final String COMPAT_MODES = "+dvt;+vcs.vlogan;+vcs.vhdlan;+ius.irun;+xcelium.xrun;+questa.vlog;+questa.vcom;+questa.qrun;+gcc;+ius.perspec";
    public static final String SYNTAX_INDENTIFIERS = "Verilog_95;Verilog_2001_noconfig;Verilog_2001;Verilog_2005;Verilog_AMS_23;SystemVerilog_2005;SystemVerilog_2009;SystemVerilog_2012;SystemVerilog_2023;SystemVerilog;SystemVerilog_AMS;e_2011;e;VHDL_87;VHDL_93;VHDL_AMS_99;VHDL_2000;VHDL_2002;VHDL_AMS_2007;VHDL_2008;VHDL;SKIP;C;SDL";
    public static final String INCLUDED_OPTIONS = "by_ext;by_parent";
    public static final Map<String, String> DIRECTIVE_KEYWORDS_HELP_TEXT = IBCConstants.initDirectiveKeywords();
    public static final Map<String, String> ALL_KEYWORDS_HELP_TEXT = new ImmutableMap.Builder().put((Object)"sv_lib", (Object)"-sv_lib <file_path_without_extension> Specify a shared object C library. Provided that the library contains debug info, DVT will Auto-Link the C source files from which the library was compiled. The .so extension is automatically appended to the specified path.").put((Object)"sv_liblist", (Object)"-sv_liblist <file_path> Specify a shared object bootstrap file. The file contains a list of shared object C library pathnames, one per line. For each library in the bootstrap file, provided that the library contains debug info, DVT will Auto-Link the C source files from which the library was compiled.  The .so extension is automatically appended to the paths specified in the bootstrap file.").put((Object)"sv_root", (Object)"-sv root <directory_path> The root directory path is prepended to any relative path that has been specified using -sv_lib or -sv_liblist or inside the shared object bootstrap file.").put((Object)"-liblist", (Object)"-liblist <lib_name1>[+<lib_name2>+...] Specify the library search order for Verilog packages.").put((Object)"-pkgsearch", (Object)"-pkgsearch <lib_name> Specify the library search order for Verilog packages. You can specify multiple libraries by using this option multiple times.").put((Object)"amscompilefile", (Object)"-amscompilefile \"file:<file_path>[ ...]\"\nEquivalent with specifying <file_path> as a top file.").put((Object)"imacros", (Object)"GCC argument.").put((Object)"include", (Object)"GCC argument.").put((Object)"l", (Object)"GCC argument.").put((Object)"CFLAGS", (Object)"Specify C compiler arguments.").put((Object)"ccflags", (Object)"Specify C compiler arguments.").put((Object)"ccargs", (Object)"Specify C compiler arguments.").put((Object)"define", (Object)"+define+<var>=<value>\n-define <var>=<value>\n-defineall <var>=<value>\nDeclare a preprocessing define.\nThe value is optional and you may quote it with either ' or \".\nIf a system variable is used in the value, it will be expanded.\nThe define is cleared by the next +dvt_init+ directive.").put((Object)"defineall", (Object)"+define+<var>=<value>\n-define <var>=<value>\n-defineall <var>=<value>\nDeclare a preprocessing define.\nThe value is optional and you may quote it with either ' or \".\nIf a system variable is used in the value, it will be expanded.\nThe define is cleared by the next +dvt_init+ directive.").put((Object)"cuname", (Object)"-cuname <name> files\nCompile the files under the specified package name.\nThe directive is enforced until either:\nanother -cuname directive is encountered;\n+dvt_init+ directive is encountered;\nthe end of the default.build file.").put((Object)"disable_ext", (Object)"THIS DIRECTIVE IS DEPRECATED!\nYou should use +dvt_ext_unmapped+<syntax> instead.\nIn dvt.vlog compatibility mode parse all unmapped files using System Verilog 1800-2009.\nIn dvt.vhdl compatibility mode parse all unmapped files using VHDL 1076-2000.").put((Object)"disable_ext+all", (Object)"THIS DIRECTIVE IS DEPRECATED!\nYou should use +dvt_ext_unmap_all instead.\nAll top files are parsed with the syntax for unmapped extensions, regardless of their extension.\nIf the syntax for unmapped extensions is SKIP the directive has no effect.\nThis directive takes precedence over other extension mapping directives.").put((Object)"dvt_prepend_init", (Object)"You can use a +dvt_prepend_init section to specify directives like +define, +dvt_setenv, +incdir etc. that are prepended to all +dvt_init sections. All directives between +dvt_prepend_init and the next +dvt_init will be \"copied\" in all subsequent +dvt_init sections.").put((Object)"dvt_init", (Object)"+dvt_init[+<compat_mode>]\nThis directive is used to specify a compatibility mode.\nEquivalent with a new invocation.\nIt resets all previous directives! Available compatibility modes are: dvt, ius.irun, xcelium.xrun, vcs.vlogan, vcs.vhdlan, questa.vlog, questa.vcom, questa.qrun, gcc, ius.perspec. If a compatibility mode is not specified, it defaults to: dvt.").put((Object)"dvt_init_auto", (Object)"+dvt_init_auto[+<compat_mode>]\nAutomatically identify and compile all the source files in the compilation root. The compilation root defaults to the project directory and can be changed using +dvt_compilation_root+ directive. Available compatibility modes are: dvt, ius.irun, xcelium.xrun, vcs.vhdlan, questa.vlog, questa.vcom, questa.qrun, gcc. If a compatibility mode is not specified, it defaults to: dvt.").put((Object)"dvt_init_xilinx", (Object)"+dvt_init_xilinx[+<lib1>+<lib2+...>]\nCompile the specified libraries from the $DVT_XILINX_HOME installation.").put((Object)"dvt_init_altera", (Object)"+dvt_init_altera[+<lib1>+<lib2+...>]\nCompile the specified libraries from the $QUARTUS_ROOTDIR installation.").put((Object)"dvt_init_questa_libs", (Object)"+dvt_init_questa_libs[+<lib1>+lib2+...>]\nCompile the specified libraries from the $MTI_HOME installation.").put((Object)"dvt_init_uvvm", (Object)"+dvt_init_uvvm\nCompile the UVVM library sources.").put((Object)"dvt_init_uvvm_vvc", (Object)"+dvt_init_uvvm_vvc\nCompile the UVVM_VVC library sources.\nList the source files of your VVC in a new invocation in the same library.").put((Object)"dvt_init_osvvm", (Object)"+dvt_init_osvvm\nCompile the OSVVM library sources.").put((Object)"dvt_init_from_simlog", (Object)"+dvt_init_from_simlog[+<compat_mode>]+<simulation_logfile>\nCompile using arguments extracted from the provided simulator log file.The simulator which generated the logfile is detected from its content, unless a compatibility mode is specified: ius.irun, xcelium.xrun, vcs.vlogan, vcs.vhdlan, questa.vsim and questa.vcom.").put((Object)"dvt_init_precompiled_db_load", (Object)"+dvt_init_precompiled_db_load\nThis directive is used to specify a precompiled library to load. Only one precompiled load invocation is allowed. The precompiled load invocation must be specified before any other invocation.").put((Object)"dvt_env", (Object)"+dvt_env+<var>=<value>\nDefine an environment variable.\nThe value is optional.\nIts value is visible for subsequent directives and during parsing.\nThe environment variable is cleared by the next +dvt_init+ directive.\nIf the variable is already defined in the underlying shell or by previous directives, it will be overridden.").put((Object)"dvt_setenv", (Object)"+dvt_setenv+<var>=<value>\nDefine an environment variable.\nThe value is optional.\nIts value is visible for subsequent directives and during parsing.\nThe environment variable is cleared by the next +dvt_init+ directive.\nIf the variable is already defined in the underlying shell or by previous directives, it will be overridden.").put((Object)"dvt_env_no_override", (Object)"+dvt_env_no_override+<var>=<value>\nDefine an environment variable.\nThe value is optional.\nIts value is visible for subsequent directives and during parsing.\nThe environment variable is cleared by the next +dvt_init+ directive.\nIf the variable is already defined in the underlying shell or by previous directives, it will not be overridden.").put((Object)"dvt_setenv_no_override", (Object)"+dvt_setenv_no_override+<var>=<value>\nDefine an environment variable.\nThe value is optional.\nIts value is visible for subsequent directives and during parsing.\nThe environment variable is cleared by the next +dvt_init+ directive.\nIf the variable is already defined in the underlying shell or by previous directives, it will not be overridden.").put((Object)"dvt_ext_included", (Object)"+dvt_ext_included+by_parent/by_ext\nSpecify the syntax for included files.\nby_parent: parsed with the same syntax as the including file.\nby_ext: parsed with the syntax to which the file's extension is currently mapped to.").put((Object)"dvt_extended_checks", (Object)"+dvt_extended_checks+auto\nBy default, during incremental build DVT performs only a subset of all the semantic checks.\nSpecify this directive to have all of the checks automatically performed at incremental build.").put((Object)"dvt_e_as_computed_translate_method", (Object)"DEPRECATED: Specify user-defined methods which are used in 'as computed' macros [<package_name>::]<struct_name>.<method_name>.\nThe <package> is optional and defaults to '''main''' if not specified.").put((Object)"dvt_e_as_computed_translate_method_disable", (Object)"Disable automatic translation of a particular 'e Language' method used by 'as computed' execution [<package_name>::]<struct_name>.<method_name>.\nThe <package> is optional and defaults to '''main''' if not specified.").put((Object)"dvt_defparam", (Object)"+dvt_defparam+<path.to.param>=<value>\nOverrides the parameter at the given hierarchy path with 'value'.\nWorks similar to SystemVerilog defparam statement, but has a higher priority and can also override localparams. Expressions are NOT allowed for override, only simple values!").put((Object)"dvt_ext_map", (Object)"+dvt_ext_map+<syntax>+<ext>\nFiles with extension <ext> will be parsed with <syntax>.").put((Object)"dvt_cdt_file_type_map", (Object)"+dvt_cdt_file_type_map+<CDT_file_type>+<name_or_ext>\nSpecify the CDT file type for a filename or file extension.<CDT_file_type> can be one of CPP_SOURCE, CPP_HEADER, C_SOURCE, C_HEADER<name_or_ext> is interpreted as file extension if it starts witha dot (like .cpp) or a filename otherwise.").put((Object)"dvt_ext_unmap", (Object)"+dvt_ext_unmap+<ext>\nFiles with extension <ext> will be parsed using the Language Syntax for unmapped extensions.").put((Object)"dvt_ext_unmapped_syntax", (Object)"+dvt_ext_unmapped_syntax+<syntax>\nSet the Language Syntax for Unmapped Extensions.").put((Object)"dvt_ext_unmap_all", (Object)"All files are parsed using the Language Syntax for Unmapped Extensions.").put((Object)"dvt_keyword_set", (Object)"+dvt_keyword_set+<kwset>\nTHIS DIRECTIVE IS DEPRECATED!\nAll the top files, library files or files in library directories which are specified after a\n+dvt_keyword_set+<kwset> directive will be compiled using <kwset> as keyword set (language syntax).").put((Object)"dvt_preprocess_translate_pragmas", (Object)"dvt_preprocess_translate_pragmas+<pragma1>+<pragma2>+...\nInstructs DVT to skip analyzing the code between pragmas such as \n\n// <pragma> translate_off \n<CODE>\n// <pragma> translate_on.\n\nYou can specify any number of pragmas as arguments to this directive, separated by '+';for example:\n+dvt_preprocess_translate_pragmas+pragma+synopsys+synthesis\n\nNOTE: In VHDL, the code background will be highlighted, but it will still be analyzed.").put((Object)"dvt_skip_ext", (Object)"+dvt_skip_ext+<ext>\nDo not parse top files with extension <ext>.\nThe dot (.) for specifying <ext> is optional.").put((Object)"dvt_test", (Object)"+dvt_test+<path>\nSpecify a top file and mark it as test.").put((Object)"dvt_undefine", (Object)"+dvt_undefine+<DEFINE_NAME>\n Undefines <DEFINE_NAME> preprocessing symbol. Equivalent with `undef <DEFINE_NAME>. The +dvt_undefine directives are applied on top of all other specified +defines. Ordering relative to other specified top files is relevant.").put((Object)"dvtcompat", (Object)"THIS DIRECTIVE IS DEPRECATED! Use +dvt_init+<compat_mode> instead").put((Object)"extinclude", (Object)"vcs.vlogan compatibility mode specific.\n\nThe included files are parsed using the syntax as specified by directives,\nthat is using by ext syntax (if explicit) or the syntax for unmapped extensions.\nIt overrides the default behavior.").put((Object)"incdir", (Object)"+incdir+<path/to/directory>\n-incdir <path/to/directory>\nIndicate search directories for files included with `include preprocessing directive.").put((Object)"libext", (Object)"+libext+<ext1>+<ext2>+...\nSpecify accepted extensions for files in the library directories.\nNote: there are no default extensions, .v and .sv don't have a special status.").put((Object)"librescan", (Object)"+librescan / -librescan\nWhen DVT finds an unresolved module reference in a library file or directory\nit will scan for the unresolved reference starting from the first specified library; by default\n(librescan not specified) it starts scanning from the library which introduced the unresolved reference\nand continues in the order in which libraries were specified.").put((Object)"libmap", (Object)"-libmap <path>\nSpecify the Verilog library map file.").put((Object)"ovmhome", (Object)"Equivalent to the default configuration directives for OVM libraries.\ni.e.: $OVM_HOME/src/ovm_pkg.sv ,+incdir+$OVM_HOME/src/. OVM_HOME must be set.").put((Object)"uvmhome", (Object)"Equivalent to the default configuration directives for UVM libraries.\ni.e.: $UVM_HOME/src/uvm_pkg.sv ,+incdir+$UVM_HOME/src/. UVM_HOME must be set.").put((Object)"uvmexthome", (Object)"Load the UVM extension files from the specified <path>. Should be used in conjunction with '-uvmhome'. Check out the 'All Build Directives' documentation chapter for a detailed description.").put((Object)"top", (Object)"-top <name> Specify top configuration name.").put((Object)"timescale", (Object)"-timescale <time_unit>/<time_precision> Set default timescale for modules.").put((Object)"override_timescale", (Object)"-override_timescale <time_unit>/<time_precision> Overrides all timescale specifications for modules.").put((Object)"dvt_e_vtop", (Object)"+dvt_e_vtop+\"pkg_name::SUBTYPE unit_name\" Specify a verification top unit.\nSubtype and package name are optional. Quotes are mandatory when specifying a subtype.\nMultiple top units may be specified.").put((Object)"uvm", (Object)"Load the UVM library. This directive has compatibility mode specific behavior. Check out the 'All Build Directives' documentation chapter for a detailed description.").put((Object)"ml_uvm", (Object)"Load the UVM_ML library. This directive has compatibility mode specific behavior. Check out the 'All Build Directives' documentation chapter for a detailed description.").put((Object)"ovm", (Object)"Load the OVM library. This directive has compatibility mode specific behavior. Check out the 'All Build Directives' documentation chapter for a detailed description.").put((Object)"vmm", (Object)"Load the VMM library. This directive has compatibility mode specific behavior. Check out the 'All Build Directives' documentation chapter for a detailed description.").put((Object)"pvalue", (Object)"vcs.vlogan, vcs.vhdlan compatibility mode specific.\n-pvalue+<path.to.param>=<value>\nOverrides the parameter at the given hierarchy path with 'value'.\nWorks similar to SystemVerilog defparam statement, but has a higher priority and can also override localparams. Expressions are NOT allowed for override, only simple values!").put((Object)"sverilog", (Object)"vcs.vlogan compatibility mode specific.\nSets the syntax for unmapped extensions to SystemVerilog.\nThis directive has precedence over +v2k.").put((Object)"systemverilogext", (Object)"vcs.vlogan compatibility mode specific.\n+systemverilogext+<ext>\nFiles with <ext> extension are parsed using the SystemVerilog syntax.\nMultiple extensions may be specified: <ext1>+<ext2>+... \nThe dot (.) for specifying the extension is optional.").put((Object)"v", (Object)"-v <path>\n Specify a Verilog library file.").put((Object)"v2k", (Object)"vcs.vlogan compatibility mode specific.\nSets the syntax for unmapped extensions to Verilog 2001.").put((Object)"verilog1995ext", (Object)"vcs.vlogan compatibility mode specific.\n+verilog1995ext+<ext>\nAll files with <ext> extension are parsed using the Verilog 1995 syntax.\nMultiple extensions may be specified: <ext1>+<ext2>+... \nThe dot (.) for specifying the extension is optional.").put((Object)"verilog2001ext", (Object)"vcs.vlogan compatibility mode specific.\n+verilog2001ext+<ext>\nAll files with <ext> extension are parsed using the Verilog 2001 syntax.\nMultiple extensions may be specified: <ext1>+<ext2>+... \nThe dot (.) for specifying the extension is optional.").put((Object)"vhdl87", (Object)"vcs.vhdlan compatibility mode specific.\nSets the syntax for unmapped extensions to VHDL 1076-1987.").put((Object)"y", (Object)"-y <path>\nSpecify a Verilog library directory.").put((Object)"f", (Object)"-f <path>\nSpecify an argument file to be included.").put((Object)"F", (Object)"-F <path>\nSpecify an argument file to be included.\nIts behaviour is not consistent across simulators, so DVT treats it according to the compatibility mode:\nvcs,dvt: when analyzing the contents of the included argument file,\nall relative paths are resolved as relative to the parent directory of the argument file\nit is equivalent to changing the compulation root to be the parent directory of the argument file;\n\nius: when analyzing the contents of the included argument file, relative paths are\nresolved as relative to the compilation root except for relative top file paths which are resolved as follows:\n\t- first, as relative to the parent directory of the argument file\n\t- if not found, as relative to the compilation root").put((Object)"dvt_include_build", (Object)"+dvt_include_build+<path>\nFunctionally identical to -F except that all relative paths are resolved as relative to the grandparent directory of the argument file.\nTypically used to reuse default.build files of related projects: relative paths specified within the included build file will be correctly solved as relative to the referred project\u2019s root directory.").put((Object)"work", (Object)"-work <lib_name>\nCompile top files into library <lib_name>.").put((Object)"w", (Object)"vcs.vhdlan compatibility mode specific.\n-w <lib_name>\nCompile top files into library <lib_name>").put((Object)"defparam", (Object)"xcelium.xrun compatibility mode specific.\n-defparam <path.to.param>=<value>\nOverrides the parameter at the given hierarchy path with 'value'.\nWorks similar to SystemVerilog defparam statement, but has a higher priority and can also override localparams. Expressions are NOT allowed for override, only simple values!").put((Object)"vlogext", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\n-vlogext <ext>\nAppends specified extension to the Verilog2001 mapping.\nMultiple extensions may be specified, seperated by a comma (,): -vlogext <ext1>,<ext2>,... \nThe dot (.) for specifying the extensions is mandatory.").put((Object)"vlog_ext", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\n-vlog_ext <ext>\nOverrides the extension mapping for Verilog2001.\nIf multiple -vlog_ext directives are used in the same invocation,\nthe first one will override the mapping and the rest will append the extensions.\nUsing a '+' in front of <ext> makes this directive behave the same as -vlogext, i.e.: -vlog_ext +<ext>.\nMultiple extensions may be specified, seperated by a comma (,): -vlog_ext <ext1>,<ext2>,... \nThe dot (.) for specifying the extensions is mandatory.").put((Object)"vlog95_ext", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\n-vlog95_ext <ext>\nOverrides the extension mapping for Verilog95.\nIf multiple -vlog95_ext directives are used in the same invocation,\nthe first one will override the default mapping and the rest will append the extensions.\nUsing a '+' in front of <ext> will no longer make this directive override the mapping.\nIt will simply append to it; i.e.: -vlog95_ext +<ext>.\nMultiple extensions may be specified, seperated by a comma (,): -vlog95_ext <ext1>,<ext2>,... \nThe dot (.) for specifying the extensions is mandatory.").put((Object)"sysv_ext", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\n-sysv_ext <ext>\nOverrides the extension mapping for SystemVerilog.\nIf multiple -sysv_ext directives are used in the same invocation,\nthe first one will override the mapping and the rest will append the extensions.\nUsing a '+' in front of <ext> will no longer make this directive override the mapping.\nIt will simply append to it; i.e.: -sysv_ext +<ext>.\nMultiple extensions may be specified, seperated by a comma (,): -sysv_ext <ext1>,<ext2>,... \nThe dot (.) for specifying the extensions is mandatory.").put((Object)"e_ext", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\n-e_ext <ext>\nOverrides the extension mapping for E.\nIf multiple -e_ext directives are used in the same invocation,\nthe first one will override the mapping and the rest will append the extensions.\nUsing a '+' in front of <ext> will no longer make this directive override the mapping.\nIt will simply append to it; i.e.: -e_ext +<ext>.\nMultiple extensions may be specified, seperated by a comma (,): -e_ext <ext1>,<ext2>,... \nThe dot (.) for specifying the extensions is mandatory.").put((Object)"vhdlext", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\n-vhdlext <ext>\nAppends specified extension to the VHDL mapping.\nMultiple extensions may be specified, seperated by a comma (,): -vhdlext <ext1>,<ext2>,... .\nThe dot (.) for specifying the extensions is mandatory.").put((Object)"vhdl_ext", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\n-vhdl_ext <ext>\nOverrides the extension mapping for VHDL.\nIf multiple -vhdl_ext directives are used in the same invocation,\nthe first one will override the mapping and the rest will append the extensions.\nUsing a '+' in front of <ext> will no longer make this directive override the mapping.\nIt will simply append to it; i.e.: -vhdl_ext +<ext>.\nMultiple extensions may be specified, seperated by a comma (,): -vhdl_ext <ext1>,<ext2>,... \nThe dot (.) for specifying the extensions is mandatory.").put((Object)"amsvlog_ext", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\n-amsvlog_ext <ext>\nOverrides the extension mapping for Verilog-AMS.\nIf multiple -amsvlog_ext directives are used in the same invocation,\nthe first one will override the mapping and the rest will append the extensions.\nUsing a '+' in front of <ext> will no longer make this directive override the mapping.\nIt will simply append to it; i.e.: -amsvlog_ext +<ext>.\nMultiple extensions may be specified, seperated by a comma (,): -amsvlog_ext <ext1>,<ext2>,... \nThe dot (.) for specifying the extensions is mandatory.").put((Object)"amsvhdl_ext", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\n-amsvhdl_ext <ext>\nOverrides the extension mapping for VHDL-AMS.\nIf multiple -amsvhdl_ext directives are used in the same invocation,\nthe first one will override the mapping and the rest will append the extensions.\nUsing a '+' in front of <ext> will no longer make this directive override the mapping.\nIt will simply append to it; i.e.: -amsvhdl_ext +<ext>.\nMultiple extensions may be specified, seperated by a comma (,): -amsvhdl_ext <ext1>,<ext2>,... \nThe dot (.) for specifying the extensions is mandatory.").put((Object)"default_ext", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\n-default_ext <syntax>\n Sets the syntax for unmapped extensions to <syntax>.").put((Object)"v1995", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\nEnforces Verilog95 as default syntax for all Verilog sources. Does not affect SystemVerilog sources.\nIf both this directive and -sv are used in the same invocation, -sv wins and -v1995 is ignored.").put((Object)"v95", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\nEnforces Verilog95 as default syntax for all Verilog sources. Does not affect SystemVerilog sources.\nIf both this directive and -sv are used in the same invocation, -sv wins and -v95 is ignored.").put((Object)"sv", (Object)"In ius.irun, xcelium.xrun, questa.vlog and questa.qrun compatibility mode, enforces SystemVerilog as default syntax for all Verilog sources.\n In ius.irun and xcelium.xrun modes, it has precedence over -v95 or -v1995.").put((Object)"v93", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\nEnforces VHDL-93 as default syntax for all VHDL sources.").put((Object)"v200x", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\nEnforces VHDL-2008 as default syntax for all VHDL sources.").put((Object)"ams", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\nEnforces AMS mode.\nThe language syntax for Verilog is changed to Verilog-AMS-2.3 and for VHDL is changed to VHDL-AMS-99.").put((Object)"svams_2019", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\nEnforces SV-AMS mode.\nThe language syntax for SystemVerilog is changed to SystemVerilog-AMS.").put((Object)"sndefine", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\n-sndefine <var>\nDeclares a preprocess define.").put((Object)"snpath", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\n-snpath <path>\nAppends the specified path to the SPECMAN_PATH environment variable.").put((Object)"snload", (Object)"ius.irun, xcelium.xrun compatibility mode specific.\n-snload <path>\nLoad the specified top file.").put((Object)"asext", (Object)"-asext <ext>[,<ext>]\nEquivalent to -as_ext +<ext>[,<ext>]").put((Object)"ccext", (Object)"-ccext <ext>\nEquivalent to -c_ext +<ext>[,<ext>]").put((Object)"cxxext", (Object)"-cxxext <ext>\nEquivalent to -cpp_ext +<ext>[,<ext>]").put((Object)"objext", (Object)"-objext <ext>\nEquivalent to -o_ext +<ext>[,<ext>]").put((Object)"a_ext", (Object)"-a_ext [+]<ext>[,<ext>]\nFiles with <ext> will be treated as Assembly files and will be skipped.").put((Object)"as_ext", (Object)"-as_ext [+]<ext>[,<ext>]\nFiles with <ext> will be treated as Assembly files and will be skipped.").put((Object)"c_ext", (Object)"-c_ext [+]<ext>[,<ext>]\nFiles with <ext> will be treated as C source files and will be skipped.").put((Object)"cpp_ext", (Object)"-cpp_ext [+]<ext>[,<ext>]\nFiles with <ext> will treated as C++ source files and will be be skipped.").put((Object)"dynlib_ext", (Object)"-dynlib_ext [+]<ext>[,<ext>]\nFiles with <ext> will be treated as Dynalib files and will be skipped.").put((Object)"o_ext", (Object)"-o_ext [+]<ext>[,<ext>]\nFiles with <ext> will be treated as Object files and will be skipped.").put((Object)"spice_ext", (Object)"-spice_ext [+]<ext>[,<ext>]\nFiles with <ext> will be treated as SPICE source files and will be skipped.").put((Object)"dvt_skip_compile", (Object)"+dvt_skip_compile+<pattern>[+not|+regex|+regex+not]\nInstructs DVT to skip analyzing the files whose absolute path matches the specified <pattern>.\nWhen specified without +regex+ you can use wildcards such as '*' (any string) and '?' (any character).\nWhen specified with +regex+ you can use any Perl-like regular expression.\nWhen prefixed with +not+ the paths which did not match the <pattern> are skipped.").put((Object)"dvt_shallow_compile", (Object)"+dvt_shallow_compile+<mode>[+not|+regex|+regex+not]+<pattern>\nInstructs DVT to shallow compile elements or paths, based on the specified <mode>. Available modes are: FILE, MODULE, FUNCTION.\nMatching for files is done based on absolute paths. Matching for modules and functions is done based on the fully qualified name.\nWhen specified without +regex+ you can use wildcards such as '*' (any string) and '?' (any character).\nWhen specified with +regex+ you can use any Perl-like regular expression.\nWhen prefixed with +not+ the elements or paths which did not match the <pattern> are shallow compiled.").put((Object)"G", (Object)"questa.vlog, questa.vcom compatibility mode specific.\n-G <path/to/param>=<value>\nOverrides the parameter at the given hierarchy path with 'value'.\nWorks similar to SystemVerilog defparam statement, but has a higher priority and can also override localparams. Expressions are NOT allowed for override, only simple values!").put((Object)"sv05compat", (Object)"questa.vlog compatibility mode specific.\n-sv05compat Use SystemVerilog 2005 syntax flavor").put((Object)"sv09compat", (Object)"questa.vlog compatibility mode specific.\n-sv09compat Use SystemVerilog 2009 syntax flavor").put((Object)"sv12compat", (Object)"questa.vlog compatibility mode specific.\n-sv12compat Use SystemVerilog 2012 syntax flavor").put((Object)"vlog95compat", (Object)"questa.vlog compatibility mode specific.\n-vlog95compat Use Verilog 1995 syntax flavor").put((Object)"vlog01compat", (Object)"questa.vlog compatibility mode specific.\n-vlog01compat  Use Verilog 2001 syntax flavor").put((Object)"svfilesuffix", (Object)"questa.vlog compatibility mode specific.\n-svfilesuffix=<ext1>[,<ext2>...] All files with <ext1>, <ext2>, ... extensions are parsed as SystemVerilog").put((Object)"87", (Object)"questa.vcom compatibility mode specific.\n-87 Enable support for VHDL 87").put((Object)"93", (Object)"questa.vcom compatibility mode specific.\n-93 Enable support for VHDL 93").put((Object)"2002", (Object)"questa.vcom compatibility mode specific.\n-2002 Enable support for VHDL 2002").put((Object)"2008", (Object)"questa.vcom compatibility mode specific.\n-2008 Enable support for VHDL 2008").put((Object)MinTypMax.MIN.getDirective().substring(1), (Object)MinTypMax.MIN.getHelp()).put((Object)MinTypMax.TYP.getDirective().substring(1), (Object)MinTypMax.TYP.getHelp()).put((Object)MinTypMax.MAX.getDirective().substring(1), (Object)MinTypMax.MAX.getHelp()).putAll(DIRECTIVE_KEYWORDS_HELP_TEXT).build();

    public static Map<String, String> initDirectiveKeywords() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (IBuildConfigParserConstants.Directive d : IBuildConfigParserConstants.Directive.values()) {
            if (IBuildConfigParserConstants.Directive.AUTOCONFIG_SCAN_ROOT.toString().equals(d.toString())) {
                result.put(String.valueOf(d.toString()) + "_add", d.getDescription());
                result.put(String.valueOf(d.toString()) + "_clear", d.getDescription());
                continue;
            }
            if (IBuildConfigParserConstants.Directive.E_SN_WHICH.toString().equals(d.toString())) {
                result.put(String.valueOf(d.toString()) + "_add", "By default, the following VIPs are located using sn_which.sh,\nand their locations are added to the $SPECMAN_PATH: evc_util, vr_ad, ovm_e, uvm_e.\nUse +dvt_sn_which_add+<vip1>+<vip2>+... to add to this list.");
                result.put(String.valueOf(d.toString()) + "_clear", "Clears the VIPs list.");
                continue;
            }
            if (IBuildConfigParserConstants.Directive.WAVEDROM_FILE_EXTENSION.toString().equals(d.toString())) {
                result.put(String.valueOf(d.toString()) + "_add", d.getDescription());
                result.put(String.valueOf(d.toString()) + "_clear", d.getDescription());
                continue;
            }
            if (IBuildConfigParserConstants.Directive.WAVEDROM_FILES_LOCATION.toString().equals(d.toString())) {
                result.put(String.valueOf(d.toString()) + "_add", d.getDescription());
                result.put(String.valueOf(d.toString()) + "_clear", d.getDescription());
                continue;
            }
            if (IBuildConfigParserConstants.Directive.NATURAL_DOCS_IMAGE_LOCATIONS.toString().equals(d.toString())) {
                result.put(String.valueOf(d.toString()) + "_add", d.getDescription());
                result.put(String.valueOf(d.toString()) + "_clear", d.getDescription());
                continue;
            }
            if (IBuildConfigParserConstants.Directive.DOCUMENTATION_RESOURCE_LOCATIONS.toString().equals(d.toString())) {
                result.put(String.valueOf(d.toString()) + "_add", d.getDescription());
                result.put(String.valueOf(d.toString()) + "_clear", d.getDescription());
                continue;
            }
            if (IBuildConfigParserConstants.Directive.PROFILE_PARSER.toString().equals(d.toString())) {
                result.put(String.valueOf(d.toString()) + "_add", d.getDescription());
                result.put(String.valueOf(d.toString()) + "_clear", d.getDescription());
                continue;
            }
            result.put(d.toString(), d.getDescription());
        }
        return result;
    }
}

