/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.buildconfig.editor.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.utils.DVTStringUtil;

public class BCCompletionProposal
implements ICompletionProposal {
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private String fAdditionalProposalInfo;
    private ITextViewer fViewer;

    public BCCompletionProposal(ITextViewer viewer, String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
        this(viewer, replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null);
    }

    public BCCompletionProposal(ITextViewer viewer, String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo == null ? null : additionalProposalInfo.replaceAll(">", "&gt;").replaceAll("<", "&lt;");
        this.fViewer = viewer;
    }

    public void apply(IDocument document) {
        try {
            DVTFileModificationValidator.validateEdit(this.fViewer);
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (CoreException | BadLocationException throwable) {}
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public String getAdditionalProposalInfo() {
        if (this.fAdditionalProposalInfo == null) {
            return null;
        }
        return this.textWrap(40, this.fAdditionalProposalInfo);
    }

    private String textWrap(int lineLength, String text) {
        StringBuilder wrapped = DVTStringUtil.textWrap(lineLength, text);
        return wrapped.toString().replaceAll("\u2028", "\n");
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }
}

