/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.buildconfig.editor.contentassist;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigEnum;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.IEnumProvider;
import ro.amiq.dvt.buildconfig.ShallowCompileMode;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.buildconfig.editor.BCEditor;
import ro.amiq.dvt.ui.buildconfig.editor.IBCConstants;
import ro.amiq.dvt.ui.buildconfig.editor.contentassist.BCCompletionProposal;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class BCContentAssistProcessorManager
implements IContentAssistProcessor,
ICompletionListener,
IBCConstants {
    private static final Pattern PATTERN_INIT_AUTO = Pattern.compile("\\+dvt_init_auto");
    private static final Pattern PATTERN_INIT_FROM_SIMLOG = Pattern.compile("\\+dvt_init_from_simlog");
    private static final Pattern PATTERN_INIT = Pattern.compile("\\+dvt_init");
    private static final Pattern HELP_KEY_PATTERN = Pattern.compile("^(?:[+-])?(\\w+)(?:\\+.*)?$");
    private static final String DVT_SHALLOW_COMPILE = "dvt_shallow_compile";
    private BCEditor fEditor;
    private IProject fProject;
    private ContentAssistant fContentAssistant;
    private IDocument fDocument;
    private int fOffset;
    private ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    private static final String SEPARATOR = ";";
    private static final Comparator ALPHABETICAL_ORDER = new Comparator(){

        public int compare(Object o1, Object o2) {
            String proposal1 = ((ICompletionProposal)o1).getDisplayString();
            String proposal2 = ((ICompletionProposal)o2).getDisplayString();
            return proposal1.compareTo(proposal2);
        }
    };
    private static final List<String> CFLAGS = Arrays.asList("-I", "-L");
    private static final List<String> DELIMS = Arrays.asList("=", "+");
    private static final Pattern envVarPattern = Pattern.compile("(\\$(?:env|::env)?\\(|\\$\\{?|%)([a-zA-Z0-9_-]*)$");

    public BCContentAssistProcessorManager(BCEditor editor, ContentAssistant assistant) {
        this.fEditor = editor;
        this.fContentAssistant = assistant;
        this.fProject = editor.getProject();
    }

    public void assistSessionStarted(ContentAssistEvent event) {
    }

    public void assistSessionEnded(ContentAssistEvent event) {
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        block3: {
            try {
                this.fOffset = offset;
                this.fDocument = viewer.getDocument();
                if (this.fDocument != null) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return this.NO_PROPOSALS;
            }
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        final String currentWord = this.lastWord(this.fDocument, offset);
        this.fContentAssistant.setStatusMessage("Build config directives");
        this.computeProposals(viewer, offset, currentWord, proposals);
        ICompletionProposal[] sortedProposals = new ICompletionProposal[proposals.size()];
        proposals.toArray(sortedProposals);
        Arrays.sort(sortedProposals, new Comparator<ICompletionProposal>(){

            @Override
            public int compare(ICompletionProposal o1, ICompletionProposal o2) {
                String proposal1 = o1.getDisplayString();
                String proposal2 = o2.getDisplayString();
                int index1 = proposal1.indexOf(currentWord);
                index1 = index1 == -1 ? Integer.MAX_VALUE : index1;
                int index2 = proposal2.indexOf(currentWord);
                index2 = index2 == -1 ? Integer.MAX_VALUE : index2;
                return index1 - index2;
            }
        }.thenComparing(ALPHABETICAL_ORDER));
        return sortedProposals;
    }

    private String lastWord(IDocument doc, int offset) {
        String result = "";
        try {
            int n = offset - 1;
            while (n >= 0) {
                char c = doc.getChar(n);
                if (c == ' ' || c == '\n') {
                    return doc.get(n + 1, offset - n - 1);
                }
                if (c == '+' || c == '-' || c == '$') {
                    if (n <= 0) {
                        return doc.get(n, offset - n);
                    }
                    if (doc.getChar(n - 1) == ' ' || doc.getChar(n - 1) == '\n') {
                        return doc.get(n, offset - n);
                    }
                }
                --n;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        try {
            result = doc.get(0, offset);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private void computeProposals(ITextViewer viewer, int offset, String currentWord, ArrayList<ICompletionProposal> proposals) {
        if (currentWord.equals("+dvt_init") || currentWord.startsWith("+dvt_init")) {
            this.computeInitProposals(viewer, offset, currentWord, proposals);
        }
        if (currentWord.equals("+dvt_ext_included+") || currentWord.startsWith("+dvt_ext_included+")) {
            this.computeExtIncludedProposals(viewer, offset, currentWord, proposals);
            return;
        }
        if (currentWord.equals("+dvt_ext_map+") || currentWord.startsWith("+dvt_ext_map+")) {
            this.computeSyntaxProposals(viewer, offset, currentWord, proposals, "\\+dvt_ext_map\\+");
            return;
        }
        if (currentWord.equals("+dvt_ext_unmapped_syntax+") || currentWord.startsWith("+dvt_ext_unmapped_syntax+")) {
            this.computeSyntaxProposals(viewer, offset, currentWord, proposals, "\\+dvt_ext_unmapped_syntax\\+");
            return;
        }
        this.computePathProposals(viewer, offset, currentWord, proposals, 128);
        this.computeEnvVarProposals(viewer, offset, currentWord, proposals);
        this.computeKeywordProposals(viewer, offset, currentWord, proposals);
        this.computeEnumProposals(viewer, offset, currentWord, proposals);
    }

    private void computeEnumProposals(ITextViewer viewer, int offset, String currentWord, ArrayList<ICompletionProposal> proposals) {
        if (!currentWord.startsWith("+")) {
            return;
        }
        String directiveString = currentWord = currentWord.substring(1);
        String directiveArgPart = "";
        boolean prependPlus = false;
        if (currentWord.contains("+")) {
            directiveString = currentWord.substring(0, currentWord.indexOf("+"));
            directiveArgPart = currentWord.substring(currentWord.lastIndexOf("+") + 1, currentWord.length());
        } else {
            prependPlus = true;
        }
        IBuildConfigParserConstants.Directive directive = IBuildConfigParserConstants.Directive.from(directiveString);
        if (directive == null) {
            return;
        }
        Class<?> directiveClass = null;
        if (directive.getDefaultValue() instanceof Enum) {
            directiveClass = directive.getDefaultValue().getClass();
        } else if (directive.getDefaultValue() instanceof IEnumProvider) {
            directiveClass = ((IEnumProvider)directive.getDefaultValue()).getEnumClass();
        } else if (directive.getDefaultValue() instanceof Enum[]) {
            directiveClass = directive.getDefaultValue().getClass().getComponentType();
        }
        if (directiveClass == null) {
            return;
        }
        ?[] objArray = directiveClass.getEnumConstants();
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object enumValue = objArray[n2];
            String enumName = enumValue.toString();
            if (!(enumValue instanceof IBuildConfigEnum && ((IBuildConfigEnum)enumValue).isDeprecatedBuildConfigEnum() || !enumName.startsWith(directiveArgPart.toUpperCase()))) {
                String replacementString = String.valueOf(prependPlus ? "+" : "") + enumName;
                String displayString = enumName;
                int replacementLength = directiveArgPart.length();
                int replacementOffset = offset - replacementLength;
                int cursorPosition = replacementString.length();
                proposals.add(new BCCompletionProposal(viewer, replacementString, replacementOffset, replacementLength, cursorPosition, null, displayString, null, IBCConstants.ALL_KEYWORDS_HELP_TEXT.get(directive.toString())));
            }
            ++n2;
        }
    }

    private void computeKeywordProposals(ITextViewer viewer, int offset, String currentWord, List<ICompletionProposal> proposals) {
        String keys = DVT_DIRECTIVES;
        keys = String.valueOf(keys) + this.computeKeywordsByProjectNature();
        LinkedHashSet keywords = new LinkedHashSet();
        Arrays.asList(keys.split(SEPARATOR)).forEach(k -> {
            boolean bl = keywords.add(k);
        });
        for (String keyword : keywords) {
            if ("+dvt_shallow_compile+".equals(keyword)) {
                this.computeShallowCompileProposals(viewer, offset, currentWord, keyword, proposals);
                continue;
            }
            if (keyword.equals(currentWord)) continue;
            if (currentWord.length() == 0 || keyword.toLowerCase().indexOf(currentWord.toLowerCase()) == 0) {
                if ("+dvt_skip_compile+not+".equals(keyword)) {
                    proposals.add(new BCCompletionProposal(viewer, keyword, offset - currentWord.length(), currentWord.length(), keyword.length(), null, keyword, null, IBCConstants.ALL_KEYWORDS_HELP_TEXT.get("dvt_skip_compile+not")));
                    continue;
                }
                if ("+dvt_skip_compile+regex+".equals(keyword)) {
                    proposals.add(new BCCompletionProposal(viewer, keyword, offset - currentWord.length(), currentWord.length(), keyword.length(), null, keyword, null, IBCConstants.ALL_KEYWORDS_HELP_TEXT.get("dvt_skip_compile+regex")));
                    continue;
                }
                if ("+dvt_skip_compile+regex+not+".equals(keyword)) {
                    proposals.add(new BCCompletionProposal(viewer, keyword, offset - currentWord.length(), currentWord.length(), keyword.length(), null, keyword, null, IBCConstants.ALL_KEYWORDS_HELP_TEXT.get("dvt_skip_compile+regex+not")));
                    continue;
                }
                proposals.add(new BCCompletionProposal(viewer, keyword, offset - currentWord.length(), currentWord.length(), keyword.length(), null, keyword, null, IBCConstants.ALL_KEYWORDS_HELP_TEXT.get(this.getHelpKey(keyword))));
                continue;
            }
            if (currentWord.length() <= 0) continue;
            boolean regionMatches = false;
            try {
                regionMatches = DVTStringUtil.regionMatches(keyword, currentWord, 4);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                regionMatches = false;
            }
            if (!regionMatches) continue;
            proposals.add(new BCCompletionProposal(viewer, keyword, offset - currentWord.length(), currentWord.length(), keyword.length(), null, keyword, null, IBCConstants.ALL_KEYWORDS_HELP_TEXT.get(this.getHelpKey(keyword))));
        }
    }

    private void computeShallowCompileProposals(ITextViewer viewer, int offset, String currentWord, String keyword, List<ICompletionProposal> proposals) {
        if (!"+dvt_shallow_compile+".startsWith(currentWord) && !currentWord.startsWith("+dvt_shallow_compile+")) {
            return;
        }
        if (currentWord.length() < keyword.length()) {
            proposals.add(new BCCompletionProposal(viewer, keyword, offset - currentWord.length(), currentWord.length(), keyword.length(), null, keyword, null, IBCConstants.ALL_KEYWORDS_HELP_TEXT.get(DVT_SHALLOW_COMPILE)));
            return;
        }
        ArrayList<String> shallowKeywordsModesOnly = new ArrayList<String>();
        ArrayList<String> shallowKeywords = new ArrayList<String>();
        ShallowCompileMode[] shallowCompileModeArray = ShallowCompileMode.values();
        int n = shallowCompileModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ShallowCompileMode enumValue = shallowCompileModeArray[n2];
            String enumName = enumValue.toString();
            shallowKeywordsModesOnly.add(String.valueOf(keyword) + enumName + "+");
            shallowKeywords.add(String.valueOf(keyword) + enumName + "+not+");
            shallowKeywords.add(String.valueOf(keyword) + enumName + "+regex+");
            shallowKeywords.add(String.valueOf(keyword) + enumName + "+not+regex+");
            ++n2;
        }
        boolean proposeShallowModes = false;
        for (String shallowKeyword : shallowKeywordsModesOnly) {
            if (!shallowKeyword.toLowerCase().startsWith(currentWord.toLowerCase()) || shallowKeyword.length() == currentWord.length()) continue;
            proposeShallowModes = true;
            proposals.add(new BCCompletionProposal(viewer, shallowKeyword, offset - currentWord.length(), currentWord.length(), shallowKeyword.length(), null, shallowKeyword, null, IBCConstants.ALL_KEYWORDS_HELP_TEXT.get(DVT_SHALLOW_COMPILE)));
        }
        if (proposeShallowModes) {
            return;
        }
        for (String shallowKeyword : shallowKeywords) {
            if (!shallowKeyword.toLowerCase().startsWith(currentWord.toLowerCase()) || shallowKeyword.length() == currentWord.length()) continue;
            proposeShallowModes = true;
            proposals.add(new BCCompletionProposal(viewer, shallowKeyword, offset - currentWord.length(), currentWord.length(), shallowKeyword.length(), null, shallowKeyword, null, IBCConstants.ALL_KEYWORDS_HELP_TEXT.get(DVT_SHALLOW_COMPILE)));
        }
    }

    private String getHelpKey(String keyword) {
        return DVTStringUtil.replaceAll(HELP_KEY_PATTERN, keyword, "$1");
    }

    private IPath getCurrentCompilationRoot() {
        try {
            IPath root = this.fProject.getLocation();
            int cursorLineNumber = BuildConfigManager.isBatchMode() ? this.fDocument.getLineOfOffset(this.fOffset) + 1 : this.fEditor.getCursorLineNumber();
            String compilationRoot = BuildConfigManager.getCompilationRoot(this.fProject, cursorLineNumber);
            if (compilationRoot != null && !compilationRoot.isEmpty()) {
                root = Path.fromOSString((String)compilationRoot);
            }
            return root;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private void computePathProposals(ITextViewer viewer, int offset, String currentWord, List<ICompletionProposal> proposals, int threshold) {
        IPath path;
        for (String flag : CFLAGS) {
            if (!currentWord.startsWith(flag)) continue;
            currentWord = currentWord.substring(flag.length());
        }
        ArrayList<String> delims = new ArrayList<String>(DELIMS);
        delims.addAll(CFLAGS);
        for (String delim : delims) {
            if (!currentWord.contains(delim)) continue;
            currentWord = currentWord.substring(currentWord.lastIndexOf(delim) + 1);
        }
        currentWord = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(currentWord, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, new DVTUtilsCommon.IEnvironmentProvider(){

            @Override
            public String getenv(String name) {
                Map<String, String> env = BCContentAssistProcessorManager.this.getEnvAtCursor();
                if (env == null || env.isEmpty()) {
                    return null;
                }
                return env.get(name);
            }
        });
        String filePrefix = "";
        if (!currentWord.isEmpty() && !currentWord.endsWith(File.separator)) {
            int index = currentWord.lastIndexOf(File.separator);
            if (index == -1) {
                filePrefix = currentWord;
                currentWord = "";
            } else {
                filePrefix = currentWord.substring(index + 1);
                currentWord = currentWord.substring(0, index + 1);
            }
        }
        if (!(path = Path.fromOSString((String)currentWord)).isAbsolute()) {
            IPath compilationRoot = this.getCurrentCompilationRoot();
            if (compilationRoot == null) {
                return;
            }
            path = compilationRoot.append(path);
        }
        String finalFilePrefix = filePrefix;
        File file = path.toFile();
        String[] children = file.list((dir, name) -> finalFilePrefix.length() == 0 || name.startsWith(finalFilePrefix));
        if (children != null) {
            int i = 0;
            while (i < Math.min(children.length, threshold)) {
                String name2 = children[i];
                if (!name2.equals(finalFilePrefix)) {
                    boolean isFolder = new File(file, name2).isDirectory();
                    Image image = isFolder ? DVTImages.imageCache.getImage(DVTImages.DESC_FOLDER) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_FILE);
                    proposals.add(new BCCompletionProposal(viewer, name2, offset - finalFilePrefix.length(), finalFilePrefix.length(), name2.length(), image, null, null, null));
                }
                ++i;
            }
            if (Math.min(children.length, threshold) == children.length) {
                this.fContentAssistant.setStatusMessage("Showing " + children.length + " files");
            } else {
                this.fContentAssistant.setStatusMessage("Only the first 128 file matches are shown");
            }
        }
    }

    private void computeEnvVarProposals(ITextViewer viewer, int offset, String currentWord, List<ICompletionProposal> proposals) {
        try {
            Matcher matcher = envVarPattern.matcher(currentWord);
            if (!matcher.find()) {
                return;
            }
            String closing = "";
            switch (matcher.group(1)) {
                case "%": {
                    closing = "%";
                    break;
                }
                case "$::env(": 
                case "$(": 
                case "$env(": {
                    closing = ")";
                    break;
                }
                case "${": {
                    closing = "}";
                    break;
                }
            }
            String fragment = matcher.group(2);
            Map<String, String> envVariables = this.getEnvAtCursor();
            if (envVariables == null || envVariables.isEmpty()) {
                return;
            }
            Set<String> keys = envVariables.keySet();
            for (String envVar : keys) {
                if ("_".equals(envVar) || "module".equals(envVar) || envVar.equals(fragment)) continue;
                boolean regionMatches = false;
                try {
                    regionMatches = DVTStringUtil.regionMatches(envVar, fragment, 4);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    regionMatches = false;
                }
                if (regionMatches) {
                    String replacementString = String.valueOf(envVar) + closing;
                    BCCompletionProposal proposal = new BCCompletionProposal(viewer, replacementString, offset - matcher.group(2).length(), matcher.group(2).length(), replacementString.length());
                    proposals.add(proposal);
                }
                this.fContentAssistant.setStatusMessage("System Variables");
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private Map<String, String> getEnvAtCursor() {
        try {
            int column;
            int line;
            String filePath = DVTFileUtils.getInstance().getFilePath(this.fEditor);
            if (BuildConfigManager.isBatchMode()) {
                line = this.fDocument.getLineOfOffset(this.fOffset) + 1;
                column = this.fOffset - this.fDocument.getLineOffset(line - 1);
            } else {
                line = this.fEditor.getCursorLineNumber();
                column = this.fEditor.getCursorColNumber();
            }
            return BuildConfigManager.getenv(this.fProject, filePath, line, column, true);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private void computeInitProposals(ITextViewer viewer, int offset, String currentWord, List<ICompletionProposal> proposals) {
        if (currentWord.startsWith("+dvt_init_xilinx")) {
            currentWord = currentWord.replaceAll("\\+dvt_init_xilinx", "");
            currentWord = currentWord.replaceAll("(?!\\+\\w+$)\\+\\w+", "");
            currentWord = currentWord.toUpperCase();
            IBuildConfigParserConstants.XilinxLibName[] xilinxLibNameArray = IBuildConfigParserConstants.XilinxLibName.values();
            int n = xilinxLibNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildConfigParserConstants.XilinxLibName xl = xilinxLibNameArray[n2];
                String name = "+" + xl.name();
                if (!(name.equals(currentWord) || name.length() != 0 && name.indexOf(currentWord) != 0)) {
                    proposals.add(new BCCompletionProposal(viewer, name, offset - currentWord.length(), currentWord.length(), name.length()));
                }
                ++n2;
            }
        } else if (currentWord.startsWith("+dvt_init_altera")) {
            currentWord = currentWord.replaceAll("\\+dvt_init_altera", "");
            currentWord = currentWord.replaceAll("(?!\\+\\w+$)\\+\\w+", "");
            currentWord = currentWord.toUpperCase();
            IBuildConfigParserConstants.AlteraLibName[] alteraLibNameArray = IBuildConfigParserConstants.AlteraLibName.values();
            int n = alteraLibNameArray.length;
            int n3 = 0;
            while (n3 < n) {
                IBuildConfigParserConstants.AlteraLibName alteraLibrary = alteraLibNameArray[n3];
                String name = "+" + alteraLibrary.name();
                if (!(name.equals(currentWord) || name.length() != 0 && name.indexOf(currentWord) != 0)) {
                    proposals.add(new BCCompletionProposal(viewer, name, offset - currentWord.length(), currentWord.length(), name.length()));
                }
                ++n3;
            }
        } else {
            String[] compatModes = "+dvt;+vcs.vlogan;+vcs.vhdlan;+ius.irun;+xcelium.xrun;+questa.vlog;+questa.vcom;+questa.qrun;+gcc;+ius.perspec".split(SEPARATOR);
            currentWord = DVTStringUtil.replaceAll(PATTERN_INIT_AUTO, currentWord, "");
            currentWord = DVTStringUtil.replaceAll(PATTERN_INIT_FROM_SIMLOG, currentWord, "");
            currentWord = DVTStringUtil.replaceAll(PATTERN_INIT, currentWord, "");
            int i = 0;
            while (i < compatModes.length) {
                String compatMode = compatModes[i];
                if (!(compatMode.equals(currentWord) || currentWord.length() != 0 && compatMode.indexOf(currentWord) != 0)) {
                    proposals.add(new BCCompletionProposal(viewer, compatMode, offset - currentWord.length(), currentWord.length(), compatMode.length()));
                }
                ++i;
            }
        }
    }

    private void computeExtIncludedProposals(ITextViewer viewer, int offset, String currentWord, List<ICompletionProposal> proposals) {
        String[] inclOptions = "by_ext;by_parent".split(SEPARATOR);
        currentWord = currentWord.replace("+dvt_ext_included+", "");
        int i = 0;
        while (i < inclOptions.length) {
            String option = inclOptions[i];
            if (!(option.equals(currentWord) || currentWord.length() != 0 && option.indexOf(currentWord) != 0)) {
                proposals.add(new BCCompletionProposal(viewer, option, offset - currentWord.length(), currentWord.length(), option.length()));
            }
            ++i;
        }
    }

    private void computeSyntaxProposals(ITextViewer viewer, int offset, String currentWord, List<ICompletionProposal> proposals, String pattern) {
        String[] syntaxNames = "Verilog_95;Verilog_2001_noconfig;Verilog_2001;Verilog_2005;Verilog_AMS_23;SystemVerilog_2005;SystemVerilog_2009;SystemVerilog_2012;SystemVerilog_2023;SystemVerilog;SystemVerilog_AMS;e_2011;e;VHDL_87;VHDL_93;VHDL_AMS_99;VHDL_2000;VHDL_2002;VHDL_AMS_2007;VHDL_2008;VHDL;SKIP;C;SDL".split(SEPARATOR);
        currentWord = currentWord.replaceAll(pattern, "");
        int i = 0;
        while (i < syntaxNames.length) {
            String syntaxName = syntaxNames[i];
            if (!(syntaxName.equals(currentWord) || currentWord.length() != 0 && syntaxName.indexOf(currentWord) != 0)) {
                proposals.add(new BCCompletionProposal(viewer, syntaxName, offset - currentWord.length(), currentWord.length(), syntaxName.length()));
            }
            ++i;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return "No proposals available";
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private String computeKeywordsByProjectNature() {
        StringBuilder keywords = new StringBuilder();
        try {
            if (this.fProject.hasNature("ro.amiq.slndt.slnnature")) {
                keywords.append(EDT_DIRECTIVES);
            }
            if (this.fProject.hasNature("ro.amiq.msdldt.msdlnature")) {
                keywords.append(EDT_DIRECTIVES);
            }
            if (this.fProject.hasNature("ro.amiq.pssdt.pssnature")) {
                keywords.append(EDT_DIRECTIVES);
            }
            if (this.fProject.hasNature("ro.amiq.edt.enature")) {
                keywords.append(EDT_DIRECTIVES);
            }
            if (this.fProject.hasNature("ro.amiq.vhdldt.VhdlNature")) {
                keywords.append(VHDLDT_DIRECTIVES);
            }
            if (this.fProject.hasNature("ro.amiq.vlogdt.VlogNature")) {
                keywords.append(VLOGDT_DIRECTIVES);
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return keywords.toString();
    }
}

