/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.buildconfig.editor.hover;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;

public class BCAnnotationHover
implements IAnnotationHover {
    private IFile fCurrentFile;

    public BCAnnotationHover(ITextEditor textEditor) {
        this.fCurrentFile = this.getFile(textEditor);
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        if (this.fCurrentFile == null) {
            return null;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return null;
        }
        try {
            ArrayList<String> messages = new ArrayList<String>();
            List<IMarker> allMarkers = Arrays.asList(this.fCurrentFile.findMarkers(DVTProblemCategories.BUILDCONFIG.getMarkerId(), false, 1));
            for (IMarker marker : allMarkers) {
                int markerLine = Integer.parseInt(marker.getAttribute("lineNumber").toString());
                if (markerLine != lineNumber + 1) continue;
                messages.add(DVTStringUtil.escapeXMLString(marker.getAttribute("message", ""), false));
            }
            if (!messages.isEmpty()) {
                return this.format(messages);
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    private IFile getFile(ITextEditor textEditor) {
        if (textEditor == null) {
            return null;
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return file;
    }

    private String format(List<String> messages) {
        StringBuilder buffer = new StringBuilder();
        if (messages.size() == 1) {
            buffer.append(messages.get(0));
        } else {
            Iterator<String> e = messages.iterator();
            while (e.hasNext()) {
                buffer.append("- ");
                buffer.append(e.next());
                if (!e.hasNext()) continue;
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }
}

