/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.buildconfig.editor.hover;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.CopyTooltipToClipboardHelper;
import ro.amiq.dvt.ui.buildconfig.editor.BCEditor;
import ro.amiq.dvt.ui.buildconfig.editor.hover.BCTextHoverCommon;
import ro.amiq.dvt.ui.editor.hover.DVTInformationControl;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipControlCreator;
import ro.amiq.dvt.ui.editor.hover.IDVTHover;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public class BCTextHover
extends BCTextHoverCommon
implements IDVTHover {
    public BCTextHover(ITextEditor editor) {
        if (!(editor instanceof BCEditor)) {
            return;
        }
        this.fEditor = (BCEditor)editor;
        this.fProject = this.fEditor.getProject();
        this.fResource = (IResource)this.fEditor.getAdapter(IResource.class);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion region) {
        if (textViewer == null || this.fEditor == null || region == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        return this.getHoverInfo(textViewer, document, region);
    }

    @Override
    protected void copyTooltipToClipboard(ITextViewer textViewer, int line, int column) {
        CopyTooltipToClipboardHelper.setLineAndColumn(line, column);
        DVTFileUtils fileUtilsInstance = DVTFileUtils.getInstance();
        IFile fileFromViewer = fileUtilsInstance != null ? fileUtilsInstance.getFileFromViewer(textViewer) : null;
        IPath relativePath = fileFromViewer != null ? fileFromViewer.getProjectRelativePath() : null;
        String filePath = relativePath == null ? "" : relativePath.lastSegment();
        CopyTooltipToClipboardHelper.setFile(filePath);
    }

    public IInformationControlCreator getHoverControlCreator() {
        try {
            return parent -> {
                if (CommentUtils.getInstance().shouldUseOldTooltip()) {
                    return new DVTInformationControl(parent, "Press 'F2' to focus");
                }
                return new DVTTooltipControlCreator(true).createInformationControl(parent);
            };
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }
}

