/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.buildconfig.editor.hover;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.buildconfig.editor.BCEditor;
import ro.amiq.dvt.ui.buildconfig.editor.IBCConstants;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public abstract class BCTextHoverCommon
implements ITextHover {
    protected static final Set<Character> DELIMITERS = new HashSet<Character>(Arrays.asList(Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('='), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf(' ')));
    private static final Pattern hiddenSpecialChar = Pattern.compile("\u2028");
    protected BCEditor fEditor;
    protected IProject fProject;
    protected IResource fResource;

    public String getHoverInfo(ITextViewer textViewer, IDocument document, IRegion region) {
        if (region == null || document == null) {
            return null;
        }
        String word = this.getWord(region.getOffset(), document);
        if (word == null) {
            return null;
        }
        int line = 1;
        int column = 1;
        try {
            line = document.getLineOfOffset(region.getOffset());
            column = region.getOffset() - document.getLineOffset(line);
            ++line;
            ++column;
            if (TestHelper.isTestMode()) {
                this.copyTooltipToClipboard(textViewer, line, column);
            }
        }
        catch (BadLocationException badLocationException) {}
        Map envVariables = this.fResource != null ? BuildConfigManager.getenv(this.fProject, this.fResource.getLocation().toOSString(), line, column, true) : Collections.emptyMap();
        String hoverText = null;
        if (IDVTConstants.SYSTEM_VARIABLE_PATTERN.matcher(word).find()) {
            hoverText = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(word, DVTUtilsCommon.ReplaceSysvarsPolicy.REPLACE_WITH_EMPTY, name -> (String)envVariables.get(name));
        } else if (IBCConstants.ALL_KEYWORDS_HELP_TEXT.containsKey(word)) {
            hoverText = IBCConstants.ALL_KEYWORDS_HELP_TEXT.get(word);
        } else if (envVariables.containsKey(word)) {
            hoverText = (String)envVariables.get(word);
        }
        return this.prepare(hoverText);
    }

    private String getWord(int offset, IDocument document) {
        try {
            char ch = document.getChar(offset);
            int n = offset;
            int m = offset + 1;
            while (n >= 0) {
                ch = document.getChar(n);
                if (DELIMITERS.contains(Character.valueOf(ch))) {
                    while (ch != '\uffff' && m < document.getLength()) {
                        ch = document.getChar(m);
                        if (DELIMITERS.contains(Character.valueOf(ch))) {
                            return document.get(n + 1, m - n - 1);
                        }
                        ++m;
                    }
                    return document.get(n + 1, m - n - 1);
                }
                --n;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    private String prepare(String text) {
        if (text == null) {
            return null;
        }
        text = DVTStringUtil.breakLongNonWhitespaceSequences(text, 75, '\n');
        text = DVTStringUtil.textWrap(40, hiddenSpecialChar.matcher(text).replaceAll("\n")).toString();
        text = DVTStringUtil.escapeXMLString(text, true);
        return text;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }

    protected abstract void copyTooltipToClipboard(ITextViewer var1, int var2, int var3);
}

