/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.buildconfig.editor.rules;

import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import ro.amiq.dvt.ui.buildconfig.editor.BCCodeScanner;
import ro.amiq.dvt.ui.buildconfig.editor.BCStyle;

public class BCKeywordRule
implements IRule {
    private IToken fDefaultKeywordToken;
    private int fLength = 0;
    private HashSet<String> fWords = new HashSet();
    private StringBuilder fBuffer = new StringBuilder();

    public BCKeywordRule(String[] words, IToken tokenKeyword, boolean enable) {
        Assert.isNotNull((Object)tokenKeyword);
        Assert.isNotNull((Object)words);
        this.fDefaultKeywordToken = tokenKeyword;
        int i = 0;
        while (i < words.length) {
            this.fWords.add(words[i]);
            ++i;
        }
    }

    public IToken evaluate(ICharacterScanner scanner) {
        try {
            char ch = (char)scanner.read();
            if (ch == '+' || ch == '-') {
                char starting_char = ch;
                if (((BCCodeScanner)scanner).getOffset() > 1) {
                    ((BCCodeScanner)scanner).unreadLength(2);
                    char prev_char = (char)scanner.read();
                    scanner.read();
                    if (!Character.isWhitespace(prev_char)) {
                        return Token.UNDEFINED;
                    }
                }
                this.fLength = 0;
                this.fBuffer.setLength(0);
                do {
                    if (!Character.isJavaIdentifierPart(ch)) continue;
                    this.fBuffer.append(ch);
                } while ((ch = (char)scanner.read()) != '\uffff' && Character.isJavaIdentifierPart(ch) && ch != '+');
                scanner.unread();
                String word = this.fBuffer.toString();
                if (word.startsWith("dvt") && !"dvt".equals(word)) {
                    if (word.startsWith("dvt_init") || word.equals("dvt_prepend_init")) {
                        return BCStyle.getInstance().getToken("highlight.init");
                    }
                    if (starting_char == '+') {
                        return this.fDefaultKeywordToken;
                    }
                } else {
                    if (word.equals("makelib") || word.equals("makelibpost") || word.equals("endlib") || word.equals("end") || word.equals("endprim") || word.equals("endsnstage") || word.equals("endfilemap") || word.equals("cpost") || word.equals("endprim") || word.equals("makeprim") || word.equals("snstage") || word.equals("snpresv") || word.equals("filemap")) {
                        return BCStyle.getInstance().getToken("highlight.irun_collection_keywords");
                    }
                    if (this.fWords.contains(word)) {
                        return BCStyle.getInstance().getToken("highlight.non_dvt");
                    }
                }
                this.fLength += this.fBuffer.length();
                ((BCCodeScanner)scanner).unreadLength(this.fLength);
                return Token.UNDEFINED;
            }
            if (Character.isDigit(ch)) {
                if (((BCCodeScanner)scanner).getOffset() > 1) {
                    ((BCCodeScanner)scanner).unreadLength(2);
                    ch = (char)scanner.read();
                    if (ch != ' ' && ch != '\n' && ch != '=' && ((BCCodeScanner)scanner).getOffset() > 0) {
                        ch = (char)scanner.read();
                        return Token.UNDEFINED;
                    }
                }
                ch = (char)scanner.read();
                this.fLength = 0;
                this.fBuffer.setLength(0);
                do {
                    this.fBuffer.append(ch);
                } while (Character.isDigit(ch = (char)scanner.read()) || ch == '_' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F' || ch == 'x' || ch == '\'' || ch == 'h');
                scanner.unread();
                return BCStyle.getInstance().getToken("highlight.number");
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
        catch (Exception exception) {
            return Token.UNDEFINED;
        }
    }
}

