/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.buildconfig.preferences;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.buildconfig.editor.BCSourceViewerConfiguration;
import ro.amiq.dvt.ui.buildconfig.editor.DocumentSetupParticipant;
import ro.amiq.dvt.ui.buildconfig.preferences.BCSourcePreviewerUpdater;
import ro.amiq.dvt.ui.preferences.DVTPreviewSourceViewer;
import ro.amiq.dvt.ui.preferences.OverlayPreferenceStore;

public class BCEditorSyntaxPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private OverlayPreferenceStore fOverlayStore;
    private ColorSelector fgEditor;
    private List fList;
    private Button fBoldCheckBox;
    private Button fItalicCheckBox;
    protected DVTPreviewSourceViewer fPreviewViewer;
    private final String[][] fListModel = new String[][]{{"Comments", "highlight.comment"}, {"Default", "highlight.default"}, {"DVT directives", "highlight.keyword"}, {"+dvt_init directives", "highlight.init"}, {"irun collection directive", "highlight.irun_collection_keywords"}, {"Numbers", "highlight.number"}, {"Non-DVT directive", "highlight.non_dvt"}, {"Strings", "highlight.string"}};

    protected OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.default.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.default.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.default.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.keyword.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyword.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyword.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.init.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.init.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.init.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.irun_collection_keywords.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.irun_collection_keywords.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.irun_collection_keywords.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.non_dvt.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.non_dvt.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.non_dvt.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.number.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.number.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.number.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.string.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.string.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.string.italic"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public BCEditorSyntaxPage() {
        this.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.createOverlayStoreKeys());
        this.setDescription(null);
    }

    public void init(IWorkbench workbench) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
    }

    protected Control createContents(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Link link = (Link)this.createLink(colorComposite);
        link.setFont(parent.getFont());
        link.setLayoutData((Object)new GridData(768));
        Label label = new Label(colorComposite, 16384);
        label.setFont(parent.getFont());
        label.setText("Fore&ground:");
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        colorComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        editorComposite.setLayoutData((Object)gd);
        this.fList = new List(editorComposite, 2564);
        this.fList.setFont(parent.getFont());
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        stylesComposite.setFont(parent.getFont());
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(stylesComposite, 16384);
        label.setFont(parent.getFont());
        label.setText("C&olor");
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fgEditor = new ColorSelector(stylesComposite);
        Button foregroundColorButton = this.fgEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setFont(parent.getFont());
        this.fBoldCheckBox.setText("&Bold");
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        this.fItalicCheckBox = new Button(stylesComposite, 32);
        this.fItalicCheckBox.setText("I&talic");
        this.fItalicCheckBox.setFont(parent.getFont());
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setFont(parent.getFont());
        label.setText("&Preview:");
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewer.setLayoutData((Object)gd);
        this.fList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BCEditorSyntaxPage.this.handleListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String key = BCEditorSyntaxPage.this.fListModel[BCEditorSyntaxPage.this.fList.getSelectionIndex()][1];
                PreferenceConverter.setValue((IPreferenceStore)BCEditorSyntaxPage.this.fOverlayStore, (String)(String.valueOf(key) + ".color"), (RGB)BCEditorSyntaxPage.this.fgEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String key = BCEditorSyntaxPage.this.fListModel[BCEditorSyntaxPage.this.fList.getSelectionIndex()][1];
                BCEditorSyntaxPage.this.fOverlayStore.setValue(String.valueOf(key) + ".bold", BCEditorSyntaxPage.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String key = BCEditorSyntaxPage.this.fListModel[BCEditorSyntaxPage.this.fList.getSelectionIndex()][1];
                BCEditorSyntaxPage.this.fOverlayStore.setValue(String.valueOf(key) + ".italic", BCEditorSyntaxPage.this.fItalicCheckBox.getSelection());
            }
        });
        this.initialize();
        return colorComposite;
    }

    private void initialize() {
        this.initializeFields();
        if (this.fList.getItems().length == 0) {
            int i = 0;
            while (i < this.fListModel.length) {
                this.fList.add(this.fListModel[i][0]);
                ++i;
            }
        }
        this.fList.setSelection(0);
        this.fList.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                BCEditorSyntaxPage.this.fList.select(0);
                BCEditorSyntaxPage.this.handleListSelection();
            }
        });
    }

    private void initializeFields() {
        IPreferenceStore prefs = this.getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)prefs, (String)"highlight.default.color");
        this.fgEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(prefs.getBoolean("highlight.default.bold"));
        this.fItalicCheckBox.setSelection(prefs.getBoolean("highlight.default.italic"));
    }

    protected void handleListSelection() {
        String key = this.fListModel[this.fList.getSelectionIndex()][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)(String.valueOf(key) + ".color"));
        this.fgEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.fOverlayStore.getBoolean(String.valueOf(key) + ".bold"));
        this.fItalicCheckBox.setSelection(this.fOverlayStore.getBoolean(String.valueOf(key) + ".italic"));
    }

    private Control createLink(Composite contents) {
        final Link link = new Link(contents, 0);
        link.setText("Font type can be configured on the <a href=\"org.eclipse.ui.preferencePages.ColorsAndFonts\">Colors and Fonts</a> preference page.");
        DVTUiUtils.setPlatformLinkColor((Link)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)e.text, null, null);
            }
        });
        String linktooltip = "Go To 'Colors and Fonts' Preference Page";
        link.setToolTipText(linktooltip);
        return link;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return DVTPlugin.getDefault().getPreferenceStore();
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        DVTPlugin.getDefault().savePreferences();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        super.performDefaults();
        this.handleListSelection();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    private Control createPreviewer(Composite parent) {
        BCSourceViewerConfiguration configuration = new BCSourceViewerConfiguration(null);
        this.fPreviewViewer = new DVTPreviewSourceViewer(parent, 2816);
        this.fPreviewViewer.setPreferenceStore(DVTPlugin.getDefault().getCombinedPreferenceStore());
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        this.fPreviewViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.fPreviewViewer.setEditable(false);
        String content = this.loadPreviewContentFromFile("ColorSettingsPreviewCode");
        Document document = new Document(content);
        DocumentSetupParticipant docSetup = new DocumentSetupParticipant();
        docSetup.setup((IDocument)document);
        this.fPreviewViewer.setDocument((IDocument)document);
        BCSourcePreviewerUpdater.registerPreviewer(this.fPreviewViewer, configuration, this.fOverlayStore);
        return this.fPreviewViewer.getControl();
    }

    private String loadPreviewContentFromFile(String filename) {
        StringBuilder buffer;
        block15: {
            String separator = System.getProperty("line.separator");
            buffer = new StringBuilder(512);
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename)));
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append(separator);
                    }
                }
                catch (IOException io) {
                    DVTLogger.INSTANCE.logError((Throwable)io);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buffer.toString();
    }
}

