/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.buildconfig.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;

public class BCGeneralPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IDialogConstants {
    private Combo fTriggerAutobuild;
    private Button fAutoBuildButton;
    private Button fPerformAutoBuildCheckButton;
    private Button fEnableCancelOngoingIncremental;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().hint(parent.computeSize(-1, -1)).applyTo((Control)composite);
        Group autoBuildGroup = new Group(composite, 16);
        autoBuildGroup.setFont(parent.getFont());
        autoBuildGroup.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)autoBuildGroup);
        autoBuildGroup.setText("Build Automatically");
        this.fAutoBuildButton = new Button((Composite)autoBuildGroup, 32);
        this.fAutoBuildButton.setFont(parent.getFont());
        this.fAutoBuildButton.setText("Build automatically after ");
        this.fAutoBuildButton.setSelection(DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.TRIGGER_AUTOBUILD_ENABLE"));
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)this.fAutoBuildButton);
        this.fTriggerAutobuild = new Combo((Composite)autoBuildGroup, 2048);
        this.fTriggerAutobuild.setFont(parent.getFont());
        this.fTriggerAutobuild.setEnabled(this.fAutoBuildButton.getSelection());
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).hint(65, -1).applyTo((Control)this.fTriggerAutobuild);
        this.fAutoBuildButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BCGeneralPage.this.fTriggerAutobuild.setEnabled(BCGeneralPage.this.fAutoBuildButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fTriggerAutobuild.setItems(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"});
        this.fTriggerAutobuild.setText(DVTPlugin.getDefault().getPreferenceStore().getString("ro.amiq.dvt.TRIGGER_AUTOBUILD_VALUE"));
        this.fTriggerAutobuild.setTextLimit(3);
        this.fTriggerAutobuild.addModifyListener(e -> {
            this.setValid(true);
            this.setErrorMessage(null);
            String autoBuildTime = this.fTriggerAutobuild.getText();
            int value = 0;
            try {
                value = Integer.parseInt(autoBuildTime);
                if (value < 1) {
                    this.setErrorMessage("Build automatic time must be valid, positive number!");
                    this.setValid(false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("'" + autoBuildTime + "' is not a valid number!");
                this.setValid(false);
            }
        });
        Label textInfoLabel = new Label((Composite)autoBuildGroup, 0);
        textInfoLabel.setFont(parent.getFont());
        textInfoLabel.setText("seconds.");
        Label infoLabel1 = new Label((Composite)autoBuildGroup, 0);
        infoLabel1.setFont(parent.getFont());
        infoLabel1.setText("When changed, the current file is re-built after the specified number of inactivity seconds.");
        GridDataFactory.fillDefaults().align(1, 128).span(3, 1).grab(true, false).applyTo((Control)infoLabel1);
        this.fEnableCancelOngoingIncremental = new Button((Composite)autoBuildGroup, 32);
        this.fEnableCancelOngoingIncremental.setFont(parent.getFont());
        this.fEnableCancelOngoingIncremental.setToolTipText("Cancel ongoing incremental build when a new one is triggered.");
        this.fEnableCancelOngoingIncremental.setText("Non-blocking incremental build");
        this.fEnableCancelOngoingIncremental.setSelection(PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE"));
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)this.fEnableCancelOngoingIncremental);
        Group autoBuildCheckGroup = new Group(composite, 16);
        autoBuildCheckGroup.setFont(parent.getFont());
        autoBuildCheckGroup.setLayout((Layout)new GridLayout());
        autoBuildCheckGroup.setText("Check for Disabled Incremental Build");
        this.fPerformAutoBuildCheckButton = new Button((Composite)autoBuildCheckGroup, 32);
        this.fPerformAutoBuildCheckButton.setFont(parent.getFont());
        this.fPerformAutoBuildCheckButton.setText("Check and report if incremental build is disabled at platform startup");
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.fPerformAutoBuildCheckButton);
        this.fPerformAutoBuildCheckButton.setSelection(DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.PERFORM_AUTOBUILD_DISABLED_CHECK"));
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).hint(autoBuildCheckGroup.computeSize((int)-1, (int)-1).x, -1).applyTo((Control)autoBuildCheckGroup);
        Label explanation = new Label((Composite)autoBuildCheckGroup, 64);
        explanation.setFont(parent.getFont());
        explanation.setText("When incremental build is disabled, DVT's advanced functionality is reduced: errors are not signaled as you type, autocomplete and hyperlinks are innaccurate and views content is incomplete.");
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).hint(-1, autoBuildCheckGroup.computeSize((int)-1, (int)-1).y).applyTo((Control)explanation);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.fPerformAutoBuildCheckButton.setSelection(DVTPlugin.getDefault().getPreferenceStore().getDefaultBoolean("ro.amiq.dvt.PERFORM_AUTOBUILD_DISABLED_CHECK"));
        this.fAutoBuildButton.setSelection(DVTPlugin.getDefault().getPreferenceStore().getDefaultBoolean("ro.amiq.dvt.TRIGGER_AUTOBUILD_ENABLE"));
        this.fEnableCancelOngoingIncremental.setSelection(DVTPlugin.getDefault().getPreferenceStore().getDefaultBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE"));
        this.fTriggerAutobuild.setEnabled(this.fAutoBuildButton.getSelection());
        this.fTriggerAutobuild.setText("" + DVTPlugin.getDefault().getPreferenceStore().getDefaultInt("ro.amiq.dvt.TRIGGER_AUTOBUILD_VALUE"));
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("ro.amiq.dvt.PERFORM_AUTOBUILD_DISABLED_CHECK", this.fPerformAutoBuildCheckButton.getSelection());
        this.getPreferenceStore().setValue("ro.amiq.dvt.TRIGGER_AUTOBUILD_ENABLE", this.fAutoBuildButton.getSelection());
        this.getPreferenceStore().setValue("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE", this.fEnableCancelOngoingIncremental.getSelection());
        this.getPreferenceStore().setValue("ro.amiq.dvt.TRIGGER_AUTOBUILD_VALUE", Integer.parseInt(this.fTriggerAutobuild.getText()));
        DVTPlugin.getDefault().savePreferences();
        return true;
    }
}

