/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.codetemplates;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.codetemplates.TemplatesPreferencePage;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;

public class CodeTemplatesPropertyPage
extends TemplatesPreferencePage
implements IWorkbenchPropertyPage {
    private static final String KEY_TEMPLATES = "templates";
    private ProjectTemplatesPrefStore fPrefStore = new ProjectTemplatesPrefStore();
    private TemplateStore fTemplateStore;
    private IAdaptable fElement;
    private boolean fValid = true;

    public CodeTemplatesPropertyPage() {
        this.setPreferenceStore((IPreferenceStore)this.fPrefStore);
        this.fTemplateStore = new TemplateStore((IPreferenceStore)this.fPrefStore, KEY_TEMPLATES);
        this.setTemplateStore(this.fTemplateStore);
    }

    @Override
    protected void openLink() {
        PreferenceDialog pref = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)this.getPreferencePageName(), null, null);
        if (pref != null) {
            pref.open();
        }
    }

    public IAdaptable getElement() {
        return this.fElement;
    }

    public void setElement(IAdaptable element) {
        this.fElement = element;
        this.getTemplateCategories();
        try {
            this.fTemplateStore.load();
        }
        catch (IOException e) {
            this.fValid = false;
            File projectTemplatesFile = this.getProjectTemplatesFile();
            if (projectTemplatesFile != null) {
                this.showFileFormatMessageDialog(projectTemplatesFile.getAbsolutePath());
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected IProject getProject() {
        if (this.fElement == null) {
            return DVTPlugin.getSelectionManager().getLastSelectedProject();
        }
        return (IProject)this.fElement.getAdapter(IProject.class);
    }

    private String getProjectTemplatesFileContent() {
        StringBuilder result = new StringBuilder();
        File f2 = this.getProjectTemplatesFile();
        if (f2 == null) {
            return result.toString();
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(f2));){
                String line;
                while ((line = br.readLine()) != null) {
                    result.append(line).append(System.getProperty("line.separator"));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result.toString();
    }

    private void setProjectTemplatesFileContent(String content) {
        File f2 = this.getProjectTemplatesFile();
        if (f2 == null || !f2.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(f2));){
                bw.write(content);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private File getProjectTemplatesFile() {
        IProject project = this.getProject();
        if (project == null) {
            this.showFileAccessMessageDialog("Project root");
            return null;
        }
        File dotDVT = project.getLocation().append(".dvt").toFile();
        if (!dotDVT.exists() && !dotDVT.mkdir()) {
            this.showFileAccessMessageDialog(dotDVT.getAbsolutePath());
            return null;
        }
        File result = new File(dotDVT, this.getCodeTemplatesFileName());
        if (!result.exists()) {
            try {
                result.createNewFile();
            }
            catch (Exception e) {
                this.showFileAccessMessageDialog(dotDVT.getAbsolutePath());
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return result;
    }

    private void showFileAccessMessageDialog(String what) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (shell == null) {
            return;
        }
        new MessageDialog(shell, "File access error", null, String.valueOf(what) + " could not be accessed.\nPlease check its permissions.", 1, new String[]{IDialogConstants.OK_LABEL}, 0).open();
    }

    private void showFileFormatMessageDialog(String path) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (shell == null) {
            return;
        }
        new MessageDialog(shell, "Bad file format", null, "Could not parse templates from " + path + "\nPlease review file format.", 1, new String[]{IDialogConstants.OK_LABEL}, 0).open();
    }

    public boolean isValid() {
        return this.fValid;
    }

    @Override
    protected void refreshTemplates() {
        this.fStyledTextLabel.setText(this.removeLinksMarkup("NOTE: " + this.getNote()));
        this.fPartitioner = TemplatesViewUtils.getDocumentPartitioner(this.fNatureName);
        this.fSourceViewer.unconfigure();
        this.fSourceViewer.configure(TemplatesViewUtils.getSourceViewerConfiguration(this.fNatureName));
        Document document = new Document();
        this.fPartitioner.connect((IDocument)document);
        document.setDocumentPartitioner(this.fPartitioner);
        this.fSourceViewer.setDocument((IDocument)document);
        this.fSourceViewer.refresh();
        try {
            this.fTemplateStore.load();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.setTemplateStore(this.fTemplateStore);
        this.setContextTypeRegistry(TemplatesViewUtils.getContextTypeRegistry(this.fNatureName));
        this.getTableViewer().getContentProvider().inputChanged(null, null, (Object)this.fTemplateStore);
        this.getTableViewer().refresh();
        this.getTableViewer().getTable().update();
        this.getViewer().refresh();
        this.updateViewerInput();
    }

    @Override
    protected List<String> getTemplateCategories() {
        IProject project = this.getProject();
        LinkedList<String> naturesTmp = new LinkedList<String>();
        try {
            if (Platform.getBundle((String)"ro.amiq.vhdldt") != null && (project == null || project.hasNature("ro.amiq.vhdldt.VhdlNature"))) {
                naturesTmp.add("VHDL");
                this.fNatureName = "ro.amiq.vhdldt.VhdlNature";
            }
            if (Platform.getBundle((String)"ro.amiq.vlogdt") != null && (project == null || project.hasNature("ro.amiq.vlogdt.VlogNature"))) {
                naturesTmp.add("SystemVerilog");
                this.fNatureName = "ro.amiq.vlogdt.VlogNature";
            }
            if (Platform.getBundle((String)"ro.amiq.edt") != null && (project == null || project.hasNature("ro.amiq.edt.enature"))) {
                naturesTmp.add("e Language");
                this.fNatureName = "ro.amiq.edt.enature";
            }
            if (Platform.getBundle((String)"ro.amiq.slndt") != null && (project == null || project.hasNature("ro.amiq.slndt.slnnature"))) {
                naturesTmp.add("SLN");
                this.fNatureName = "ro.amiq.slndt.slnnature";
            }
            if (Platform.getBundle((String)"ro.amiq.msdldt") != null && (project == null || project.hasNature("ro.amiq.msdldt.msdlnature"))) {
                naturesTmp.add("M-SDL");
                this.fNatureName = "ro.amiq.msdldt.msdlnature";
            }
            if (Platform.getBundle((String)"ro.amiq.pssdt") != null && (project == null || project.hasNature("ro.amiq.pssdt.pssnature"))) {
                naturesTmp.add("PSS");
                this.fNatureName = "ro.amiq.pssdt.pssnature";
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        Collections.sort(naturesTmp);
        return naturesTmp;
    }

    protected String getCodeTemplatesFileName() {
        if (this.fNatureName == null) {
            return "";
        }
        if (this.fNatureName.equals("ro.amiq.edt.enature")) {
            return "edt_code_templates.xml";
        }
        if (this.fNatureName.equals("ro.amiq.slndt.slnnature")) {
            return "sln_code_templates.xml";
        }
        if (this.fNatureName.equals("ro.amiq.msdldt.msdlnature")) {
            return "msdl_code_templates.xml";
        }
        if (this.fNatureName.equals("ro.amiq.pssdt.pssnature")) {
            return "pss_code_templates.xml";
        }
        if (this.fNatureName.equals("ro.amiq.vlogdt.VlogNature")) {
            return "vlog_code_templates.xml";
        }
        return "vhdl_code_templates.xml";
    }

    @Override
    protected String getNote() {
        return "These are project specific code templates.\nYou can configure the global templates from the <a>Global Code Templates preference page.</a>";
    }

    protected String getPreferencePageName() {
        return "ro.amiq.dvt.ui.codetemplates.TemplatesPreferencePage";
    }

    class ProjectTemplatesPrefStore
    extends PreferenceStore {
        ProjectTemplatesPrefStore() {
        }

        public String getString(String name) {
            if (CodeTemplatesPropertyPage.KEY_TEMPLATES.equals(name)) {
                return CodeTemplatesPropertyPage.this.getProjectTemplatesFileContent();
            }
            return null;
        }

        public String getDefaultString(String name) {
            return this.getString(name);
        }

        public void setValue(String name, String value) {
            if (CodeTemplatesPropertyPage.KEY_TEMPLATES.equals(name)) {
                CodeTemplatesPropertyPage.this.setProjectTemplatesFileContent(value);
            }
        }

        public void save() throws IOException {
        }

        public void load() throws IOException {
        }
    }
}

