/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.codetemplates;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.texteditor.templates.TemplatePreferencePage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.preferences.DVTPreviewSourceViewer;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class TemplatesPreferencePage
extends TemplatePreferencePage {
    private static final String NOTE = "Note:";
    protected String fNatureName;
    protected IDocumentPartitioner fPartitioner;
    protected Link fStyledTextLabel;
    protected DVTPreviewSourceViewer fSourceViewer;
    private Text fSearchText;
    private StringMatcher fSearchMatcher = new StringMatcher("*", true, false);
    private Combo fTemplateCategoryCombo;

    public TemplatesPreferencePage() {
        this.getTemplateCategories();
        if (this.fNatureName == null) {
            this.fNatureName = "ro.amiq.vlogdt.VlogNature";
        }
        this.setTemplateStore(TemplatesViewUtils.getTemplateStore(null, this.fNatureName, true));
        this.setContextTypeRegistry(TemplatesViewUtils.getContextTypeRegistry(this.fNatureName));
    }

    protected Control createContents(Composite ancestor) {
        this.createCustomContent(ancestor);
        Control superControl = super.createContents(ancestor);
        TableViewer tableViewer = this.getTableViewer();
        tableViewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof TemplatePersistenceData) {
                    return TemplatesPreferencePage.this.fSearchMatcher.match(((TemplatePersistenceData)element).getTemplate().getName());
                }
                return true;
            }
        }});
        if (tableViewer instanceof CheckboxTableViewer) {
            ((CheckboxTableViewer)tableViewer).setCheckStateProvider(new ICheckStateProvider(){

                public boolean isGrayed(Object element) {
                    return false;
                }

                public boolean isChecked(Object element) {
                    if (element instanceof TemplatePersistenceData) {
                        return ((TemplatePersistenceData)element).isEnabled();
                    }
                    return true;
                }
            });
        }
        return superControl;
    }

    protected void createCustomContent(Composite ancestor) {
        Composite container = new Composite(ancestor, 0);
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.marginHeight = 0;
        containerLayout.marginWidth = 0;
        container.setLayout((Layout)containerLayout);
        container.setLayoutData((Object)new GridData(4, 1024, true, false));
        Label langSelectorLabel = new Label(container, 0);
        langSelectorLabel.setText("Select nature:");
        langSelectorLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fTemplateCategoryCombo = new Combo(container, 8);
        List<String> naturesTmp = this.getTemplateCategories();
        this.fTemplateCategoryCombo.setItems(naturesTmp.toArray(new String[0]));
        this.fTemplateCategoryCombo.setLayoutData((Object)new GridData(16384, 4, false, false));
        if (this.fNatureName != null) {
            if (this.fNatureName.equals("ro.amiq.vlogdt.VlogNature")) {
                this.fTemplateCategoryCombo.setText("SystemVerilog");
            } else if (this.fNatureName.equals("ro.amiq.edt.enature")) {
                this.fTemplateCategoryCombo.setText("e Language");
            } else if (this.fNatureName.equals("ro.amiq.slndt.slnnature")) {
                this.fTemplateCategoryCombo.setText("SLN");
            } else if (this.fNatureName.equals("ro.amiq.msdldt.msdlnature")) {
                this.fTemplateCategoryCombo.setText("M-SDL");
            } else if (this.fNatureName.equals("ro.amiq.pssdt.pssnature")) {
                this.fTemplateCategoryCombo.setText("PSS");
            } else if (this.fNatureName.equals("ro.amiq.vhdldt.VhdlNature")) {
                this.fTemplateCategoryCombo.setText("VHDL");
            }
        }
        this.fTemplateCategoryCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TemplatesPreferencePage.this.fNatureName = TemplatesPreferencePage.this.fTemplateCategoryCombo.getText().equals("VHDL") ? "ro.amiq.vhdldt.VhdlNature" : (TemplatesPreferencePage.this.fTemplateCategoryCombo.getText().equals("e Language") ? "ro.amiq.edt.enature" : (TemplatesPreferencePage.this.fTemplateCategoryCombo.getText().equals("SLN") ? "ro.amiq.slndt.slnnature" : (TemplatesPreferencePage.this.fTemplateCategoryCombo.getText().equals("M-SDL") ? "ro.amiq.msdldt.msdlnature" : (TemplatesPreferencePage.this.fTemplateCategoryCombo.getText().equals("PSS") ? "ro.amiq.pssdt.pssnature" : "ro.amiq.vlogdt.VlogNature"))));
                TemplatesPreferencePage.this.refreshTemplates();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        String text = "Note: " + this.getNote();
        this.fStyledTextLabel = new Link(container, 0);
        this.fStyledTextLabel.setText(text);
        DVTUiUtils.setPlatformLinkColor((Link)this.fStyledTextLabel);
        this.fStyledTextLabel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TemplatesPreferencePage.this.openLink();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        GridData layoutData = new GridData(4, 4, true, false, 2, 1);
        layoutData.widthHint = 100;
        this.fStyledTextLabel.setLayoutData((Object)layoutData);
        Label quickSearchLabel = new Label(container, 0);
        quickSearchLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        quickSearchLabel.setText("Filter templates:");
        this.fSearchText = new Text(container, 2048);
        this.fSearchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        DVTColorUtil.INSTANCE.setForeground((Control)this.fSearchText, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.foregroundColor"), true);
        this.fSearchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text;
                String string = text = TemplatesPreferencePage.this.fSearchText.getText() == null ? "" : TemplatesPreferencePage.this.fSearchText.getText();
                if (text.length() == 0) {
                    DVTColorUtil.INSTANCE.setBackground((Control)TemplatesPreferencePage.this.fSearchText, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.emptyBackgroundColor"));
                } else {
                    DVTColorUtil.INSTANCE.setBackground((Control)TemplatesPreferencePage.this.fSearchText, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.backgroundColor"));
                }
                TemplatesPreferencePage.this.fSearchMatcher = new StringMatcher("*" + text + "*", true, false);
                TemplatesPreferencePage.this.getTableViewer().refresh();
            }
        });
    }

    protected List<String> getTemplateCategories() {
        LinkedList<String> naturesTmp = new LinkedList<String>();
        try {
            if (Platform.getBundle((String)"ro.amiq.vhdldt") != null) {
                naturesTmp.add("VHDL");
                this.fNatureName = "ro.amiq.vhdldt.VhdlNature";
            }
            if (Platform.getBundle((String)"ro.amiq.vlogdt") != null) {
                naturesTmp.add("SystemVerilog");
                this.fNatureName = "ro.amiq.vlogdt.VlogNature";
            }
            if (Platform.getBundle((String)"ro.amiq.edt") != null) {
                naturesTmp.add("e Language");
                this.fNatureName = "ro.amiq.edt.enature";
            }
            if (Platform.getBundle((String)"ro.amiq.slndt") != null) {
                naturesTmp.add("SLN");
                this.fNatureName = "ro.amiq.slndt.slnnature";
            }
            if (Platform.getBundle((String)"ro.amiq.msdldt") != null) {
                naturesTmp.add("M-SDL");
                this.fNatureName = "ro.amiq.msdldt.msdlnature";
            }
            if (Platform.getBundle((String)"ro.amiq.pssdt") != null) {
                naturesTmp.add("PSS");
                this.fNatureName = "ro.amiq.pssdt.pssnature";
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        Collections.sort(naturesTmp);
        return naturesTmp;
    }

    protected void refreshTemplates() {
        this.fStyledTextLabel.setText(this.removeLinksMarkup("Note: " + this.getNote()));
        this.fPartitioner = TemplatesViewUtils.getDocumentPartitioner(this.fNatureName);
        this.fSourceViewer.unconfigure();
        this.fSourceViewer.configure(TemplatesViewUtils.getSourceViewerConfiguration(this.fNatureName));
        Document document = new Document();
        this.fPartitioner.connect((IDocument)document);
        document.setDocumentPartitioner(this.fPartitioner);
        this.fSourceViewer.setDocument((IDocument)document);
        this.fSourceViewer.refresh();
        this.setTemplateStore(TemplatesViewUtils.getTemplateStore(null, this.fNatureName, true));
        this.setContextTypeRegistry(TemplatesViewUtils.getContextTypeRegistry(this.fNatureName));
        this.getTableViewer().getContentProvider().inputChanged(null, null, (Object)TemplatesViewUtils.getTemplateStore(null, this.fNatureName, true));
        this.getTableViewer().refresh();
        this.getTableViewer().getTable().update();
        this.getViewer().refresh();
        this.updateViewerInput();
    }

    protected String removeLinksMarkup(String text) {
        return text.replaceAll("<a>", "").replaceAll("</a>", "");
    }

    protected boolean isShowFormatterSetting() {
        return false;
    }

    public void dispose() {
        if (this.fPartitioner != null) {
            this.fPartitioner.disconnect();
        }
        if (this.getViewer() != null) {
            this.getViewer().unconfigure();
        }
        super.dispose();
    }

    protected SourceViewer createViewer(Composite parent) {
        this.fSourceViewer = new DVTPreviewSourceViewer(parent, 2816);
        this.fSourceViewer.configure(TemplatesViewUtils.getSourceViewerConfiguration(this.fNatureName));
        this.fSourceViewer.setPreferenceStore(DVTPlugin.getDefault().getCombinedPreferenceStore());
        Document document = new Document();
        this.fPartitioner = TemplatesViewUtils.getDocumentPartitioner(this.fNatureName);
        this.fPartitioner.connect((IDocument)document);
        if (document instanceof IDocumentExtension3) {
            ((IDocumentExtension3)document).setDocumentPartitioner(TemplatesViewUtils.getDocumentPartitioning(this.fNatureName), this.fPartitioner);
        } else {
            document.setDocumentPartitioner(this.fPartitioner);
        }
        this.fSourceViewer.setDocument((IDocument)document);
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        return this.fSourceViewer;
    }

    protected String getNote() {
        if (this.fNatureName.equals("ro.amiq.edt.enature")) {
            return "These are the global e Language code templates. To confiure project specific templates see the e Language code templates propety page of the project.";
        }
        if (this.fNatureName.equals("ro.amiq.slndt.slnnature")) {
            return "These are the global SLN code templates. To configure project specific templates see the SLN code templates property page of the project.";
        }
        if (this.fNatureName.equals("ro.amiq.msdldt.msdlnature")) {
            return "These are the global M-SDL code templates. To configure project specific templates see the M-SDL code templates property page of the project.";
        }
        if (this.fNatureName.equals("ro.amiq.pssdt.pssnature")) {
            return "These are the global PSS code templates. To configure project specific templates see the PSS code templates property page of the project.";
        }
        if (this.fNatureName.equals("ro.amiq.vhdldt.VhdlNature")) {
            return "These are the global VHDL code templates. To configure project specific templates see the VHDL code templates property page of the project.";
        }
        return "These are the global SystemVerilog code templates. To configure project specific templates see the SystemVerilog code templates propety page of the project.";
    }

    protected void openLink() {
    }

    public boolean performOk() {
        TemplatesViewUtils.updateTemplatesView(500L);
        return super.performOk();
    }

    protected void performApply() {
        TemplatesViewUtils.updateTemplatesView(500L);
        super.performApply();
    }

    protected void performDefaults() {
        TemplatesViewUtils.updateTemplatesView(500L);
        super.performDefaults();
    }
}

