/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.compare;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.ui.compare.ICompareInputPart;

public class CompareInput
extends CompareEditorInput {
    private static final String CONFIRM_SAVE_PROPERTY = "org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY";
    private ICompareInputPart left;
    private ICompareInputPart right;
    private String compareTitle;
    private Object differences;
    private boolean createNoDiffNode = true;

    public CompareInput(ICompareInputPart left, ICompareInputPart right) {
        super(new CompareConfiguration());
        this.left = left;
        this.right = right;
        this.getCompareConfiguration().setProperty(CONFIRM_SAVE_PROPERTY, (Object)Boolean.FALSE);
    }

    public CompareInput(ICompareInputPart left, ICompareInputPart right, String compareTitle) {
        this(left, right);
        this.compareTitle = compareTitle;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.right == null || this.left == null) {
            return null;
        }
        try {
            this.initTitle();
            this.left.init(this);
            this.right.init(this);
            Differencer differencer = new Differencer();
            String message = "Comparing " + this.left.getName() + " with " + this.right.getName();
            monitor.beginTask(message, 30);
            this.differences = differencer.findDifferences(false, monitor, null, null, (Object)this.left, (Object)this.right);
            if (this.differences == null && this.createNoDiffNode) {
                this.differences = new DiffNode((ITypedElement)this.left, (ITypedElement)this.right);
            }
            Object object = this.differences;
            return object;
        }
        catch (OperationCanceledException e) {
            this.left.dispose();
            this.right.dispose();
            throw new InterruptedException(e.getMessage());
        }
        finally {
            monitor.done();
        }
    }

    public void saveChanges(IProgressMonitor monitor) throws CoreException {
        super.saveChanges(monitor);
        if (this.differences instanceof DiffNode) {
            try {
                boolean result = this.commit(monitor, (ICompareInput)((DiffNode)this.differences));
                if (result) {
                    this.reuseEditor();
                }
            }
            finally {
                this.setDirty(false);
            }
        }
    }

    public void reuseEditor() {
        UIJob job = new UIJob("Updating differences"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor.isCanceled() || CompareInput.this.left.isDisposed() || CompareInput.this.right.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                CompareInput input = CompareInput.this;
                CompareInput.this.createNoDiffNode = true;
                try {
                    try {
                        Viewer viewer;
                        CompareViewerSwitchingPane pane;
                        ICompareInputPart old_left = CompareInput.this.left;
                        CompareInput.this.left = old_left.recreate();
                        old_left.dispose();
                        ICompareInputPart old_right = CompareInput.this.right;
                        CompareInput.this.right = old_right.recreate();
                        old_right.dispose();
                        input.run(monitor);
                        if (CompareInput.this.differences != null && (pane = CompareInput.this.getInputPane()) != null && (viewer = pane.getViewer()) instanceof TextMergeViewer) {
                            viewer.setInput(CompareInput.this.differences);
                        }
                    }
                    catch (Exception exception) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        CompareInput.this.createNoDiffNode = false;
                        return iStatus;
                    }
                }
                finally {
                    CompareInput.this.createNoDiffNode = false;
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return CompareInput.this == family;
            }
        };
        job.setPriority(30);
        job.setUser(false);
        job.setRule((ISchedulingRule)new ExclusiveJobRule((Object)this));
        Job[] jobs = Job.getJobManager().find((Object)this);
        if (jobs.length > 0) {
            int i = 0;
            while (i < jobs.length) {
                jobs[i].cancel();
                ++i;
            }
        }
        if ((jobs = Job.getJobManager().find((Object)this)).length > 0) {
            job.schedule(1000L);
        } else {
            job.schedule();
        }
    }

    private CompareViewerSwitchingPane getInputPane() {
        try {
            Field field = CompareEditorInput.class.getDeclaredField("fContentInputPane");
            field.setAccessible(true);
            Object object = field.get((Object)this);
            if (object instanceof CompareViewerSwitchingPane) {
                return (CompareViewerSwitchingPane)object;
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    private boolean commit(IProgressMonitor monitor, ICompareInput diffNode) {
        boolean okLeft = this.commitNode(monitor, diffNode.getLeft());
        boolean okRight = this.commitNode(monitor, diffNode.getRight());
        return okLeft || okRight;
    }

    private boolean commitNode(IProgressMonitor monitor, ITypedElement element) {
        ICompareInputPart content;
        if (element instanceof ICompareInputPart && (content = (ICompareInputPart)element).isDirty()) {
            try {
                return content.commitChanges(monitor);
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    private void initTitle() {
        String nameRight;
        CompareConfiguration cc = this.getCompareConfiguration();
        String nameLeft = this.left.getName();
        if (nameLeft.equals(nameRight = this.right.getName())) {
            nameLeft = this.left.getFullName();
            nameRight = this.right.getFullName();
        }
        cc.setLeftLabel(nameLeft);
        cc.setLeftImage(this.left.getImage());
        cc.setRightLabel(nameRight);
        cc.setRightImage(this.right.getImage());
        cc.setLeftEditable(true);
        cc.setRightEditable(true);
        this.setTitle(this.compareTitle != null ? this.compareTitle : "Compare (" + nameLeft + " - " + nameRight + ")");
    }

    protected void handleDispose() {
        this.internalDispose();
        super.handleDispose();
    }

    private void internalDispose() {
        this.left.dispose();
        this.right.dispose();
        this.differences = null;
    }

    public ICompareInputPart getLeftCompareInputPart() {
        return this.left;
    }

    public ICompareInputPart getRightCompareInputPart() {
        return this.right;
    }

    public int hashCode() {
        return Objects.hash(this.compareTitle, this.left, this.right);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CompareInput other = (CompareInput)((Object)obj);
        return Objects.equals(this.compareTitle, other.compareTitle) && Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
    }

    static class ExclusiveJobRule
    implements ISchedulingRule {
        private final Object id;

        public ExclusiveJobRule(Object id) {
            this.id = id;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof ExclusiveJobRule && ((ExclusiveJobRule)rule).id == this.id;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return this.contains(rule);
        }
    }
}

