/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.ResourceNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import ro.amiq.dvt.ui.compare.CompareInput;
import ro.amiq.dvt.ui.compare.EditableSharedDocumentAdapter;
import ro.amiq.dvt.ui.compare.ICompareInputPart;

public class FileCompareInputPart
extends ResourceNode
implements ICompareInputPart {
    private boolean dirty;
    private final IFile file;
    private EditableSharedDocumentAdapter sharedDocumentAdapter;

    public FileCompareInputPart(IFile file) {
        super((IResource)file);
        this.file = file;
    }

    public void setContent(byte[] contents) {
        this.dirty = true;
        super.setContent(contents);
    }

    @Override
    public String getFullName() {
        return this.file.getName();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean commitChanges(IProgressMonitor pm) throws CoreException {
        if (!this.dirty) {
            return true;
        }
        if (this.sharedDocumentAdapter != null) {
            boolean documentSaved = this.sharedDocumentAdapter.saveDocument(this.sharedDocumentAdapter.getDocumentKey(this), true, pm);
            if (documentSaved) {
                this.dirty = false;
            }
            return documentSaved;
        }
        byte[] bytes = this.getContent();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            if (this.file.exists()) {
                this.file.setContents((InputStream)is, true, true, pm);
            } else {
                this.file.create((InputStream)is, true, pm);
            }
            this.dirty = false;
        }
        catch (Throwable throwable) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {}
        return true;
    }

    @Override
    public void dispose() {
        this.discardBuffer();
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    @Override
    public void init(CompareInput input) {
        this.getContent();
    }

    @Override
    public ICompareInputPart recreate() {
        return new FileCompareInputPart(this.file);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISharedDocumentAdapter.class) {
            return this.getSharedDocumentAdapter();
        }
        if (adapter == IFile.class) {
            return this.file;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    private ISharedDocumentAdapter getSharedDocumentAdapter() {
        if (this.sharedDocumentAdapter == null) {
            this.sharedDocumentAdapter = new EditableSharedDocumentAdapter(this);
        }
        return this.sharedDocumentAdapter;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public IFile getFile() {
        return this.file;
    }
}

