/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.compare.CompareInput;
import ro.amiq.dvt.ui.compare.ICompareInputPart;

public class TextCompareInputPart
implements ICompareInputPart,
IStreamContentAccessor {
    private final String type;
    private final String content;
    private byte[] bytes;
    private final String name;

    public TextCompareInputPart(String type, String content) {
        this.type = type;
        this.content = content;
        this.name = "Initial version";
    }

    public TextCompareInputPart(String type, String content, String name) {
        this.type = type;
        this.content = content;
        this.name = name;
    }

    public Image getImage() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type != null ? this.type : "???";
    }

    public Object[] getChildren() {
        return new ICompareInputPart[0];
    }

    @Override
    public boolean commitChanges(IProgressMonitor pm) throws CoreException {
        return true;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    public InputStream getContents() throws CoreException {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public void dispose() {
        this.bytes = null;
    }

    @Override
    public boolean isDisposed() {
        return this.bytes == null;
    }

    @Override
    public void init(CompareInput input) {
        this.bytes = new byte[0];
        if (this.content == null) {
            return;
        }
        try {
            this.bytes = this.content.getBytes(ResourcesPlugin.getEncoding());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public ICompareInputPart recreate() {
        return new TextCompareInputPart(this.type, this.content);
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    @Override
    public void setDirty(boolean dirty) {
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes);
        result = 31 * result + Objects.hash(this.content, this.name, this.type);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextCompareInputPart other = (TextCompareInputPart)obj;
        return Objects.equals(this.content, other.content) && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
    }
}

