/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.custompragma;

import java.io.File;
import java.io.Serializable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class CustomPragma
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_RED = 210;
    private static final int DEFAULT_GREEN = 210;
    private static final int DEFAULT_BLUE = 210;
    private String fDescription;
    private String fStartPragma;
    private String fEndPragma;
    private boolean fEnabled;
    private boolean fColorEnabled;
    private RGB fRGB;
    private transient Color fColor;
    private File fFile;
    private String fLine;
    private boolean fGlobal;
    private boolean fDeleted;
    private boolean fReadOnly;
    private CustomPragma fOverride;

    public CustomPragma(CustomPragma pragma) {
        this.fEnabled = pragma.isEnabled();
        this.fDescription = pragma.getDescription();
        this.fStartPragma = pragma.getStartPragma();
        this.fEndPragma = pragma.getEndPragma();
        this.fColorEnabled = pragma.isColorEnabled();
        this.setColor(pragma.getColorString());
        this.fReadOnly = pragma.isReadOnly();
        this.fFile = pragma.getFile();
        this.fLine = pragma.getLine();
    }

    public CustomPragma(String description, String startPragma, String endPragma, boolean enabled, boolean colorEnabled, String color, boolean readOnly) {
        this.fEnabled = enabled;
        this.fDescription = description;
        this.fStartPragma = startPragma;
        this.fEndPragma = endPragma;
        this.fColorEnabled = colorEnabled;
        this.setColor(color);
        this.fReadOnly = readOnly;
    }

    public CustomPragma(String description, String startPragma, String endPragma, boolean enabled, boolean colorEnabled, RGB color, boolean readOnly) {
        this.fEnabled = enabled;
        this.fDescription = description;
        this.fStartPragma = startPragma;
        this.fEndPragma = endPragma;
        this.fColorEnabled = colorEnabled;
        this.setColor(color);
        this.fReadOnly = readOnly;
    }

    public void init() {
        this.fOverride = null;
    }

    public String getName() {
        return String.valueOf(this.fStartPragma) + " ... " + this.fEndPragma;
    }

    public void setDescription(String description) {
        this.fDescription = description;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void setLocation(File file, String line) {
        this.fFile = file;
        this.fLine = line;
    }

    public String getLocation() {
        if (this.fFile == null) {
            return "UNSAVED";
        }
        return String.valueOf(this.fFile.getAbsolutePath()) + " at line " + this.fLine;
    }

    public File getFile() {
        return this.fFile;
    }

    public String getLine() {
        return this.fLine;
    }

    public void setStartPragma(String fStartToken) {
        this.fStartPragma = fStartToken;
    }

    public String getStartPragma() {
        return this.fStartPragma;
    }

    public void setEndPragma(String fEndToken) {
        this.fEndPragma = fEndToken;
    }

    public String getEndPragma() {
        return this.fEndPragma;
    }

    public void setColorEnabled(boolean fColorEnabled) {
        this.fColorEnabled = fColorEnabled;
    }

    public boolean isColorEnabled() {
        return this.fColorEnabled;
    }

    public void setColor(RGB color) {
        this.fRGB = color;
        this.fColor = DVTColorUtil.INSTANCE.getColor(this.fRGB);
    }

    public void setColor(String color) {
        String[] RGBString;
        int red = 210;
        int green = 210;
        int blue = 210;
        if (color != null && (RGBString = color.split(";")).length == 3) {
            red = Integer.parseInt(RGBString[0]);
            green = Integer.parseInt(RGBString[1]);
            blue = Integer.parseInt(RGBString[2]);
        }
        this.setColor(new RGB(red, green, blue));
    }

    public Color getColor() {
        if (this.fColor == null && this.fRGB != null) {
            return DVTColorUtil.INSTANCE.getColor(this.fRGB);
        }
        return this.fColor;
    }

    public String getColorString() {
        if (this.fColor == null) {
            return "NONE";
        }
        return String.valueOf(this.fColor.getRed()) + ";" + this.fColor.getGreen() + ";" + this.fColor.getBlue();
    }

    public void setOverriden(CustomPragma override) {
        this.fOverride = override;
    }

    public boolean isOverriden() {
        return this.fOverride != null;
    }

    public void setGlobal() {
        this.fGlobal = true;
    }

    public boolean isGlobal() {
        return this.fGlobal;
    }

    public void setDeleted(boolean deleted) {
        this.fDeleted = deleted;
    }

    public boolean isDeleted() {
        return this.fDeleted;
    }

    public void setReadOnly(boolean fReadOnly) {
        this.fReadOnly = fReadOnly;
    }

    public boolean isReadOnly() {
        return this.fReadOnly;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Enabled:       ").append(this.fEnabled ? "yes" : "no").append("\n");
        result.append("Start pragma:  ").append(this.fStartPragma).append("\n");
        result.append("End pragma:    ").append(this.fEndPragma).append("\n");
        result.append("Read-only:     ").append(this.fReadOnly ? "yes" : "no").append("\n");
        result.append("Color:         ").append(this.fColorEnabled ? "RGB(" + this.getColorString() + ")" : "NONE").append("\n");
        result.append("Description:   ").append(this.fDescription).append("\n");
        result.append("---------------").append("\n");
        result.append("The custom pragma is defined in ").append(this.getLocation()).append(".\n");
        if (this.isOverriden()) {
            result.append("The custom pragma is overridden in ").append(this.fOverride.getLocation()).append(".\n");
        }
        if (this.fGlobal) {
            result.append("The custom pragma is defined in a $DVT_COMMON_SETTINGS or $DVT_USER_SETTINGS file and cannot be edited.");
        }
        return result.toString();
    }
}

