/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.custompragma;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.filters.StringInputStream;
import org.eclipse.core.runtime.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.PositionalXMLReader;

public class CustomPragmaReaderWriter {
    private static final String PRAGMAS_ROOT = "pragmas";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String PRAGMA_ELEMENT = "pragma";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String START_TOKEN_ATTRIBUTE = "startPragma";
    private static final String END_TOKEN_ATTRIBUTE = "endPragma";
    private static final String ENABLED_ATTRIBUTE = "enabled";
    private static final String COLOR_ENABLED_ATTRIBUTE = "colorEnabled";
    private static final String COLOR_ATTRIBUTE = "color";
    private static final String READ_ONLY_ATTRIBUTE = "readOnly";
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";
    private static final String VERSION_ONE = "1";
    private static final String LINE_NUMBER_ATTRIBUTE = "lineNumber";

    public CustomPragma[] read(File file) throws IOException {
        if (file == null) {
            return null;
        }
        BufferedInputStream input = null;
        CustomPragma[] result = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            result = this.read(input, null, file);
        }
        catch (Throwable throwable) {
            DVTUtilsCommon.INSTANCE.closeClosable(input);
            throw throwable;
        }
        DVTUtilsCommon.INSTANCE.closeClosable(input);
        return result;
    }

    public CustomPragma[] read(String string) throws IOException {
        if (string == null) {
            return null;
        }
        StringInputStream input = null;
        CustomPragma[] result = null;
        try {
            input = new StringInputStream(string);
            result = this.read((InputStream)input, null, null);
        }
        finally {
            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)input);
        }
        return result;
    }

    private CustomPragma[] read(InputStream is, ResourceBundle bundle, File file) throws IOException {
        try {
            ArrayList<CustomPragma> pragmas = new ArrayList<CustomPragma>();
            Document document = PositionalXMLReader.readXML(is);
            NodeList pragmasNodes = document.getElementsByTagName(PRAGMAS_ROOT);
            if (pragmasNodes.getLength() < 1) {
                return pragmas.toArray(new CustomPragma[pragmas.size()]);
            }
            NodeList elements = document.getElementsByTagName(PRAGMA_ELEMENT);
            Element pragmasNode = (Element)pragmasNodes.item(0);
            String version = pragmasNode.getAttribute(VERSION_ATTRIBUTE);
            if (version.equals(VERSION_ONE)) {
                this.read1(elements, pragmas, file);
            }
            return pragmas.toArray(new CustomPragma[pragmas.size()]);
        }
        catch (SAXException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t != null) {
                throw new IOException(t.getMessage());
            }
            throw new IOException(e.getMessage());
        }
    }

    private void read1(NodeList elements, Collection<CustomPragma> pragmas, File file) throws IOException {
        try {
            int count = elements.getLength();
            int i = 0;
            while (i != count) {
                Node node = elements.item(i);
                NamedNodeMap attributes = node.getAttributes();
                String line = (String)node.getUserData(LINE_NUMBER_ATTRIBUTE);
                if (attributes != null) {
                    String startPragma = this.getStringValue(attributes, START_TOKEN_ATTRIBUTE, null);
                    String endPragma = this.getStringValue(attributes, END_TOKEN_ATTRIBUTE, null);
                    if (startPragma == null || endPragma == null) {
                        DVTLogger.INSTANCE.logError("CustomPragmaReaderWriter.error.missing_attribute in file " + (file == null ? "DEFAULT" : String.valueOf(file.getAbsolutePath()) + " at line " + line));
                    } else {
                        startPragma = DVTStringUtil.collapseWhitespaces(startPragma);
                        endPragma = DVTStringUtil.collapseWhitespaces(endPragma);
                        String description = this.getStringValue(attributes, DESCRIPTION_ATTRIBUTE, "");
                        boolean enabled = this.getBooleanValue(attributes, ENABLED_ATTRIBUTE, true);
                        boolean colorEnabled = this.getBooleanValue(attributes, COLOR_ENABLED_ATTRIBUTE, false);
                        String color = this.getStringValue(attributes, COLOR_ATTRIBUTE, null);
                        boolean readOnly = this.getBooleanValue(attributes, READ_ONLY_ATTRIBUTE, false);
                        if (colorEnabled && color == null) {
                            color = "210;210;210";
                        }
                        CustomPragma pragma = new CustomPragma(description, startPragma, endPragma, enabled, colorEnabled, color, readOnly);
                        pragma.setLocation(file, (String)node.getUserData(LINE_NUMBER_ATTRIBUTE));
                        pragmas.add(pragma);
                    }
                }
                ++i;
            }
        }
        catch (SAXException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t != null) {
                throw new IOException(t.getMessage());
            }
            throw new IOException(e.getMessage());
        }
    }

    public void save(CustomPragma[] pragmas, File file) throws IOException {
        if (pragmas == null || file == null) {
            return;
        }
        BufferedOutputStream output = null;
        try {
            output = new BufferedOutputStream(new FileOutputStream(file));
            this.save(pragmas, new StreamResult(output), file);
        }
        catch (Throwable throwable) {
            DVTUtilsCommon.INSTANCE.closeClosable(output);
            throw throwable;
        }
        DVTUtilsCommon.INSTANCE.closeClosable(output);
    }

    private void save(CustomPragma[] pragmas, StreamResult result, File file) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement(PRAGMAS_ROOT);
            NamedNodeMap attributes = root.getAttributes();
            Attr version = document.createAttribute(VERSION_ATTRIBUTE);
            version.setValue(VERSION_ONE);
            attributes.setNamedItem(version);
            document.appendChild(root);
            int i = 0;
            while (i < pragmas.length) {
                CustomPragma pragma = pragmas[i];
                Element node = document.createElement(PRAGMA_ELEMENT);
                root.appendChild(node);
                attributes = node.getAttributes();
                if (pragma != null) {
                    Attr description = document.createAttribute(DESCRIPTION_ATTRIBUTE);
                    description.setValue(pragma.getDescription());
                    attributes.setNamedItem(description);
                    Attr startToken = document.createAttribute(START_TOKEN_ATTRIBUTE);
                    startToken.setValue(pragma.getStartPragma());
                    attributes.setNamedItem(startToken);
                    Attr endToken = document.createAttribute(END_TOKEN_ATTRIBUTE);
                    endToken.setValue(pragma.getEndPragma());
                    attributes.setNamedItem(endToken);
                    Attr enabled = document.createAttribute(ENABLED_ATTRIBUTE);
                    enabled.setValue(pragma.isEnabled() ? TRUE : FALSE);
                    attributes.setNamedItem(enabled);
                    Attr colorEnabled = document.createAttribute(COLOR_ENABLED_ATTRIBUTE);
                    colorEnabled.setValue(pragma.isColorEnabled() ? TRUE : FALSE);
                    attributes.setNamedItem(colorEnabled);
                    Attr color = document.createAttribute(COLOR_ATTRIBUTE);
                    color.setValue(pragma.getColorString());
                    attributes.setNamedItem(color);
                    Attr readOnly = document.createAttribute(READ_ONLY_ATTRIBUTE);
                    readOnly.setValue(pragma.isReadOnly() ? TRUE : FALSE);
                    attributes.setNamedItem(readOnly);
                    pragma.setLocation(file, "-1");
                }
                ++i;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("doctype-public", "-//DVT//custom_pragmas");
            transformer.setOutputProperty("doctype-system", "custom_pragmas.dtd");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Assert.isTrue((boolean)false);
        }
        catch (TransformerException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            Assert.isTrue((boolean)false);
        }
    }

    private boolean getBooleanValue(NamedNodeMap attributes, String attribute, boolean defaultValue) throws SAXException {
        if (attributes == null) {
            return false;
        }
        Node enabledNode = attributes.getNamedItem(attribute);
        if (enabledNode == null) {
            return defaultValue;
        }
        if (enabledNode.getNodeValue().equals(TRUE)) {
            return true;
        }
        if (enabledNode.getNodeValue().equals(FALSE)) {
            return false;
        }
        throw new SAXException("CustomPragmaReaderWriter.error.illegal_boolean_attribute");
    }

    private String getStringValue(NamedNodeMap attributes, String name, String defaultValue) {
        if (attributes == null) {
            return null;
        }
        Node node = attributes.getNamedItem(name);
        return node == null ? defaultValue : node.getNodeValue();
    }
}

