/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.custompragma;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.settings.DVTSFiles;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.ui.custompragma.CustomPragmaReaderWriter;

public class CustomPragmaStoreUtil {
    public static void save(List<CustomPragma> customPragmaList, IProject project) throws IOException {
        if (customPragmaList == null) {
            return;
        }
        ArrayList<CustomPragma> custom = new ArrayList<CustomPragma>();
        for (CustomPragma data : customPragmaList) {
            if (data.isDeleted()) continue;
            custom.add(data);
        }
        File file = CustomPragmaStoreUtil.getPropertyFile(project);
        if (file == null) {
            return;
        }
        CustomPragmaReaderWriter writer = new CustomPragmaReaderWriter();
        writer.save(custom.toArray(new CustomPragma[custom.size()]), file);
    }

    public static File getPropertyFile(IProject project) {
        if (project == null) {
            return null;
        }
        String path = CustomPragmaStoreUtil.getPathToPropertyFile(project, false);
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            String deprecatedPath = CustomPragmaStoreUtil.getPathToPropertyFile(project, true);
            if (deprecatedPath == null) {
                return null;
            }
            File deprecatedFile = new File(deprecatedPath);
            if (deprecatedFile.exists()) {
                return deprecatedFile;
            }
        }
        return file;
    }

    private static String getPathToPropertyFile(IProject project, boolean withPrefix) {
        if (project == null) {
            return null;
        }
        try {
            return String.valueOf(project.getLocation().toOSString()) + '/' + ".dvt" + '/' + (withPrefix ? ".dvt_" : "") + DVTSFiles.CUSTOM_PRAGMAS.getName();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static void add(List<CustomPragma> pragmaList, CustomPragma pragma) {
        if (pragma == null) {
            return;
        }
        if (pragma.getStartPragma().equals(pragma.getEndPragma())) {
            return;
        }
        pragma.init();
        int i = 0;
        while (i < pragmaList.size()) {
            CustomPragma existing = pragmaList.get(i);
            if (existing.getStartPragma().equals(pragma.getStartPragma())) {
                existing.setOverriden(pragma);
            } else if (existing.getStartPragma().equals(pragma.getEndPragma())) {
                existing.setOverriden(pragma);
            } else if (existing.getEndPragma().equals(pragma.getStartPragma())) {
                existing.setOverriden(pragma);
            } else if (existing.getEndPragma().equals(pragma.getEndPragma())) {
                existing.setOverriden(pragma);
            }
            ++i;
        }
        pragmaList.add(pragma);
    }

    public static void addAll(List<CustomPragma> customPragmaList, List<CustomPragma> toAddCustomPragmaList) {
        if (toAddCustomPragmaList == null) {
            return;
        }
        for (CustomPragma customPragma : toAddCustomPragmaList) {
            CustomPragmaStoreUtil.add(customPragmaList, customPragma);
        }
    }

    public static List<CustomPragma> load(IProject project) {
        ArrayList<CustomPragma> customPragmaList = new ArrayList<CustomPragma>();
        CustomPragmaStoreUtil.loadGlobal(customPragmaList);
        CustomPragmaStoreUtil.loadLocal(customPragmaList, project);
        return customPragmaList;
    }

    public static void loadGlobal(List<CustomPragma> customPragmas) {
        if (customPragmas == null) {
            return;
        }
        CustomPragmaReaderWriter reader = new CustomPragmaReaderWriter();
        CustomPragma[] datas = null;
        List files = DVTSFiles.CUSTOM_PRAGMAS.getAllFiles(true);
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.exists()) continue;
            try {
                datas = reader.read(file);
                if (datas == null) continue;
                int i = 0;
                while (i < datas.length) {
                    CustomPragma data = datas[i];
                    data.setGlobal();
                    CustomPragmaStoreUtil.add(customPragmas, data);
                    ++i;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public static void loadLocal(List<CustomPragma> customPragmas, IProject project) {
        if (customPragmas == null || project == null) {
            return;
        }
        CustomPragmaReaderWriter reader = new CustomPragmaReaderWriter();
        CustomPragma[] datas = null;
        File xmlFile = CustomPragmaStoreUtil.getPropertyFile(project);
        if (xmlFile == null || !xmlFile.exists()) {
            return;
        }
        try {
            datas = reader.read(xmlFile);
            if (datas == null) {
                return;
            }
            int i = 0;
            while (i < datas.length) {
                CustomPragma data = datas[i];
                CustomPragmaStoreUtil.add(customPragmas, data);
                ++i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void delete(CustomPragma data) {
        if (data == null) {
            return;
        }
        data.setDeleted(true);
    }
}

