/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.debug;

import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.debug.DebugConsoleUtils;
import ro.amiq.dvt.ui.debug.IDebugConsole;
import ro.amiq.dvt.ui.debug.LazyDesignHierarchyConsole;

public enum DebugConsoleFactory {
    LAZY_DESIGN_HIERARCHY_VIEW("Lazy Design Hierarchy Debug Console", LazyDesignHierarchyConsole.class);

    private String title;
    Class<? extends IDebugConsole> consoleClass;

    private DebugConsoleFactory(String title, Class<? extends IDebugConsole> consoleClass) {
        this.title = title;
        this.consoleClass = consoleClass;
    }

    public void open() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DebugConsoleUtils.getOrCreate(DebugConsoleFactory.this.title, DebugConsoleFactory.this.consoleClass);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    public String getTitle() {
        return this.title;
    }
}

