/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.debug;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.debug.IDebugConsole;

public class DebugConsoleUtils {
    public static MessageConsole getOrCreate(String name, Class<? extends IDebugConsole> clazz) {
        try {
            MessageConsole result = DebugConsoleUtils.findMessageConsole(name);
            if (result == null) {
                Constructor<? extends IDebugConsole> ctor = clazz.getDeclaredConstructor(String.class, ImageDescriptor.class);
                ctor.setAccessible(true);
                result = ctor.newInstance(name, null);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{result});
            }
            return result;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private static MessageConsole findMessageConsole(String title) {
        IConsole[] consoles;
        IConsole[] iConsoleArray = consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole iConsole = iConsoleArray[n2];
            if (iConsole.getName().equals(title)) {
                return (MessageConsole)iConsole;
            }
            ++n2;
        }
        return null;
    }
}

