/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.debug;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.internal.console.IOConsolePage;
import org.eclipse.ui.part.IPageBookViewPage;
import ro.amiq.dvt.externaltools.IDVTTerminatable;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.debug.DebugConsoleUtils;

public abstract class IDebugConsole
extends MessageConsole
implements IDVTTerminatable {
    static final String SEPARATOR_LINE = "\n==============================================================================================================\n";

    public IDebugConsole(String name, ImageDescriptor imageDescriptor) {
        super(name, imageDescriptor);
    }

    @Override
    public void terminate() {
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this});
    }

    public void print(final String message) {
        if (message == null) {
            return;
        }
        final Class<?> consoleClass = this.getClass();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    MessageConsole console = DebugConsoleUtils.getOrCreate(IDebugConsole.this.getTitle(), consoleClass);
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (MessageConsoleStream out = console.newMessageStream();){
                        out.setActivateOnWrite(true);
                        out.println(IDebugConsole.SEPARATOR_LINE.concat(message).concat(IDebugConsole.SEPARATOR_LINE));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        IOConsolePage consolePage = this.createConsolePage(view);
        consolePage.setReadOnly();
        return consolePage;
    }

    protected abstract IOConsolePage createConsolePage(IConsoleView var1);

    protected abstract String getTitle();
}

