/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.debug;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.IOConsolePage;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.debug.IDebugConsole;
import ro.amiq.dvt.ui.views.lazy.tree.utils.LazyTreeStatistics;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyView;

public class LazyDesignHierarchyConsolePage
extends IOConsolePage {
    IDebugConsole debugConsole;

    public LazyDesignHierarchyConsolePage(TextConsole console, IConsoleView view) {
        super(console, view);
        this.debugConsole = console instanceof IDebugConsole ? (IDebugConsole)console : null;
    }

    protected void createActions() {
        super.createActions();
    }

    protected void configureToolBar(IToolBarManager mgr) {
        if (this.debugConsole == null) {
            return;
        }
        IActionBars actionBars = this.getSite().getActionBars();
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IAction)new ShowAliveTreePathsLazyDHView());
        menuManager.add((IAction)new ShowMatchCacheSizeAction());
        menuManager.add((IAction)new ShowLazyTreeCacheSizeAction());
        actionBars.updateActionBars();
    }

    private class ShowAliveTreePathsLazyDHView
    extends Action {
        public ShowAliveTreePathsLazyDHView() {
            super("Show alive tree paths");
            this.setImageDescriptor(DVTImages.DESIGN_HIERARCHY_TOP);
            this.setToolTipText("Show alive tree paths");
        }

        public void runWithEvent(Event event) {
            if (LazyDesignHierarchyConsolePage.this.debugConsole == null) {
                return;
            }
            int alive = LazyTreeStatistics.INSTANCE.getAlivePathForView("ro.amiq.dvt.ui.views.LazyDesignHierarchyView");
            LazyDesignHierarchyConsolePage.this.debugConsole.print("Design Hierarchy View (Beta) alive paths: " + alive);
        }
    }

    private class ShowLazyTreeCacheSizeAction
    extends Action {
        public ShowLazyTreeCacheSizeAction() {
            super("Show lazy tree cache size");
            this.setImageDescriptor(DVTImages.ASSUME);
            this.setToolTipText("Show lazy tree cache size");
        }

        public void runWithEvent(Event event) {
            if (LazyDesignHierarchyConsolePage.this.debugConsole == null) {
                return;
            }
            try {
                LazyDesignHierarchyView designHierarchyView = (LazyDesignHierarchyView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ro.amiq.dvt.ui.views.LazyDesignHierarchyView");
                int lazyTreeCacheSize = designHierarchyView.getLazyTreeCacheSize();
                LazyDesignHierarchyConsolePage.this.debugConsole.print("Design Hierarchy View (Beta) lazy tree cache (tree path by children) size: " + lazyTreeCacheSize);
            }
            catch (PartInitException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private class ShowMatchCacheSizeAction
    extends Action {
        public ShowMatchCacheSizeAction() {
            super("Show match cache size");
            this.setImageDescriptor(DVTImages.ASSERT);
            this.setToolTipText("Show match cache size");
        }

        public void runWithEvent(Event event) {
            if (LazyDesignHierarchyConsolePage.this.debugConsole == null) {
                return;
            }
            try {
                LazyDesignHierarchyView designHierarchyView = (LazyDesignHierarchyView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ro.amiq.dvt.ui.views.LazyDesignHierarchyView");
                int matchCacheSize = designHierarchyView.getMatchCacheSize();
                LazyDesignHierarchyConsolePage.this.debugConsole.print("Design Hierarchy View (Beta) match cache size: " + matchCacheSize);
            }
            catch (PartInitException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
}

