/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.decorators;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IDecoration;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.decorators.DVTAbstractDecorator;
import ro.amiq.dvt.ui.editor.hyperlink.IJumpToTLMPathNode;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public class CompiledFileDecorator
extends DVTAbstractDecorator {
    public static final String ID = "ro.amiq.dvt.CompiledFileDecorator";

    public void decorate(Object element, IDecoration decoration) {
        try {
            if (element instanceof IDVTElementWrapper || element instanceof TreePath) {
                return;
            }
            IResource objectResource = this.getResource(element);
            if (element instanceof IJumpToTLMPathNode) {
                objectResource = ((IJumpToTLMPathNode)element).getResource();
            }
            if (objectResource == null || !objectResource.isAccessible() || objectResource.getProject() == null) {
                return;
            }
            if (!DVTNature.hasAnyDVTNatureEnabled(objectResource.getProject())) {
                return;
            }
            if (objectResource instanceof IFile && PropertiesManager.getSessionProperty(objectResource, PropertyTypes.QN_IMPORTED_FILE) != null) {
                if (BuildConfigManager.isSkip(objectResource)) {
                    decoration.addOverlay(DVTImages.DESC_OVR_IGNORED_IMPORTED_FILE, 0);
                } else {
                    decoration.addOverlay(DVTImages.DESC_OVR_IMPORTED_FILE, 0);
                }
            }
        }
        catch (Exception exception) {}
    }

    private IResource getResource(Object object) {
        if (object instanceof IDVTElementWrapper) {
            IDVTElementWrapper element = (IDVTElementWrapper)object;
            if (((IDVTElementWrapper)object).getRfElement() instanceof IDVTFileInstance) {
                IDVTFileInstance fileInstance = (IDVTFileInstance)((IDVTElementWrapper)object).getRfElement();
                String resourcePath = DVTFileUtils.getInstance().parser2resource(element.getProject(), fileInstance.getParserPath());
                return element.getProject().getFile(Path.fromOSString((String)resourcePath));
            }
            return this.getResource(element.getRfElement());
        }
        if (object instanceof IRfNamedElement) {
            return ((IRfNamedElement)object).getFileAdapter();
        }
        if (object instanceof IRfDefElement) {
            return ((IRfDefElement)object).getFileAdapter();
        }
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            return (IResource)((IAdaptable)object).getAdapter(IResource.class);
        }
        return null;
    }
}

