/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.decorators;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.navigator.CommonNavigator;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.decorators.DVTAbstractDecorator;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;

public class DifferentColorsDecorator
extends DVTAbstractDecorator
implements IPropertyChangeListener {
    public static final String ID = "ro.amiq.dvt.DifferentColorsDecorator";

    public DifferentColorsDecorator() {
        DVTPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void decorate(Object element, IDecoration decoration) {
        if (!EclipseUtils.isEclipse4x()) {
            return;
        }
        try {
            IResource objectResource = this.getResource(element);
            if (objectResource == null || !objectResource.isAccessible() || objectResource.getProject() == null) {
                return;
            }
            if (!DVTNature.hasAnyDVTNatureEnabled(objectResource.getProject())) {
                return;
            }
            String fgOrBg = DVTPlugin.getDefault().getPreferenceStore().getString("perProjectColorsFgBg");
            if (fgOrBg.equals("background")) {
                Color color = ProjectColorUtils.getBackgroundColor(objectResource.getProject().getName());
                if (color == null) {
                    return;
                }
                decoration.setBackgroundColor(color);
                decoration.setForegroundColor(Display.getDefault().getSystemColor(2));
            } else if (fgOrBg.equals("text")) {
                Color color = ProjectColorUtils.getForegroundColor(objectResource.getProject().getName());
                if (color == null) {
                    return;
                }
                decoration.setBackgroundColor(null);
                decoration.setForegroundColor(color);
            }
        }
        catch (Exception exception) {}
    }

    private IResource getResource(Object object) {
        if (object instanceof IProject) {
            return (IResource)object;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!event.getProperty().contains("perProjectColors")) {
            return;
        }
        IWorkbenchPage activePage = DVTUiUtils.getActivePage();
        if (activePage == null) {
            return;
        }
        CommonNavigator view = (CommonNavigator)activePage.findView("org.eclipse.ui.navigator.ProjectExplorer");
        if (view == null) {
            return;
        }
        view.getNavigatorContentService().update();
    }

    public void dispose() {
        super.dispose();
        DVTPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

