/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.decorators;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import ro.amiq.dvt.DVTPlugin;

public class FileAccessDecorator
extends LabelProvider
implements ILightweightLabelDecorator,
IPropertyChangeListener {
    private boolean showOnlyReadOnlyDecorators = DVTPlugin.getDefault().getPreferenceStore().getBoolean("showReadOnlyDecorators");

    public void decorate(Object element, IDecoration decoration) {
        if (!this.showOnlyReadOnlyDecorators) {
            return;
        }
        try {
            File file;
            IResource objectResource = this.getResource(element);
            if (objectResource == null) {
                return;
            }
            if (!objectResource.isAccessible()) {
                return;
            }
            if ((objectResource instanceof IProject || objectResource instanceof IFolder || objectResource instanceof IFile) && !(file = objectResource.getLocation().toFile()).canWrite()) {
                decoration.addSuffix(" " + DVTPlugin.getDefault().getPreferenceStore().getString("readOnlyDecorator"));
            }
        }
        catch (Exception exception) {}
    }

    private IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            return (IResource)((IAdaptable)object).getAdapter(IResource.class);
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("showReadOnlyDecorators".equals(event.getProperty())) {
            this.showOnlyReadOnlyDecorators = (Boolean)event.getNewValue();
        }
    }
}

