/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.decorators.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.decorators.util.ILazyOverlayElement;

public class LazyOverlayRefreshListener
implements Listener {
    private int MAX_NUMBER_OF_ELEMENTS = 30;
    private StructuredViewer fViewer;
    private ILazyOverlayElement[] fRefreshList = new ILazyOverlayElement[this.MAX_NUMBER_OF_ELEMENTS];
    private int fRefreshPointer = 0;
    private UIJob fRefreshJob = null;

    public LazyOverlayRefreshListener(TreeViewer viewer, String name) {
        this.fViewer = viewer;
        this.fRefreshJob = new RefreshJob(name);
    }

    public LazyOverlayRefreshListener(TableViewer viewer, String name) {
        this.fViewer = viewer;
        this.fRefreshJob = new RefreshJob(name);
    }

    public void handleEvent(Event event) {
        try {
            if (event.item == null) {
                return;
            }
            ILazyOverlayElement element = null;
            if (event.item instanceof TreeItem) {
                element = (ILazyOverlayElement)((TreeItem)event.item).getData();
            } else if (event.item instanceof TableItem) {
                element = (ILazyOverlayElement)((TableItem)event.item).getData();
            } else {
                return;
            }
            if (element == null) {
                return;
            }
            if (!element.getOverlayStatus()) {
                this.fRefreshList[this.fRefreshPointer] = element;
                this.fRefreshPointer = (this.fRefreshPointer + 1) % this.MAX_NUMBER_OF_ELEMENTS;
                this.fRefreshJob.cancel();
                this.fRefreshJob.schedule(150L);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private class RefreshJob
    extends UIJob {
        public RefreshJob(String name) {
            super(name);
            this.setSystem(true);
            this.setPriority(50);
        }

        public boolean shouldSchedule() {
            return super.shouldSchedule() && LazyOverlayRefreshListener.this.fViewer != null && !LazyOverlayRefreshListener.this.fViewer.getControl().isDisposed();
        }

        public boolean shouldRun() {
            return super.shouldRun() && LazyOverlayRefreshListener.this.fViewer != null && !LazyOverlayRefreshListener.this.fViewer.getControl().isDisposed();
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (LazyOverlayRefreshListener.this.fViewer == null || LazyOverlayRefreshListener.this.fViewer.getControl().isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            LazyOverlayRefreshListener.this.fViewer.getControl().setRedraw(false);
            int i = 0;
            while (i < LazyOverlayRefreshListener.this.MAX_NUMBER_OF_ELEMENTS) {
                ILazyOverlayElement element = LazyOverlayRefreshListener.this.fRefreshList[i];
                if (element != null && LazyOverlayRefreshListener.this.fViewer != null && !LazyOverlayRefreshListener.this.fViewer.getControl().isDisposed() && !element.getOverlayStatus()) {
                    element.setOverlayStatus(true);
                    LazyOverlayRefreshListener.this.fViewer.refresh((Object)element);
                    LazyOverlayRefreshListener.this.fRefreshList[i] = null;
                }
                ++i;
            }
            LazyOverlayRefreshListener.this.fViewer.getControl().setRedraw(true);
            return Status.OK_STATUS;
        }
    }
}

