/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.utils.LRUCache;

public class BaseLRUCache<K, V> {
    private LRUCache<K, V> cache;
    private Predicate<K> verifier;

    public BaseLRUCache(int capacity) {
        this.cache = new LRUCache(capacity);
    }

    public BaseLRUCache(int capacity, Predicate<K> verifier) {
        this(capacity);
        this.verifier = verifier;
    }

    public void put(K key, V value) {
        if (this.cache.containsKey(key)) {
            this.cache.remove(key);
        }
        this.checkElements();
        this.cache.put(key, value);
    }

    public void checkElements() {
        if (this.verifier == null) {
            return;
        }
        Iterator cacheIterator = this.cache.keySet().iterator();
        while (cacheIterator.hasNext()) {
            Object currKey = cacheIterator.next();
            if (this.verifier.test(currKey)) continue;
            cacheIterator.remove();
        }
    }

    public Map.Entry<K, V> getMostRecentlyUsedEntry() {
        Iterator cacheIterator = this.cache.entrySet().iterator();
        Map.Entry result = null;
        while (cacheIterator.hasNext()) {
            result = cacheIterator.next();
        }
        return result;
    }

    public Map.Entry<K, V> getLeastRecentlyUsedEntry() {
        Iterator cacheIterator = this.cache.entrySet().iterator();
        if (cacheIterator.hasNext()) {
            return cacheIterator.next();
        }
        return null;
    }

    public void setVerifier(Predicate<K> verifier) {
        this.verifier = verifier;
    }

    public void removeVerifier() {
        this.verifier = null;
    }

    public V get(K key) {
        return this.cache.get(key);
    }

    public void remove(K key) {
        this.cache.remove(key);
    }

    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.cache.containsValue(value);
    }

    public Set<K> keySet() {
        return this.cache.keySet();
    }

    public Collection<V> values() {
        return this.cache.values();
    }

    public int size() {
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public void clear() {
        this.cache.clear();
    }
}

