/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.BuildConfigToken;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class BuildConfigHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IDocument document;
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(document = textViewer.getDocument());
        if (textFileBuffer == null) {
            return null;
        }
        IPath location = textFileBuffer.getLocation();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(location);
        if (file.exists()) {
            location = file.getLocation();
        }
        IProject[] projects = null;
        projects = file.exists() && file.getProject() != null && file.getProject().isAccessible() ? new IProject[]{file.getProject()} : ResourcesPlugin.getWorkspace().getRoot().getProjects();
        return this.detectHyperlinks(projects, region, location);
    }

    public IHyperlink[] detectHyperlinks(IProject[] projects, IRegion region, IPath location) {
        String locationCanonicalPath;
        LinkedList<IHyperlink> result;
        block13: {
            File file;
            block12: {
                if (projects == null) {
                    return null;
                }
                result = new LinkedList<IHyperlink>();
                file = location.toFile();
                if (file != null) break block12;
                return null;
            }
            locationCanonicalPath = file.getCanonicalPath();
            if (locationCanonicalPath != null) break block13;
            return null;
        }
        try {
            HashSet<String> uniquePaths = new HashSet<String>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isAccessible()) {
                    List<BuildConfigProperty> hyperlinkedProperties = BuildConfigManager.getHyperlinkedProperties(project);
                    int i = 0;
                    while (i < hyperlinkedProperties.size()) {
                        IFile iFile;
                        String cannonicPath;
                        String fileCannonicalPath;
                        String fileName;
                        BuildConfigToken token;
                        BuildConfigProperty property = hyperlinkedProperties.get(i);
                        Object attr = property.getAttribute("ATTRIBUTE_TOKEN");
                        if (attr instanceof BuildConfigToken && (token = (BuildConfigToken)attr).getParentToken() == null && token.getOffset() <= region.getOffset() && token.getOffset() + token.getLength() >= region.getOffset() && (fileName = token.getFilename()) != null && locationCanonicalPath.equals(fileCannonicalPath = new File(fileName).getCanonicalPath()) && (cannonicPath = (iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, property.getValue())) != null && iFile.getLocation() != null ? iFile.getLocation().toFile().getCanonicalPath() : new File(property.getValue()).getCanonicalPath()) != null && !uniquePaths.contains(cannonicPath)) {
                            uniquePaths.add(cannonicPath);
                            IHyperlink hyperlink = this.getHyperlink(property, region, location, project);
                            if (hyperlink != null) {
                                result.add(hyperlink);
                            }
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() == 1) {
            return new IHyperlink[]{(IHyperlink)result.get(0)};
        }
        return new IHyperlink[]{this.getDummyHyperlinkForMultipleTargets(result)};
    }

    private IHyperlink getHyperlink(final BuildConfigProperty property, IRegion region, IPath location, final IProject project) {
        Object attr = property.getAttribute("ATTRIBUTE_TOKEN");
        if (!(attr instanceof BuildConfigToken)) {
            return null;
        }
        final BuildConfigToken token = (BuildConfigToken)attr;
        if (token.getParentToken() != null) {
            return null;
        }
        final boolean isCommandFile = property.getKind() == 12 || property.getKind() == 17;
        return new IHyperlink(){

            public void open() {
                IFile iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, property.getValue());
                if (isCommandFile) {
                    if (iFile != null) {
                        DVTFileUtils.getInstance().openEditor(iFile, 0, null);
                    } else {
                        DVTFileUtils.getInstance().openEditor(new File(property.getValue()), 0, "ro.amiq.dvt.ui.editor.BuildConfigEditor");
                    }
                } else if (iFile != null) {
                    DVTFileUtils.getInstance().openEditor(iFile, 0, null);
                } else {
                    DVTFileUtils.getInstance().openEditor(new File(property.getValue()), 0);
                }
            }

            public String getFilePath() {
                return property.getValue();
            }

            public String getTypeLabel() {
                return null;
            }

            public String getHyperlinkText() {
                return property.getValue();
            }

            public IRegion getHyperlinkRegion() {
                return new Region(token.getOffset(), token.getLength());
            }
        };
    }

    protected IHyperlink getDummyHyperlinkForMultipleTargets(final List<IHyperlink> hyperlinks) {
        return new IHyperlink(){

            public void open() {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), new LabelProvider()){

                    protected FilteredList createFilteredList(Composite parent) {
                        FilteredList list = super.createFilteredList(parent);
                        list.setFilterMatcher(new FilteredList.FilterMatcher(){
                            private StringMatcher fMatcher;

                            public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
                                this.fMatcher = new StringMatcher(String.valueOf('*') + pattern + '*', ignoreCase, ignoreWildCards);
                            }

                            public boolean match(Object element) {
                                return this.fMatcher.match(fFilteredList.getLabelProvider().getText(element));
                            }
                        });
                        return list;
                    }
                };
                dialog.setMessage("Select the files you want to open:");
                dialog.setElements((Object[])hyperlinks.toArray(new IHyperlink[hyperlinks.size()]));
                dialog.setMultipleSelection(true);
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    if (result == null) {
                        return;
                    }
                    Object[] objectArray = result;
                    int n = result.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (object != null) {
                            IHyperlink selection = (IHyperlink)object;
                            selection.open();
                        }
                        ++n2;
                    }
                }
            }

            public String getTypeLabel() {
                return null;
            }

            public String getHyperlinkText() {
                return null;
            }

            public IRegion getHyperlinkRegion() {
                return ((IHyperlink)hyperlinks.get(0)).getHyperlinkRegion();
            }
        };
    }

    public static class LabelProvider
    implements ILabelProvider {
        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IHyperlink) {
                IHyperlink link = (IHyperlink)element;
                String text = link.getHyperlinkText();
                if (text != null) {
                    return text;
                }
                return link.toString();
            }
            return null;
        }
    }
}

