/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;

public class DVTAnnotationPainter
extends AnnotationPainter {
    private static boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface.text/debug/AnnotationPainter"));
    private static final AnnotationPainter.IDrawingStrategy SQUIGGLES_STRATEGY = new AnnotationPainter.SquigglesStrategy();
    private static final AnnotationPainter.IDrawingStrategy NULL_STRATEGY = new AnnotationPainter.NullStrategy();
    private static final Object SQUIGGLES = new Object();
    private static final AnnotationPainter.ITextStyleStrategy HIGHLIGHTING_STRATEGY = new AnnotationPainter.HighlightingStrategy();
    private static final Object HIGHLIGHTING = new Object();
    private boolean fIsActive = false;
    private boolean fIsPainting = false;
    private volatile boolean fIsSettingModel = false;
    private ISourceViewer fSourceViewer;
    private StyledText fTextWidget;
    private IAnnotationModel fModel;
    private IAnnotationAccess fAnnotationAccess;
    private Map<Annotation, Decoration> fDecorationsMap = new HashMap<Annotation, Decoration>();
    private Map<Annotation, Decoration> fHighlightedDecorationsMap = new HashMap<Annotation, Decoration>();
    private Object fDecorationMapLock = new Object();
    private Object fHighlightedDecorationsMapLock = new Object();
    private Map<Object, Color> fAnnotationType2Color = new HashMap<Object, Color>();
    private Map<Object, Color> fCachedAnnotationType2Color = new HashMap<Object, Color>();
    private DVTPosition fCurrentHighlightAnnotationRange = null;
    private DVTPosition fTotalHighlightAnnotationRange = null;
    private DVTPosition fCurrentDrawRange = null;
    private DVTPosition fTotalDrawRange = null;
    private ITextInputListener fTextInputListener;
    private boolean fInputDocumentAboutToBeChanged;
    private Map<Object, Object> fAnnotationType2PaintingStrategyId = new HashMap<Object, Object>();
    private Map<String, Object> fCachedAnnotationType2PaintingStrategy = new HashMap<String, Object>();
    private Map<Object, Object> fPaintingStrategyId2PaintingStrategy = new HashMap<Object, Object>();
    private ReusableRegion fReusableRegion = new ReusableRegion();

    public DVTAnnotationPainter(ISourceViewer sourceViewer, IAnnotationAccess access) {
        super(sourceViewer, access);
        this.fSourceViewer = sourceViewer;
        this.fAnnotationAccess = access;
        this.fTextWidget = sourceViewer.getTextWidget();
        this.fPaintingStrategyId2PaintingStrategy.put(SQUIGGLES, SQUIGGLES_STRATEGY);
        this.fPaintingStrategyId2PaintingStrategy.put(HIGHLIGHTING, HIGHLIGHTING_STRATEGY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDecorations() {
        Object object = this.fDecorationMapLock;
        synchronized (object) {
            return !this.fDecorationsMap.isEmpty();
        }
    }

    private void enablePainting() {
        if (!this.fIsPainting && this.hasDecorations()) {
            this.fIsPainting = true;
            this.fTextWidget.addPaintListener((PaintListener)this);
            this.handleDrawRequest(null);
        }
    }

    private void disablePainting(boolean redraw) {
        if (this.fIsPainting) {
            this.fIsPainting = false;
            this.fTextWidget.removePaintListener((PaintListener)this);
            if (redraw && this.hasDecorations()) {
                this.handleDrawRequest(null);
            }
        }
    }

    private void setModel(IAnnotationModel model) {
        if (this.fModel != model) {
            if (this.fModel != null) {
                this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this);
            }
            this.fModel = model;
            if (this.fModel != null) {
                try {
                    this.fIsSettingModel = true;
                    this.fModel.addAnnotationModelListener((IAnnotationModelListener)this);
                }
                finally {
                    this.fIsSettingModel = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void catchupWithModel(AnnotationModelEvent event) {
        Iterator<Annotation> e;
        HashMap<Annotation, Decoration> highlightedDecorationsMap;
        HashMap<Annotation, Decoration> decorationsMap;
        Object object = this.fDecorationMapLock;
        synchronized (object) {
            if (this.fDecorationsMap == null) {
                return;
            }
        }
        if (this.fModel == null) {
            object = this.fDecorationMapLock;
            synchronized (object) {
                this.fDecorationsMap.clear();
            }
            object = this.fHighlightedDecorationsMapLock;
            synchronized (object) {
                this.fHighlightedDecorationsMap.clear();
            }
            return;
        }
        IRegion clippingRegion = this.computeClippingRegion(null, true);
        IDocument document = this.fSourceViewer.getDocument();
        int highlightAnnotationRangeStart = Integer.MAX_VALUE;
        int highlightAnnotationRangeEnd = -1;
        int drawRangeStart = Integer.MAX_VALUE;
        int drawRangeEnd = -1;
        Object object2 = this.fDecorationMapLock;
        synchronized (object2) {
            decorationsMap = new HashMap<Annotation, Decoration>(this.fDecorationsMap);
        }
        object2 = this.fHighlightedDecorationsMapLock;
        synchronized (object2) {
            highlightedDecorationsMap = new HashMap<Annotation, Decoration>(this.fHighlightedDecorationsMap);
        }
        boolean isWorldChange = false;
        if (event == null || event.isWorldChange()) {
            isWorldChange = true;
            if (DEBUG && event == null) {
                DVTLogger.INSTANCE.logInfo("AP: INTERNAL CHANGE");
            }
            for (Map.Entry entry : decorationsMap.entrySet()) {
                Annotation annotation = (Annotation)entry.getKey();
                Decoration decoration = (Decoration)entry.getValue();
                this.drawDecoration(decoration, null, annotation, clippingRegion, document);
            }
            decorationsMap.clear();
            highlightedDecorationsMap.clear();
            e = this.fModel.getAnnotationIterator();
        } else {
            Annotation[] changedAnnotations;
            Annotation[] removedAnnotations;
            Annotation[] annotationArray = removedAnnotations = event.getRemovedAnnotations();
            int n = removedAnnotations.length;
            int annotation = 0;
            while (annotation < n) {
                Position position;
                Annotation annotation2 = annotationArray[annotation];
                Decoration decoration = (Decoration)highlightedDecorationsMap.remove(annotation2);
                if (decoration != null && (position = decoration.fPosition) != null) {
                    highlightAnnotationRangeStart = Math.min(highlightAnnotationRangeStart, position.offset);
                    highlightAnnotationRangeEnd = Math.max(highlightAnnotationRangeEnd, position.offset + position.length);
                }
                if ((decoration = (Decoration)decorationsMap.remove(annotation2)) != null) {
                    this.drawDecoration(decoration, null, annotation2, clippingRegion, document);
                    position = decoration.fPosition;
                    if (position != null) {
                        drawRangeStart = Math.min(drawRangeStart, position.offset);
                        drawRangeEnd = Math.max(drawRangeEnd, position.offset + position.length);
                    }
                }
                ++annotation;
            }
            Annotation[] annotationArray2 = changedAnnotations = event.getChangedAnnotations();
            int n2 = changedAnnotations.length;
            n = 0;
            while (n < n2) {
                Decoration oldDecoration;
                Annotation annotation3 = annotationArray2[n];
                boolean isHighlighting = false;
                Decoration decoration = (Decoration)highlightedDecorationsMap.get(annotation3);
                if (decoration != null) {
                    Decoration removedDecoration;
                    isHighlighting = true;
                    if ((decoration = this.getDecoration(annotation3, decoration)) == null && (removedDecoration = (Decoration)highlightedDecorationsMap.remove(annotation3)) != null) {
                        highlightAnnotationRangeStart = Math.min(highlightAnnotationRangeStart, removedDecoration.fPosition.offset);
                        highlightAnnotationRangeEnd = Math.max(highlightAnnotationRangeEnd, removedDecoration.fPosition.offset + removedDecoration.fPosition.length);
                    }
                } else if ((decoration = this.getDecoration(annotation3, decoration)) != null && decoration.fPaintingStrategy instanceof AnnotationPainter.ITextStyleStrategy) {
                    highlightedDecorationsMap.put(annotation3, decoration);
                    isHighlighting = true;
                }
                boolean usesDrawingStrategy = !isHighlighting && decoration != null;
                Position position = null;
                position = decoration == null ? this.fModel.getPosition(annotation3) : decoration.fPosition;
                if (position != null && !position.isDeleted()) {
                    if (isHighlighting) {
                        highlightAnnotationRangeStart = Math.min(highlightAnnotationRangeStart, position.offset);
                        highlightAnnotationRangeEnd = Math.max(highlightAnnotationRangeEnd, position.offset + position.length);
                    }
                    if (usesDrawingStrategy) {
                        drawRangeStart = Math.min(drawRangeStart, position.offset);
                        drawRangeEnd = Math.max(drawRangeEnd, position.offset + position.length);
                    }
                } else {
                    Decoration removedDecoration = (Decoration)highlightedDecorationsMap.remove(annotation3);
                    if (removedDecoration != null) {
                        highlightAnnotationRangeStart = Math.min(highlightAnnotationRangeStart, removedDecoration.fPosition.offset);
                        highlightAnnotationRangeEnd = Math.max(highlightAnnotationRangeEnd, removedDecoration.fPosition.offset + removedDecoration.fPosition.length);
                    }
                }
                if (usesDrawingStrategy && (oldDecoration = (Decoration)decorationsMap.get(annotation3)) != null) {
                    this.drawDecoration(oldDecoration, null, annotation3, clippingRegion, document);
                    if (decoration != null) {
                        decorationsMap.put(annotation3, decoration);
                    } else {
                        decorationsMap.remove(annotation3);
                    }
                }
                ++n;
            }
            e = Arrays.asList(event.getAddedAnnotations()).iterator();
        }
        while (e.hasNext()) {
            Annotation annotation = (Annotation)e.next();
            Decoration pp = this.getDecoration(annotation, null);
            if (pp == null) continue;
            if (pp.fPaintingStrategy instanceof AnnotationPainter.IDrawingStrategy) {
                decorationsMap.put(annotation, pp);
                drawRangeStart = Math.min(drawRangeStart, pp.fPosition.offset);
                drawRangeEnd = Math.max(drawRangeEnd, pp.fPosition.offset + pp.fPosition.length);
                continue;
            }
            if (!(pp.fPaintingStrategy instanceof AnnotationPainter.ITextStyleStrategy)) continue;
            highlightedDecorationsMap.put(annotation, pp);
            highlightAnnotationRangeStart = Math.min(highlightAnnotationRangeStart, pp.fPosition.offset);
            highlightAnnotationRangeEnd = Math.max(highlightAnnotationRangeEnd, pp.fPosition.offset + pp.fPosition.length);
        }
        Object object3 = this.fDecorationMapLock;
        synchronized (object3) {
            this.fDecorationsMap = decorationsMap;
            this.updateDrawRanges(drawRangeStart, drawRangeEnd, isWorldChange);
        }
        object3 = this.fHighlightedDecorationsMapLock;
        synchronized (object3) {
            this.fHighlightedDecorationsMap = highlightedDecorationsMap;
            this.updateHighlightRanges(highlightAnnotationRangeStart, highlightAnnotationRangeEnd, isWorldChange);
        }
    }

    private void updateHighlightRanges(int highlightAnnotationRangeStart, int highlightAnnotationRangeEnd, boolean isWorldChange) {
        if (highlightAnnotationRangeStart != Integer.MAX_VALUE) {
            int maxRangeStart = highlightAnnotationRangeStart;
            int maxRangeEnd = highlightAnnotationRangeEnd;
            if (this.fTotalHighlightAnnotationRange != null) {
                maxRangeStart = Math.min(maxRangeStart, this.fTotalHighlightAnnotationRange.offset);
                maxRangeEnd = Math.max(maxRangeEnd, this.fTotalHighlightAnnotationRange.offset + this.fTotalHighlightAnnotationRange.length);
            }
            if (this.fTotalHighlightAnnotationRange == null) {
                this.fTotalHighlightAnnotationRange = new DVTPosition(0);
            }
            if (this.fCurrentHighlightAnnotationRange == null) {
                this.fCurrentHighlightAnnotationRange = new DVTPosition(0);
            }
            if (isWorldChange) {
                this.fTotalHighlightAnnotationRange.offset = highlightAnnotationRangeStart;
                this.fTotalHighlightAnnotationRange.length = highlightAnnotationRangeEnd - highlightAnnotationRangeStart;
                this.fCurrentHighlightAnnotationRange.offset = maxRangeStart;
                this.fCurrentHighlightAnnotationRange.length = maxRangeEnd - maxRangeStart;
            } else {
                this.fTotalHighlightAnnotationRange.offset = maxRangeStart;
                this.fTotalHighlightAnnotationRange.length = maxRangeEnd - maxRangeStart;
                this.fCurrentHighlightAnnotationRange.offset = highlightAnnotationRangeStart;
                this.fCurrentHighlightAnnotationRange.length = highlightAnnotationRangeEnd - highlightAnnotationRangeStart;
            }
        } else if (isWorldChange) {
            this.fCurrentHighlightAnnotationRange = this.fTotalHighlightAnnotationRange;
            this.fTotalHighlightAnnotationRange = null;
        } else {
            this.fCurrentHighlightAnnotationRange = null;
        }
        this.adaptToDocumentLength(this.fCurrentHighlightAnnotationRange);
        this.adaptToDocumentLength(this.fTotalHighlightAnnotationRange);
    }

    private void updateDrawRanges(int drawRangeStart, int drawRangeEnd, boolean isWorldChange) {
        if (drawRangeStart != Integer.MAX_VALUE) {
            int maxRangeStart = drawRangeStart;
            int maxRangeEnd = drawRangeEnd;
            if (this.fTotalDrawRange != null) {
                maxRangeStart = Math.min(maxRangeStart, this.fTotalDrawRange.offset);
                maxRangeEnd = Math.max(maxRangeEnd, this.fTotalDrawRange.offset + this.fTotalDrawRange.length);
            }
            if (this.fTotalDrawRange == null) {
                this.fTotalDrawRange = new DVTPosition(0);
            }
            if (this.fCurrentDrawRange == null) {
                this.fCurrentDrawRange = new DVTPosition(0);
            }
            if (isWorldChange) {
                this.fTotalDrawRange.offset = drawRangeStart;
                this.fTotalDrawRange.length = drawRangeEnd - drawRangeStart;
                this.fCurrentDrawRange.offset = maxRangeStart;
                this.fCurrentDrawRange.length = maxRangeEnd - maxRangeStart;
            } else {
                this.fTotalDrawRange.offset = maxRangeStart;
                this.fTotalDrawRange.length = maxRangeEnd - maxRangeStart;
                this.fCurrentDrawRange.offset = drawRangeStart;
                this.fCurrentDrawRange.length = drawRangeEnd - drawRangeStart;
            }
        } else if (isWorldChange) {
            this.fCurrentDrawRange = this.fTotalDrawRange;
            this.fTotalDrawRange = null;
        } else {
            this.fCurrentDrawRange = null;
        }
        this.adaptToDocumentLength(this.fCurrentDrawRange);
        this.adaptToDocumentLength(this.fTotalDrawRange);
    }

    private void adaptToDocumentLength(DVTPosition position) {
        if (position == null) {
            return;
        }
        int length = this.fSourceViewer.getDocument().getLength();
        position.offset = Math.min(position.offset, length);
        position.length = Math.min(position.length, length - position.offset);
    }

    private Decoration getDecoration(Annotation annotation, Decoration decoration) {
        if (annotation.isMarkedDeleted()) {
            return null;
        }
        String type = annotation.getType();
        Object paintingStrategy = this.getPaintingStrategy(type);
        if (paintingStrategy == null || paintingStrategy instanceof AnnotationPainter.NullStrategy) {
            return null;
        }
        Color color = this.getColor(type);
        if (color == null) {
            return null;
        }
        Position position = this.fModel.getPosition(annotation);
        if (position == null || position.isDeleted()) {
            return null;
        }
        if (decoration == null) {
            decoration = new Decoration();
        }
        decoration.fPosition = position;
        decoration.fColor = color;
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            IAnnotationAccessExtension extension = (IAnnotationAccessExtension)this.fAnnotationAccess;
            decoration.fLayer = extension.getLayer(annotation);
        } else {
            decoration.fLayer = 0;
        }
        decoration.fPaintingStrategy = paintingStrategy;
        return decoration;
    }

    private Object getPaintingStrategy(String type) {
        Object strategy = this.fCachedAnnotationType2PaintingStrategy.get(type);
        if (strategy != null) {
            return strategy;
        }
        strategy = this.fPaintingStrategyId2PaintingStrategy.get(this.fAnnotationType2PaintingStrategyId.get(type));
        if (strategy != null) {
            this.fCachedAnnotationType2PaintingStrategy.put(type, strategy);
            return strategy;
        }
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            Object[] sts;
            IAnnotationAccessExtension ext = (IAnnotationAccessExtension)this.fAnnotationAccess;
            Object[] objectArray = sts = ext.getSupertypes((Object)type);
            int n = sts.length;
            int n2 = 0;
            while (n2 < n) {
                Object st = objectArray[n2];
                strategy = this.fPaintingStrategyId2PaintingStrategy.get(this.fAnnotationType2PaintingStrategyId.get(st));
                if (strategy != null) {
                    this.fCachedAnnotationType2PaintingStrategy.put(type, strategy);
                    return strategy;
                }
                ++n2;
            }
        }
        this.fCachedAnnotationType2PaintingStrategy.put(type, NULL_STRATEGY);
        return null;
    }

    private Color getColor(Object annotationType) {
        IAnnotationAccessExtension extension;
        Object[] superTypes;
        Color color = this.fCachedAnnotationType2Color.get(annotationType);
        if (color != null) {
            return color;
        }
        color = this.fAnnotationType2Color.get(annotationType);
        if (color != null) {
            this.fCachedAnnotationType2Color.put(annotationType, color);
            return color;
        }
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension && (superTypes = (extension = (IAnnotationAccessExtension)this.fAnnotationAccess).getSupertypes(annotationType)) != null) {
            Object[] objectArray = superTypes;
            int n = superTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Object superType = objectArray[n2];
                color = this.fAnnotationType2Color.get(superType);
                if (color != null) {
                    this.fCachedAnnotationType2Color.put(annotationType, color);
                    return color;
                }
                ++n2;
            }
        }
        return null;
    }

    private void updatePainting(AnnotationModelEvent event) {
        this.disablePainting(event == null);
        this.catchupWithModel(event);
        if (!this.fInputDocumentAboutToBeChanged) {
            Region limits = Utils.getEditorVisibleLimits((ITextViewer)this.fSourceViewer);
            if (limits == null) {
                return;
            }
            DVTHlUtils.invalidateVisibleTextPresentation((ITextViewer)this.fSourceViewer, limits.getOffset(), limits.getLength());
        }
        this.enablePainting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyTextPresentation(TextPresentation tp) {
        HashSet<Map.Entry<Annotation, Decoration>> decorations;
        Object object = this.fHighlightedDecorationsMapLock;
        synchronized (object) {
            if (this.fHighlightedDecorationsMap == null || this.fHighlightedDecorationsMap.isEmpty()) {
                return;
            }
            decorations = new HashSet<Map.Entry<Annotation, Decoration>>(this.fHighlightedDecorationsMap.entrySet());
        }
        IRegion region = tp.getExtent();
        if (DEBUG) {
            DVTLogger.INSTANCE.logInfo("AP: applying text presentation offset: " + region.getOffset() + ", length= " + region.getLength());
        }
        int layer = 0;
        int maxLayer = 1;
        while (layer < maxLayer) {
            for (Map.Entry entry : decorations) {
                ITextViewerExtension5 extension3;
                Annotation a = (Annotation)entry.getKey();
                if (a.isMarkedDeleted()) continue;
                Decoration pp = (Decoration)entry.getValue();
                maxLayer = Math.max(maxLayer, pp.fLayer + 1);
                if (pp.fLayer != layer) continue;
                Position p = pp.fPosition;
                if (this.fSourceViewer instanceof ITextViewerExtension5 ? (extension3 = (ITextViewerExtension5)this.fSourceViewer).modelRange2WidgetRange((IRegion)new Region(p.getOffset(), p.getLength())) == null : !this.fSourceViewer.overlapsWithVisibleRegion(p.offset, p.length)) continue;
                int regionEnd = region.getOffset() + region.getLength();
                int pEnd = p.getOffset() + p.getLength();
                if (pEnd < region.getOffset() || regionEnd <= p.getOffset()) continue;
                int start = Math.max(p.getOffset(), region.getOffset());
                int end = Math.min(regionEnd, pEnd);
                int length = Math.max(end - start, 0);
                StyleRange styleRange = new StyleRange(start, length, null, null);
                ((AnnotationPainter.ITextStyleStrategy)pp.fPaintingStrategy).applyTextStyle(styleRange, pp.fColor);
                tp.mergeStyleRange(styleRange);
            }
            ++layer;
        }
    }

    public synchronized void modelChanged(IAnnotationModel model) {
        if (DEBUG) {
            DVTLogger.INSTANCE.logError("AP: OLD API of AnnotationModelListener called");
        }
        this.modelChanged(new AnnotationModelEvent(model));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void modelChanged(final AnnotationModelEvent event) {
        Display textWidgetDisplay;
        try {
            StyledText textWidget = this.fTextWidget;
            if (textWidget == null || textWidget.isDisposed()) {
                return;
            }
            textWidgetDisplay = textWidget.getDisplay();
        }
        catch (SWTException ex) {
            if (ex.code != 24) throw ex;
            return;
        }
        if (this.fIsSettingModel) {
            if (textWidgetDisplay != Display.getCurrent()) return;
            this.updatePainting(event);
            return;
        } else {
            if (DEBUG && event != null && event.isWorldChange()) {
                DVTLogger.INSTANCE.logInfo("AP: WORLD CHANGED, stack trace follows:");
                DVTLogger.INSTANCE.logError(new Throwable());
            }
            textWidgetDisplay.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (DVTAnnotationPainter.this.fTextWidget != null && !DVTAnnotationPainter.this.fTextWidget.isDisposed()) {
                        DVTAnnotationPainter.this.updatePainting(event);
                    }
                }
            });
        }
    }

    public void setAnnotationTypeColor(Object annotationType, Color color) {
        if (color != null) {
            this.fAnnotationType2Color.put(annotationType, color);
        } else {
            this.fAnnotationType2Color.remove(annotationType);
        }
        this.fCachedAnnotationType2Color.clear();
    }

    @Deprecated
    public void addAnnotationType(Object annotationType) {
        this.addAnnotationType(annotationType, SQUIGGLES);
    }

    public void addAnnotationType(Object annotationType, Object strategyID) {
        this.fAnnotationType2PaintingStrategyId.put(annotationType, strategyID);
        this.fCachedAnnotationType2PaintingStrategy.clear();
        if (this.fTextInputListener == null) {
            this.fTextInputListener = new ITextInputListener(){

                public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
                    DVTAnnotationPainter.this.fInputDocumentAboutToBeChanged = true;
                }

                public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                    DVTAnnotationPainter.this.fInputDocumentAboutToBeChanged = false;
                }
            };
            this.fSourceViewer.addTextInputListener(this.fTextInputListener);
        }
    }

    public void addDrawingStrategy(Object id, AnnotationPainter.IDrawingStrategy strategy) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.fPaintingStrategyId2PaintingStrategy.put(id, strategy);
        this.fCachedAnnotationType2PaintingStrategy.clear();
    }

    public void addTextStyleStrategy(Object id, AnnotationPainter.ITextStyleStrategy strategy) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.fPaintingStrategyId2PaintingStrategy.put(id, strategy);
        this.fCachedAnnotationType2PaintingStrategy.clear();
    }

    public void addHighlightAnnotationType(Object annotationType) {
        this.addAnnotationType(annotationType, HIGHLIGHTING);
    }

    public void removeAnnotationType(Object annotationType) {
        this.fCachedAnnotationType2PaintingStrategy.clear();
        this.fAnnotationType2PaintingStrategyId.remove(annotationType);
        if (this.fAnnotationType2PaintingStrategyId.isEmpty() && this.fTextInputListener != null) {
            this.fSourceViewer.removeTextInputListener(this.fTextInputListener);
            this.fTextInputListener = null;
            this.fInputDocumentAboutToBeChanged = false;
        }
    }

    public void removeHighlightAnnotationType(Object annotationType) {
        this.removeAnnotationType(annotationType);
    }

    public void removeAllAnnotationTypes() {
        this.fCachedAnnotationType2PaintingStrategy.clear();
        this.fAnnotationType2PaintingStrategyId.clear();
        if (this.fTextInputListener != null) {
            this.fSourceViewer.removeTextInputListener(this.fTextInputListener);
            this.fTextInputListener = null;
        }
    }

    public boolean isPaintingAnnotations() {
        return !this.fAnnotationType2PaintingStrategyId.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.fAnnotationType2Color != null) {
            this.fAnnotationType2Color.clear();
            this.fAnnotationType2Color = null;
        }
        if (this.fCachedAnnotationType2Color != null) {
            this.fCachedAnnotationType2Color.clear();
            this.fCachedAnnotationType2Color = null;
        }
        if (this.fCachedAnnotationType2PaintingStrategy != null) {
            this.fCachedAnnotationType2PaintingStrategy.clear();
            this.fCachedAnnotationType2PaintingStrategy = null;
        }
        if (this.fAnnotationType2PaintingStrategyId != null) {
            this.fAnnotationType2PaintingStrategyId.clear();
            this.fAnnotationType2PaintingStrategyId = null;
        }
        this.fTextWidget = null;
        this.fSourceViewer = null;
        this.fAnnotationAccess = null;
        this.fModel = null;
        Object object = this.fDecorationMapLock;
        synchronized (object) {
            this.fDecorationsMap = null;
        }
        object = this.fHighlightedDecorationsMapLock;
        synchronized (object) {
            this.fHighlightedDecorationsMap = null;
        }
    }

    private int getInclusiveTopIndexStartOffset() {
        if (this.fTextWidget != null && !this.fTextWidget.isDisposed()) {
            int top = JFaceTextUtil.getPartialTopIndex((ITextViewer)this.fSourceViewer);
            try {
                IDocument document = this.fSourceViewer.getDocument();
                return document.getLineOffset(top);
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    private int getExclusiveBottomIndexEndOffset() {
        if (this.fTextWidget != null && !this.fTextWidget.isDisposed()) {
            int bottom = JFaceTextUtil.getPartialBottomIndex((ITextViewer)this.fSourceViewer);
            try {
                IDocument document = this.fSourceViewer.getDocument();
                if (bottom >= document.getNumberOfLines()) {
                    bottom = document.getNumberOfLines() - 1;
                }
                return document.getLineOffset(bottom) + document.getLineLength(bottom);
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    public void paintControl(PaintEvent event) {
        if (this.fTextWidget != null) {
            this.handleDrawRequest(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDrawRequest(PaintEvent event) {
        ArrayList<Map.Entry<Annotation, Decoration>> decorations;
        if (this.fTextWidget == null) {
            return;
        }
        IRegion clippingRegion = this.computeClippingRegion(event, false);
        if (clippingRegion == null) {
            return;
        }
        int vOffset = clippingRegion.getOffset();
        int vLength = clippingRegion.getLength();
        GC gc = event != null ? event.gc : null;
        Object object = this.fDecorationMapLock;
        synchronized (object) {
            decorations = new ArrayList<Map.Entry<Annotation, Decoration>>(this.fDecorationsMap.size());
            decorations.addAll(this.fDecorationsMap.entrySet());
        }
        ArrayList toBeDrawn = new ArrayList(10);
        for (Map.Entry entry : decorations) {
            Annotation a = (Annotation)entry.getKey();
            Decoration pp = (Decoration)entry.getValue();
            if (a.isMarkedDeleted() || this.skip(a) || !this.regionsTouchOrOverlap(pp.fPosition.getOffset(), pp.fPosition.getLength(), vOffset, vLength)) continue;
            int i = toBeDrawn.size();
            while (i <= pp.fLayer) {
                toBeDrawn.add(new LinkedList());
                ++i;
            }
            ((LinkedList)toBeDrawn.get(pp.fLayer)).add(entry);
        }
        IDocument iDocument = this.fSourceViewer.getDocument();
        for (LinkedList linkedList : toBeDrawn) {
            for (Map.Entry entry : linkedList) {
                Annotation a = (Annotation)entry.getKey();
                Decoration pp = (Decoration)entry.getValue();
                this.drawDecoration(pp, gc, a, clippingRegion, iDocument);
            }
        }
    }

    private void drawDecoration(Decoration pp, GC gc, Annotation annotation, IRegion clippingRegion, IDocument document) {
        if (clippingRegion == null) {
            return;
        }
        if (!(pp.fPaintingStrategy instanceof AnnotationPainter.IDrawingStrategy)) {
            return;
        }
        AnnotationPainter.IDrawingStrategy drawingStrategy = (AnnotationPainter.IDrawingStrategy)pp.fPaintingStrategy;
        int clippingOffset = clippingRegion.getOffset();
        int clippingLength = clippingRegion.getLength();
        Position p = pp.fPosition;
        try {
            int startLine = document.getLineOfOffset(p.getOffset());
            int lastInclusive = Math.max(p.getOffset(), p.getOffset() + p.getLength() - 1);
            int endLine = document.getLineOfOffset(lastInclusive);
            int i = startLine;
            while (i <= endLine) {
                IRegion widgetRange;
                int lineOffset = document.getLineOffset(i);
                int paintStart = Math.max(lineOffset, p.getOffset());
                String lineDelimiter = document.getLineDelimiter(i);
                int delimiterLength = lineDelimiter != null ? lineDelimiter.length() : 0;
                int paintLength = Math.min(lineOffset + document.getLineLength(i) - delimiterLength, p.getOffset() + p.getLength()) - paintStart;
                if (paintLength >= 0 && this.regionsTouchOrOverlap(paintStart, paintLength, clippingOffset, clippingLength) && (widgetRange = this.getWidgetRange(paintStart, paintLength)) != null) {
                    drawingStrategy.draw(annotation, gc, this.fTextWidget, widgetRange.getOffset(), widgetRange.getLength(), pp.fColor);
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private IRegion computeClippingRegion(PaintEvent event, boolean isClearing) {
        int widgetEndOffset;
        int widgetOffset;
        if (event == null) {
            if (!isClearing && this.fCurrentDrawRange != null) {
                return new Region(this.fCurrentDrawRange.offset, this.fCurrentDrawRange.length);
            }
            int vOffset = this.getInclusiveTopIndexStartOffset();
            if (vOffset == -1) {
                return null;
            }
            int vLength = this.getExclusiveBottomIndexEndOffset() - vOffset;
            return new Region(vOffset, vLength);
        }
        try {
            int widgetClippingStartOffset = this.fTextWidget.getOffsetAtLocation(new Point(0, event.y));
            int firstWidgetLine = this.fTextWidget.getLineAtOffset(widgetClippingStartOffset);
            widgetOffset = this.fTextWidget.getOffsetAtLine(firstWidgetLine);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                int firstVisibleLine = JFaceTextUtil.getPartialTopIndex((StyledText)this.fTextWidget);
                widgetOffset = this.fTextWidget.getOffsetAtLine(firstVisibleLine);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                widgetOffset = 0;
            }
        }
        try {
            int widgetClippingEndOffset = this.fTextWidget.getOffsetAtLocation(new Point(0, event.y + event.height));
            int lastWidgetLine = this.fTextWidget.getLineAtOffset(widgetClippingEndOffset);
            widgetEndOffset = this.fTextWidget.getOffsetAtLine(lastWidgetLine + 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                int lastVisibleLine = JFaceTextUtil.getPartialBottomIndex((StyledText)this.fTextWidget);
                widgetEndOffset = lastVisibleLine == this.fTextWidget.getLineCount() - 1 ? this.fTextWidget.getCharCount() : this.fTextWidget.getOffsetAtLine(lastVisibleLine + 1) - 1;
            }
            catch (IllegalArgumentException illegalArgumentException3) {
                widgetEndOffset = this.fTextWidget.getCharCount();
            }
        }
        IRegion clippingRegion = this.getModelRange(widgetOffset, widgetEndOffset - widgetOffset);
        return clippingRegion;
    }

    protected boolean skip(Annotation annotation) {
        return false;
    }

    private IRegion getWidgetRange(int modelOffset, int modelLength) {
        int length;
        if (modelOffset == Integer.MAX_VALUE) {
            return null;
        }
        if (this.fSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fSourceViewer;
            this.fReusableRegion.setOffset(modelOffset);
            this.fReusableRegion.setLength(modelLength);
            return extension.modelRange2WidgetRange((IRegion)this.fReusableRegion);
        }
        IRegion region = this.fSourceViewer.getVisibleRegion();
        int offset = region.getOffset();
        if (this.regionsTouchOrOverlap(modelOffset, modelLength, offset, length = region.getLength())) {
            int p1 = Math.max(offset, modelOffset);
            int p2 = Math.min(offset + length, modelOffset + modelLength);
            this.fReusableRegion.setOffset(p1 - offset);
            this.fReusableRegion.setLength(p2 - p1);
            return this.fReusableRegion;
        }
        return null;
    }

    private IRegion getModelRange(int offset, int length) {
        if (offset == Integer.MAX_VALUE) {
            return null;
        }
        if (this.fSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fSourceViewer;
            return extension.widgetRange2ModelRange((IRegion)new Region(offset, length));
        }
        IRegion region = this.fSourceViewer.getVisibleRegion();
        return new Region(region.getOffset() + offset, length);
    }

    private boolean regionsTouchOrOverlap(int offset1, int length1, int offset2, int length2) {
        return offset1 <= offset2 + length2 && offset2 <= offset1 + length1;
    }

    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.disablePainting(redraw);
            this.setModel(null);
            this.catchupWithModel(null);
        }
    }

    protected boolean isRepaintReason(int reason) {
        return 16 == reason || 8 == reason;
    }

    protected IAnnotationModel findAnnotationModel(ISourceViewer sourceViewer) {
        if (sourceViewer != null) {
            return sourceViewer.getAnnotationModel();
        }
        return null;
    }

    public void paint(int reason) {
        if (this.fSourceViewer.getDocument() == null) {
            this.deactivate(false);
            return;
        }
        if (!this.fIsActive) {
            IAnnotationModel model = this.findAnnotationModel(this.fSourceViewer);
            if (model != null) {
                this.fIsActive = true;
                this.setModel(model);
            }
        } else if (this.isRepaintReason(reason)) {
            this.updatePainting(null);
        }
    }

    public void setPositionManager(IPaintPositionManager manager) {
    }

    private static class Decoration {
        private Position fPosition;
        private Color fColor;
        private int fLayer;
        private Object fPaintingStrategy;

        private Decoration() {
        }
    }

    private static class ReusableRegion
    extends DVTPosition
    implements IRegion {
        private ReusableRegion() {
        }
    }
}

