/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.rules.ICharacterScanner;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DVTCharacterScanner
implements ICharacterScanner {
    private int fBufferSize;
    private char[] fBuffer;
    protected IDocument fDocument;
    protected int fOffset;
    private int fStart;
    private int fEnd;
    private int fDocumentLength;
    private boolean fForward;

    public DVTCharacterScanner(int bufferSize, IDocument document, int offset, boolean forward) {
        this.fDocument = document;
        this.fForward = forward;
        this.fOffset = this.fForward ? offset : (offset == document.getLength() ? offset : offset + 1);
        this.fBufferSize = bufferSize;
        this.fDocumentLength = document.getLength();
        this.setBufferSize(bufferSize);
        this.shiftBuffer(this.fOffset);
    }

    protected void setBufferSize(int size) {
        Assert.isTrue((size > 0 ? 1 : 0) != 0);
        this.fBufferSize = size;
        this.fBuffer = new char[size];
    }

    private void shiftBuffer(int offset) {
        try {
            if (this.fForward) {
                this.fStart = Math.min(offset, this.fDocumentLength);
                this.fEnd = Math.min(this.fStart + this.fBufferSize, this.fDocumentLength);
            } else {
                this.fEnd = Math.min(offset, this.fDocumentLength);
                this.fStart = Math.max(this.fEnd - this.fBufferSize, 0);
            }
            String content = this.fDocument.get(this.fStart, this.fEnd - this.fStart);
            content.getChars(0, this.fEnd - this.fStart, this.fBuffer, 0);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public int getColumn() {
        return -1;
    }

    public char[][] getLegalLineDelimiters() {
        return null;
    }

    public int read() {
        if (this.fForward) {
            if (this.fOffset >= this.fDocumentLength) {
                ++this.fOffset;
                return -1;
            }
            if (this.fOffset < this.fStart || this.fEnd <= this.fOffset) {
                this.shiftBuffer(this.fOffset);
            }
            ++this.fOffset;
            return this.fBuffer[this.fOffset - this.fStart - 1];
        }
        if (this.fOffset <= 0) {
            --this.fOffset;
            return -1;
        }
        if (this.fOffset <= this.fStart || this.fEnd < this.fOffset) {
            this.shiftBuffer(this.fOffset);
        }
        --this.fOffset;
        if (this.fOffset - this.fStart >= this.fBufferSize) {
            return -1;
        }
        return this.fBuffer[this.fOffset - this.fStart];
    }

    public void unread() {
        if (this.fForward) {
            if (this.fOffset == this.fStart) {
                this.shiftBuffer(Math.max(0, this.fStart - this.fBufferSize / 2));
            }
            --this.fOffset;
        } else {
            if (this.fOffset == this.fEnd) {
                this.shiftBuffer(Math.max(0, this.fEnd - this.fBufferSize / 2));
            }
            ++this.fOffset;
        }
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLineOfOffset(int offset) {
        try {
            return this.fDocument.getLineOfOffset(offset);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    public String getLine(int line) {
        try {
            IRegion r = this.fDocument.getLineInformation(line);
            return this.fDocument.get(r.getOffset(), r.getLength());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    public boolean isAtColumn(int column) {
        block5: {
            block4: {
                try {
                    if (this.fOffset != 1 || column != 1) break block4;
                    return true;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return false;
                }
            }
            if (this.fOffset - column - 1 >= 0) break block5;
            return false;
        }
        char ch0 = this.fDocument.getChar(this.fOffset - column - 1);
        char ch1 = this.fDocument.getChar(this.fOffset - column);
        return (ch0 == '\n' || ch0 == '\r') && ch1 != '\r' && ch1 != '\n';
    }

    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    public void setBackwardDirection() {
        this.fForward = false;
    }
}

