/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTOverrideAnnotationProvider;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingProvider;

public class DVTConnectPositionToDocumentProvider {
    private DVTOverrideAnnotationProvider overrideAnnoProvider;
    private DVTSemanticFoldingProvider semanticFoldingProvider;
    private List<Position> reflectionPositions;
    private DVTEditor editor;

    public DVTConnectPositionToDocumentProvider(Map<Position, Position> cachedPositions, boolean connectOnlyVisualPositions, boolean shouldAddFolding, DVTEditor editor) {
        this.createOverrideProvider(cachedPositions, connectOnlyVisualPositions);
        this.createSemanticFoldingProvider(shouldAddFolding);
        this.setEditor(editor);
        this.reflectionPositions = new ArrayList<Position>();
    }

    private void createOverrideProvider(Map<Position, Position> cachedPositions, boolean connectOnlyVisualPositions) {
        this.overrideAnnoProvider = new DVTOverrideAnnotationProvider(cachedPositions, connectOnlyVisualPositions);
    }

    private void createSemanticFoldingProvider(boolean shouldAddFolding) {
        this.semanticFoldingProvider = new DVTSemanticFoldingProvider(shouldAddFolding);
    }

    public DVTOverrideAnnotationProvider getOverrideAnnotationProvider() {
        return this.overrideAnnoProvider;
    }

    public DVTSemanticFoldingProvider getSemanticFoldingProvider() {
        return this.semanticFoldingProvider;
    }

    public DVTEditor getEditor() {
        return this.editor;
    }

    public void setEditor(DVTEditor editor) {
        this.editor = editor;
    }

    public List<Position> getReflectionPositions() {
        return this.reflectionPositions;
    }
}

