/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSessionEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentRewriteSessionListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import ro.amiq.dvt.DVTHelp;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIHostContributorManager;
import ro.amiq.dvt.ai.IAIHostContributor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.debug.ui.view.QuickLazyDVTVariablesView;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldModel;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldUtils;
import ro.amiq.dvt.diagrams.wavedrom.WaveDromManager;
import ro.amiq.dvt.model.ChangedFilesManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBaseElement;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.ReadOnlyNotification;
import ro.amiq.dvt.ui.SimpleDVTNotification;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.custompragma.CustomPragmaPosition;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUtils;
import ro.amiq.dvt.ui.editor.DVTCustomFoldingPosition;
import ro.amiq.dvt.ui.editor.DVTEditorCommon;
import ro.amiq.dvt.ui.editor.DVTEditorMessages;
import ro.amiq.dvt.ui.editor.DVTExternalToolFormatter;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.DVTPresentationReconciler;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.DVTSourceViewerDecorationSupport;
import ro.amiq.dvt.ui.editor.DVTTextOperationAction;
import ro.amiq.dvt.ui.editor.DVTWordFinder;
import ro.amiq.dvt.ui.editor.DVTWordOccurrencesWrapper;
import ro.amiq.dvt.ui.editor.EditorMaximizeListener;
import ro.amiq.dvt.ui.editor.FileAcessEditorDecorator;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.editor.IToggleCommentAction;
import ro.amiq.dvt.ui.editor.JumpAroundBracketAction;
import ro.amiq.dvt.ui.editor.LineBackgroundPainter;
import ro.amiq.dvt.ui.editor.PersistentDVTNotification;
import ro.amiq.dvt.ui.editor.SelectAndFindNextAction;
import ro.amiq.dvt.ui.editor.SelectEnclosingElementCommon;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.actions.CopyHierarchyPathAction;
import ro.amiq.dvt.ui.editor.actions.DVTHippieCompleteAction;
import ro.amiq.dvt.ui.editor.actions.IReferencesAction;
import ro.amiq.dvt.ui.editor.actions.SelectAnnotationRulerAction;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.elaborationhighlight.ElaborationHighlightListener;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationHelper;
import ro.amiq.dvt.ui.editor.floatingwidgets.FMouseDownFilterListener;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.IFNotificationHost;
import ro.amiq.dvt.ui.editor.formatter.detectindentation.DVTAutoIndentDetectionManager;
import ro.amiq.dvt.ui.editor.formatter.detectindentation.DVTAutoIndentDetector;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.DVTSemanticHighlighter;
import ro.amiq.dvt.ui.editor.highlight.SemanticHighlightJob;
import ro.amiq.dvt.ui.editor.lazy.outline.DVTLazyOutlinePage;
import ro.amiq.dvt.ui.editor.lazy.outline.QuickLazyOutlineView;
import ro.amiq.dvt.ui.editor.pathmanager.DPMListenerManager;
import ro.amiq.dvt.ui.editor.pathmanager.DPMNotification;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.ui.search.ui.IBaseShowConstraintsAction;
import ro.amiq.dvt.ui.search.ui.IBaseShowEmittersAction;
import ro.amiq.dvt.ui.search.ui.IBaseShowInstancesAction;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.inspect.InspectView;
import ro.amiq.dvt.ui.views.inspect.InspectViewSelectionListener;
import ro.amiq.dvt.ui.views.inspect.WaveDromListener;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.MatchBeginEndPositionInfo;
import ro.amiq.dvt.workspace.WorkspaceDiskSpaceOnSaveChecker;

public abstract class DVTEditor
extends DVTEditorCommon
implements ILabelProviderListener,
IFNotificationHost {
    public static final String DVT_HIPPIE_COMPLETION_PROPOSAL_DISABLE_ENVVAR = "DVT_HIPPIE_COMPLETION_PROPOSAL_DISABLE";
    private static final String SELECT_AND_FIND_PREVIOUS = "Select and Find Previous";
    private static final String SELECT_AND_FIND_PREVIOUS_ACTION_ID = "ro.amiq.dvt.ui.editor.SelectAndFindPrevious";
    private static final String SELECT_AND_FIND_NEXT = "Select and Find Next";
    private static final String SELECT_AND_FIND_NEXT_ACTION_ID = "ro.amiq.dvt.ui.editor.SelectAndFindNext";
    private static final String JUMP_BEFORE_LEFT_BRACKET = "Jump before Left Bracket";
    private static final String JUMP_BEFORE_LEFT_BRACKET_ID = "ro.amiq.dvt.ui.editor.JumpBeforeLeftBracket";
    private static final String JUMP_AFTER_RIGHT_BRACKET = "Jump after Right Bracket";
    private static final String JUMP_AFTER_RIGHT_BRACKET_ID = "ro.amiq.dvt.ui.editor.JumpAfterRightBracket";
    private static final String SELECT_ANNOTATION_RULER_ACTION = "Select Annotation Ruler";
    private static final String SELECT_ANNOTATION_RULER_ACTION_ID = "ro.amiq.dvt.ui.editor.SelectAnnotationRulerAction";
    public static final String REFERENCES_SUBMENU_COMMON_ID = "ro.amiq.dvt.ui.editor.ReferencesSubMenu";
    public static final String SHOW_READERS_USAGES = "ro.amiq.dvt.ui.views.commands.ShowReaders";
    public static final String SHOW_WRITERS_USAGES = "ro.amiq.dvt.ui.views.commands.ShowWriters";
    private SemanticHighlightJob fHighlightJob;
    private SHInvalidateJob fSHInvalidateJob = new SHInvalidateJob();
    private static final int HIGHLIGHT_SCROLL_DELAY = 100;
    private ElaborationHighlightListener fElaborationBreadcrumbHighlightListener = new ElaborationHighlightListener(this);
    private PopReadOnlyNotificationJob fReadOnlyNotificationJob = new PopReadOnlyNotificationJob();
    private ReadOnlyNotification fReadOnlyNotification;
    private final AtomicBoolean fIsAltPressed = new AtomicBoolean(false);
    private LineBackgroundPainter fLineBackgroundPainter;
    private IPreferenceStore fPrefStore;
    public static final String KEYS_PREFERENCE_PAGE_ID = "org.eclipse.ui.preferencePages.Keys";
    private Deque<Point> fSelectionStack = new ArrayDeque<Point>(){
        private static final long serialVersionUID = 1L;

        @Override
        public void push(Point item) {
            if (!this.isEmpty() && item.equals(this.peek())) {
                return;
            }
            super.push(item);
        }
    };
    private SelectionListener fSelectionListenerForEnlosingScope;
    protected boolean fPropertyChangedEvent;
    protected IHandlerService fHandlerService;
    protected Map<String, IHandlerActivation> fSubmenuHandlerActivations = new HashMap<String, IHandlerActivation>();
    private boolean fSelectionCleared;
    private Composite fNotificationsHostComposite;
    private Composite fControlParent;
    private DHBreadcrumbViewer fDHBreadcrumbViewer;
    private VHBreadcrumbViewer fVHBreadcrumbViewer;
    private ScopeBreadcrumbViewer fScopeBreadcrumbViewer;
    private FSBreadcrumbViewer fFilesystemBreadcrumbViewer;
    private int fScopeBCLineCache;
    private Composite fTopContainer;
    protected OnePreferenceListener fPreferenceListener = new OnePreferenceListener();
    protected MarkOccurencesPreferenceListener fMarkOccurencesPreferenceListener = new MarkOccurencesPreferenceListener();
    private SimpleDVTNotification fContentAssistNotification;
    private IOperationHistoryListener fUndoListener;
    private boolean fFormattingOperationInProgress;
    private boolean fMatchPartialWords = DVTPlugin.getDefault().getPreferenceStore().getBoolean("editor.markOccurencesMatchPartialWords");
    private DVTWordOccurrencesWrapper fPrevOccurrencesWrapper = new DVTWordOccurrencesWrapper();
    private ProjectionAnnotationModel fAnnotationModel;
    private ProjectionSupport fProjectionSupport;
    private long fMarkOccurrenceModificationStamp = -1L;
    private IRegion fMarkOccurrenceTargetRegion;
    private Annotation[] fOccurrenceAnnotations;
    private boolean fMarkOccurrenceAnnotations = true;
    private boolean fStickyOccurrenceAnnotations;
    private DVTWordFinder fWordFinder;
    private DVTPresentationReconciler fFoldingManager;
    private boolean hasShownReadOnly;
    private FocusListener fFocusListener;
    public int fFocusLostEventTime;
    private IPartListener2 fPartListener;
    private IViewportListener fScrollingViewportListener;
    private RebuildTriggerListener fRebuildListener;
    private IDocumentRewriteSessionListener fRewriteSessionListener;
    private ContentAssistListener fContentAssistListener;
    private IPropertyChangeListener fPropertyChangeListener;
    private DocumentChangedAfterCursorMovedListener fDocumentChangedAfterCursorMovedListener;
    private IJobChangeListener fJobChangeListener;
    private int fCursorOffset;
    private static final ExecutorService hotspotUpdateExecutor = Executors.newSingleThreadExecutor();
    private OccurrencesFinderJob fOccurrencesFinderJob;
    private OccurrencesFinderJobCanceler fOccurrencesFinderJobCanceler;
    private DVTProjectionViewer fSourceViewer;
    private KeyListener fAltKeyListener;
    private SelectionAdapter fSelectAndNotRevealListener;
    public long fLastFocusedTimestamp;
    private PersistentDVTNotification fPendingSaveNotification;
    private boolean fBufferSaveInProgress;
    private AtomicBoolean fBufferSavePending = new AtomicBoolean(false);
    private static final String NOT_SAVED_NOTIFICATION = "NOT_SAVED_NOTIFICATION";
    private static final String NOT_SAVED_MESSAGE = "Pending save (waiting for build/restore to finish)";
    private InspectViewSelectorJob fInspectViewSelectorJob = new InspectViewSelectorJob();
    private static final boolean INSPECT_DISABLED = System.getenv("DISABLE_INSPECT_VIEW") != null;
    private static final boolean WAVEDROM_DISABLED = System.getenv("DVT_DISABLE_WAVEDROM") != null;
    private static final long TRIGGER_WAVEDROM_UPDATE_FROM_EDITOR_JOB_DELAY = 300L;

    protected abstract void installSubmenuActions();

    @Override
    public void setVisible(boolean value) {
    }

    protected abstract boolean c();

    public void setFormattingOperationInProgress() {
        this.fFormattingOperationInProgress = true;
    }

    public void resetFormattingOperationInProgress() {
        this.fFormattingOperationInProgress = false;
    }

    private void expandSelectionAndReveal(int offset, int length) {
        this.getTextViewer().getTextWidget().removeSelectionListener(this.fSelectionListenerForEnlosingScope);
        this.selectAndReveal(offset, length);
        this.getTextViewer().getTextWidget().addSelectionListener(this.fSelectionListenerForEnlosingScope);
    }

    private Position[] getFoldingPositions() {
        ArrayList<Position> result = new ArrayList<Position>();
        ProjectionAnnotationModel projectAnnotationModel = this.fSourceViewer.getProjectionAnnotationModel();
        Iterator annotationIterator = projectAnnotationModel.getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            Annotation annotation = (Annotation)annotationIterator.next();
            result.add(projectAnnotationModel.getPosition(annotation));
        }
        return result.toArray(new Position[result.size()]);
    }

    protected DVTEditor() {
        this.fWordFinder = this.getWordFinder();
        TestHelper.fOpenEditorTime = System.currentTimeMillis();
    }

    protected DVTEditor(IDocument document) {
        this();
    }

    public void dispose() {
        try {
            try {
                TextEditorAction action = (TextEditorAction)this.getAction("ToggleMarkOccurrences");
                if (action != null) {
                    action.setEditor(null);
                }
                if ((action = (TextEditorAction)this.getAction("ToggleComment")) != null) {
                    action.setEditor(null);
                }
                this.fAnnotationModel = null;
                this.fMarkOccurrenceTargetRegion = null;
                this.uninstallOccurrencesFinder();
                this.fOccurrenceAnnotations = null;
                if (this.fSourceViewer != null) {
                    this.fSourceViewer.unconfigure();
                }
                this.fFoldingManager = null;
                if (this.fProjectionSupport != null) {
                    this.fProjectionSupport.dispose();
                    this.fProjectionSupport = null;
                }
                this.fMarkOccurrenceAnnotations = false;
                this.removeOccurrenceAnnotations();
                CustomPragmaUtils.removeListener(this.fLineBackgroundPainter);
                if (this.fSourceViewer != null) {
                    this.fSourceViewer.removePainter(this.fLineBackgroundPainter);
                    if (this.fSourceViewer.getTextWidget() != null) {
                        this.fSourceViewer.getTextWidget().dispose();
                    }
                }
                this.fLineBackgroundPainter = null;
                if (this.fBufferSavePending.get() && !this.fBufferSaveInProgress) {
                    this.doRegularSave();
                }
                this.fBufferSavePending = null;
                if (this.fSubmenuHandlerActivations != null && !this.fSubmenuHandlerActivations.isEmpty() && this.fHandlerService != null) {
                    for (IHandlerActivation activation : this.fSubmenuHandlerActivations.values()) {
                        this.fHandlerService.deactivateHandler(activation);
                    }
                }
                this.fHandlerService = null;
                this.fSubmenuHandlerActivations = null;
                if (this.fHighlightJob != null) {
                    this.fHighlightJob.cancel();
                    this.fHighlightJob = null;
                }
                if (this.fNotificationsHostComposite != null) {
                    this.fNotificationsHostComposite.dispose();
                    this.fNotificationsHostComposite = null;
                }
                if (this.fControlParent != null) {
                    this.fControlParent.dispose();
                    this.fControlParent = null;
                }
                if (this.fTopContainer != null) {
                    this.fTopContainer.dispose();
                    this.fTopContainer = null;
                }
                this.fSourceViewer = null;
                DesignPathManager.getInstance().unregister(this);
                DPMListenerManager.INSTANCE.unregister(this);
                this.deepClean();
                FWidgetFactory.INSTANCE.disposeWidgets(this);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                super.dispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    public boolean isAltPressed() {
        return this.fIsAltPressed.get();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        this.fSourceViewer = new DVTProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, this);
        SourceViewerDecorationSupport support = this.getSourceViewerDecorationSupport((ISourceViewer)this.fSourceViewer);
        this.configureSourceViewerDecorationSupport(support);
        return this.fSourceViewer;
    }

    private void createNotificationsHostComposite(Composite parent) {
        this.fTopContainer = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.fTopContainer);
        this.fNotificationsHostComposite = new Composite(this.fTopContainer, 0);
        GridDataFactory.fillDefaults().applyTo((Control)this.fNotificationsHostComposite);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.fNotificationsHostComposite);
        this.fControlParent = new Composite(this.fTopContainer, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.fControlParent);
        if (parent.getLayout() instanceof FillLayout) {
            this.fControlParent.setLayout((Layout)new FillLayout());
        } else if (parent.getLayout() instanceof GridLayout) {
            GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.fControlParent);
        }
    }

    public void createPartControl(Composite parent) {
        if (this.getEditorInput() == null) {
            return;
        }
        this.createNotificationsHostComposite(parent);
        super.createPartControl(this.fControlParent);
        this.fProjectionSupport = new ProjectionSupport((ProjectionViewer)this.fSourceViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.configureProjectionSupport(this.fProjectionSupport);
        this.fProjectionSupport.install();
        this.fSourceViewer.doOperation(19);
        this.fAnnotationModel = this.fSourceViewer.getProjectionAnnotationModel();
        this.configureSourceViewerConfiguration(this.fAnnotationModel);
        this.fFoldingManager = (DVTPresentationReconciler)this.getSourceViewerConfiguration().getPresentationReconciler((ISourceViewer)this.fSourceViewer);
        this.installOccurrencesFinder(true);
        this.fLineBackgroundPainter = new LineBackgroundPainter((ITextViewer)this.fSourceViewer, this.fPrefStore, this.getProject());
        CustomPragmaUtils.addListener(this.fLineBackgroundPainter);
        this.fSourceViewer.addPainter(this.fLineBackgroundPainter);
        this.updateBackgroundHighlightPositions("__dvt_pverilog_preproc_code_position");
        this.updateBackgroundHighlightPositions("__dvt_pverilog_generated_code_position");
        this.updateBackgroundHighlightPositions("__dvt_inactive_code_position");
        this.updateBackgroundHighlightPositions("__dvt_protected_code_position");
        this.updateBackgroundHighlightPositions("CUSTOM_PRAGMA");
        FWidgetFactory.INSTANCE.createWidgets(this);
        this.installListeners();
        EditorMaximizeListener.INSTANCE.editorOpened(this);
        EditorEmulationHelper.INSTANCE.manageContentAssistNotifications(Arrays.asList(this));
    }

    public void installListeners() {
        IDocument document;
        this.fRebuildListener = new RebuildTriggerListener();
        this.fRewriteSessionListener = new DocumentRewriteSessionListener();
        this.fContentAssistListener = new ContentAssistListener();
        this.fDocumentChangedAfterCursorMovedListener = new DocumentChangedAfterCursorMovedListener();
        this.fJobChangeListener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (DVTEditor.this.fBufferSavePending == null || !DVTEditor.this.fBufferSavePending.get()) {
                    return;
                }
                Display.getDefault().asyncExec(() -> {
                    IResource resource = (IResource)DVTEditor.this.getAdapter(IResource.class);
                    if (!DVTEditor.this.fBufferSaveInProgress && !DVTJobsUtils.isBlockingJobInProgress(resource)) {
                        DVTEditor.this.fBufferSaveInProgress = true;
                        DVTEditor.this.doRegularSave();
                        DVTEditor.this.fBufferSaveInProgress = false;
                        if (DVTEditor.this.fPendingSaveNotification != null) {
                            DVTEditor.this.fPendingSaveNotification.destroy();
                            DVTEditor.this.fPendingSaveNotification = null;
                        }
                    }
                });
            }
        };
        Job.getJobManager().addJobChangeListener(this.fJobChangeListener);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("ca.chars_trigger")) {
                    DVTEditor.this.fContentAssistListener.initialize();
                }
            }
        };
        this.fScrollingViewportListener = new IViewportListener(){

            public void viewportChanged(int verticalOffset) {
                if (!TestHelper.isTestMode()) {
                    DVTEditor.this.fSHInvalidateJob.cancel();
                    DVTEditor.this.fSHInvalidateJob.schedule(100L);
                }
                DVTEditor.this.disposeFloatingWidgetsDetails();
            }
        };
        this.fPartListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                if (DVTEditor.this.fCurrentFile == null) {
                    return;
                }
                IPath location = DVTEditor.this.fCurrentFile.getLocation();
                if (location == null) {
                    return;
                }
                IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
                if (aiHostContributor != null) {
                    aiHostContributor.addRecentFile(location.toOSString());
                }
            }

            public void partHidden(IWorkbenchPartReference partRef) {
                if (!partRef.getPage().isPartVisible((IWorkbenchPart)DVTEditor.this) && DVTEditor.this.fHighlightJob != null) {
                    DVTEditor.this.fHighlightJob.cancel();
                    DVTEditor.this.fHighlightJob = null;
                }
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        };
        this.fAltKeyListener = new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 65536) {
                    DVTEditor.this.fIsAltPressed.set(false);
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 65536) {
                    DVTEditor.this.fIsAltPressed.set(true);
                }
            }
        };
        this.fFocusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                DVTEditor.this.fFocusLostEventTime = e.time;
                FMouseDownFilterListener.INSTANCE.removeDisplayFilter(DVTEditor.this.getFNotificationHostCanvas());
            }

            public void focusGained(FocusEvent e) {
                FMouseDownFilterListener.INSTANCE.addDisplayFilter(DVTEditor.this.getFNotificationHostCanvas());
            }
        };
        this.fSelectAndNotRevealListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DVTEditor.this.fSelectionCleared || !DVTPlugin.getDefault().getPreferenceStore().getBoolean("clear_selection_focus_lost")) {
                    return;
                }
                DVTEditor.this.fSelectionCleared = true;
                for (IEditorReference openEditorReference : Utils.getCurrentlyOpenEditorReferences()) {
                    ISelection selection;
                    IEditorPart openEditor = openEditorReference.getEditor(false);
                    if (openEditor == null || openEditor == DVTEditor.this || !(openEditor instanceof IDVTEditor) || !((selection = ((TextEditor)openEditor).getSelectionProvider().getSelection()) instanceof TextSelection) || ((TextSelection)selection).getLength() == 0) continue;
                    ((IDVTEditor)openEditor).selectAndNotReveal(((TextSelection)selection).getOffset(), 0);
                }
            }
        };
        this.fSelectionListenerForEnlosingScope = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DVTEditor.this.fSelectionStack.clear();
            }
        };
        this.fSourceViewer.getTextWidget().addKeyListener(this.fAltKeyListener);
        this.fSourceViewer.getTextWidget().addFocusListener(this.fFocusListener);
        this.fSourceViewer.getTextWidget().addCaretListener((CaretListener)this.fDocumentChangedAfterCursorMovedListener);
        this.fSourceViewer.getTextWidget().addModifyListener((ModifyListener)this.fDocumentChangedAfterCursorMovedListener);
        this.installSelectionListener(this.fSourceViewer.getTextWidget());
        this.fSourceViewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (e.widget instanceof StyledText) {
                    ((StyledText)e.widget).removeKeyListener(DVTEditor.this.fAltKeyListener);
                    ((StyledText)e.widget).removeFocusListener(DVTEditor.this.fFocusListener);
                    ((StyledText)e.widget).removeCaretListener((CaretListener)DVTEditor.this.fDocumentChangedAfterCursorMovedListener);
                    ((StyledText)e.widget).removeModifyListener((ModifyListener)DVTEditor.this.fDocumentChangedAfterCursorMovedListener);
                    DVTEditor.this.removeSelectionListener((StyledText)e.widget);
                    DVTEditor.this.fAltKeyListener = null;
                    DVTEditor.this.fFocusListener = null;
                }
            }
        });
        IPreferenceStore pluginSpecificPreferenceStore = this.getPluginSpecificPreferenceStore();
        if (pluginSpecificPreferenceStore != null) {
            pluginSpecificPreferenceStore.addPropertyChangeListener(this.fPropertyChangeListener);
        }
        if ((document = this.getDocument()) != null) {
            document.addDocumentListener((IDocumentListener)this.fRebuildListener);
            document.addDocumentListener((IDocumentListener)this.fContentAssistListener);
            if (document instanceof IDocumentExtension4) {
                ((IDocumentExtension4)document).addDocumentRewriteSessionListener(this.fRewriteSessionListener);
            }
        }
        this.fSourceViewer.addViewportListener(this.fScrollingViewportListener);
        DVTUiUtils.getActivePage().addPartListener(this.fPartListener);
        this.fPrefStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        DVTPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.fMarkOccurencesPreferenceListener);
        this.fUndoListener = new IOperationHistoryListener(){
            private final String FORMATTING_EVENT_LABEL = "Formatting in progress";

            public void historyNotification(OperationHistoryEvent event) {
                IUndoableOperation operation = event.getOperation();
                if (operation == null) {
                    return;
                }
                int eventType = event.getEventType();
                if (DVTEditor.this.fFormattingOperationInProgress) {
                    if (eventType == 5) {
                        operation.addContext((IUndoContext)new ObjectUndoContext((Object)new CursorOffsetBeforeFormatting(), "Formatting in progress"));
                    }
                    return;
                }
                if (eventType == 10 || eventType == 9) {
                    IUndoContext[] contexts = operation.getContexts();
                    if (contexts == null) {
                        return;
                    }
                    int i = 0;
                    while (i < contexts.length) {
                        Object contextObject;
                        String label;
                        IUndoContext context = contexts[i];
                        if (context instanceof ObjectUndoContext && (label = ((ObjectUndoContext)context).getLabel()) != null && "Formatting in progress".equals(label) && (contextObject = ((ObjectUndoContext)context).getObject()) instanceof CursorOffsetBeforeFormatting) {
                            int cursorOffsetBeforeFormatting = ((CursorOffsetBeforeFormatting)contextObject).getCursorOffsetBeforeFormatting();
                            if (cursorOffsetBeforeFormatting == -1) {
                                return;
                            }
                            DVTEditor.this.selectAndReveal(cursorOffsetBeforeFormatting, 0);
                        }
                        ++i;
                    }
                }
            }
        };
        OperationHistoryFactory.getOperationHistory().addOperationHistoryListener(this.fUndoListener);
    }

    public void disposeListeners() {
        IDocument document;
        IPreferenceStore pluginSpecificPreferenceStore = this.getPluginSpecificPreferenceStore();
        if (pluginSpecificPreferenceStore != null && this.fPropertyChangeListener != null) {
            pluginSpecificPreferenceStore.removePropertyChangeListener(this.fPropertyChangeListener);
        }
        if ((document = this.getDocument()) != null) {
            document.removeDocumentListener((IDocumentListener)this.fRebuildListener);
            document.removeDocumentListener((IDocumentListener)this.fContentAssistListener);
            if (document instanceof IDocumentExtension4) {
                ((IDocumentExtension4)document).removeDocumentRewriteSessionListener(this.fRewriteSessionListener);
            }
        }
        if (this.fSourceViewer != null) {
            this.fSourceViewer.removeViewportListener(this.fScrollingViewportListener);
        }
        if (this.fPartListener != null) {
            this.getSite().getPage().removePartListener(this.fPartListener);
        }
        if (this.fPrefStore != null) {
            this.fPrefStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
            this.fPrefStore.removePropertyChangeListener((IPropertyChangeListener)this.fMarkOccurencesPreferenceListener);
        }
        DVTPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.fMarkOccurencesPreferenceListener);
        this.fElaborationBreadcrumbHighlightListener = null;
        if (this.fDHBreadcrumbViewer != null) {
            this.fDHBreadcrumbViewer.dispose();
        }
        if (this.fVHBreadcrumbViewer != null) {
            this.fVHBreadcrumbViewer.dispose();
        }
        if (this.fScopeBreadcrumbViewer != null) {
            this.fScopeBreadcrumbViewer.dispose();
        }
        if (this.fFilesystemBreadcrumbViewer != null) {
            this.fFilesystemBreadcrumbViewer.dispose();
        }
        if (this.fJobChangeListener != null) {
            Job.getJobManager().removeJobChangeListener(this.fJobChangeListener);
        }
        if (this.fUndoListener != null) {
            OperationHistoryFactory.getOperationHistory().removeOperationHistoryListener(this.fUndoListener);
        }
        this.fDHBreadcrumbViewer = null;
        this.fVHBreadcrumbViewer = null;
        this.fScopeBreadcrumbViewer = null;
        this.fFilesystemBreadcrumbViewer = null;
        this.fPropertyChangeListener = null;
        this.fRebuildListener = null;
        this.fContentAssistListener = null;
        this.fScrollingViewportListener = null;
        this.fPartListener = null;
        this.fPreferenceListener = null;
        this.fMarkOccurencesPreferenceListener = null;
        this.fUndoListener = null;
    }

    protected boolean isNoIncrementalTrigger() {
        return false;
    }

    protected abstract IPreferenceStore getPluginSpecificPreferenceStore();

    public abstract void showContentAssistProposalsForCreatedFile();

    protected abstract void scheduleReparse(IDocument var1, IFile var2);

    public abstract void configureProjectionSupport(ProjectionSupport var1);

    public abstract void configureSourceViewerConfiguration(ProjectionAnnotationModel var1);

    public void showAutoInstanceProposals() {
    }

    public void showAIAssistantProposals() {
    }

    public ProjectionSupport getProjectionSupport() {
        return this.fProjectionSupport;
    }

    public ProjectionAnnotationModel getProjectionAnnotationModel() {
        return this.fAnnotationModel;
    }

    public DVTPresentationReconciler getFoldingManager() {
        return this.fFoldingManager;
    }

    public Object getAdapter(Class adapter) {
        Object candidate;
        if (adapter == IShowInSource.class) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    return new LazyShowInContext(DVTEditor.this.getEditorInput(), DVTEditor.this.getSelectionProvider());
                }
            };
        }
        if (adapter == IResource.class) {
            return this.getEditorInput().getAdapter(IResource.class);
        }
        if (this.fProjectionSupport != null && (candidate = this.fProjectionSupport.getAdapter((ISourceViewer)this.fSourceViewer, adapter)) != null) {
            return candidate;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IDocument getDocument() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return null;
        }
        IDocument document = provider.getDocument((Object)editorInput);
        return document;
    }

    @Override
    public int getCursor() {
        if (this.fSourceViewer == null) {
            return -1;
        }
        StyledText styledText = this.fSourceViewer.getTextWidget();
        if (styledText == null) {
            return -1;
        }
        return DVTEditor.widgetOffset2ModelOffset((ISourceViewer)this.fSourceViewer, (int)styledText.getCaretOffset());
    }

    public void setCursor(int offset) {
        this.setCursor(offset, false);
    }

    public void setCursor(int offset, boolean handleCursorPositionChanged) {
        StyledText styledText = this.fSourceViewer.getTextWidget();
        styledText.setCaretOffset(DVTEditor.modelOffset2WidgetOffset((ISourceViewer)this.fSourceViewer, (int)offset));
        if (handleCursorPositionChanged) {
            this.handleCursorPositionChanged();
        }
    }

    public abstract IRfScopeElement getCursorScope();

    public abstract IRfBreadcrumbElement getCursorScopeForBreadcrumb(boolean var1);

    public void goToLine(int line) {
        line = Math.max(0, line - 1);
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)this.getEditorInput());
        if (document == null) {
            return;
        }
        try {
            this.selectAndReveal(document.getLineOffset(line), document.getLineLength(line));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void handleCursorPositionChanged() {
        Position range;
        IDocument document;
        super.handleCursorPositionChanged();
        try {
            if (this.fCurrentFile != null) {
                this.updateDesignBreadcrumb();
                Object vhBcQn = this.fCurrentFile.getSessionProperty(IDVTConstants.VH_BREADCRUMB_QN);
                if (vhBcQn != null) {
                    this.updateBreadcrumb(VHBreadcrumbViewer.class, null);
                }
                this.updateScopeBreadcrumb(false);
            }
        }
        catch (Throwable e1) {
            DVTLogger.INSTANCE.logError(e1);
        }
        if ((document = this.getDocumentProvider().getDocument((Object)this.getEditorInput())) == null) {
            return;
        }
        this.fCursorOffset = this.getCursor();
        if (this.fMarkOccurrenceAnnotations) {
            this.updateOccurrenceAnnotations(document, this.fCursorOffset, false);
        }
        if ((range = this.getRangeIndicationPosition(this.fCursorOffset)) == null) {
            this.getSourceViewer().removeRangeIndication();
        } else if (range.getOffset() == 0 && range.getLength() == 0) {
            this.getSourceViewer().removeRangeIndication();
        } else {
            this.getSourceViewer().setRangeIndication(range.getOffset(), range.getLength(), false);
        }
        this.triggerInspectViewSelectorJob(document, this.fCursorOffset);
        IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
        if (aiHostContributor != null) {
            hotspotUpdateExecutor.execute(() -> aiHostContributor.addEditorHotspot(this.fCurrentFile, this.fCursorOffset));
        }
        ObjectionManager.getInstance().clear(Objection.CURSOR_POSITION_CHANGED);
    }

    private void updateDesignBreadcrumb() {
        boolean wasRegistered = DesignPathManager.getInstance().isRegistered(this);
        if (!wasRegistered) {
            DesignPathManager.getInstance().registerEditor(this);
        }
        if (DesignPathManager.getInstance().isMetadataDifferent(this)) {
            DesignPathManager.getInstance().setDirty(this, true);
        }
        if (!DesignPathManager.getInstance().isRegistered(this)) {
            return;
        }
        if (this.fDHBreadcrumbViewer == null) {
            this.createBreadcrumb(DHBreadcrumbViewer.class, null);
        }
        DPMListenerManager.INSTANCE.notifyListener(this.fDHBreadcrumbViewer, wasRegistered ? null : DPMNotification.DPMNotificationKind.FORCE_UPDATE);
    }

    public void updateScopeBreadcrumb(boolean overrideCache) {
        try {
            AbstractBreadcrumbUtils breadcrumbUtils = this.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
            if (!(breadcrumbUtils instanceof ScopeBreadcrumbUtils)) {
                return;
            }
            IRfBreadcrumbElement scope = ((ScopeBreadcrumbUtils)breadcrumbUtils).getScopeForBreadcrumb((ITextEditor)this, this.getCursor(), overrideCache);
            ScopeBreadcrumbConfiguration bcConfig = new ScopeBreadcrumbConfiguration(scope, this.getCursor(), (IFile)this.getAdapter(IResource.class), overrideCache);
            this.updateBreadcrumb(ScopeBreadcrumbViewer.class, bcConfig);
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
    }

    protected void updateOccurrenceAnnotations(IDocument document, int cursor, boolean forceUpdate) {
        Map<Annotation, Position> annotationMap;
        IDocumentProvider documentProvider;
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.doCancel();
        }
        if ((documentProvider = this.getDocumentProvider()) == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null) {
            return;
        }
        IRegion markOccurrenceTargetRegion = null;
        Point selectionRegion = this.fSourceViewer.getTextWidget().getSelectionRange();
        if (!this.fPrevOccurrencesWrapper.isEmptySelection() && this.fPrevOccurrencesWrapper.getNofOccurrences() <= 1 && this.selectionExpansion(selectionRegion)) {
            this.fPrevOccurrencesWrapper.setSelectionRange(selectionRegion);
            if (!this.fStickyOccurrenceAnnotations) {
                this.removeOccurrenceAnnotations();
            }
            return;
        }
        IRegion region1 = this.fWordFinder.getWordAtOffset(document, cursor);
        if (selectionRegion.y > 0) {
            IRegion region2 = this.fWordFinder.getWordAtOffset(document, Math.max(0, cursor - 1));
            if (region1.getOffset() == selectionRegion.x && region1.getLength() == selectionRegion.y) {
                markOccurrenceTargetRegion = region1;
            } else if (region2.getOffset() == selectionRegion.x && region2.getLength() == selectionRegion.y) {
                markOccurrenceTargetRegion = region2;
            } else if (this.fMatchPartialWords) {
                markOccurrenceTargetRegion = new Region(selectionRegion.x, selectionRegion.y);
            }
        } else {
            markOccurrenceTargetRegion = region1;
        }
        if (markOccurrenceTargetRegion == null || markOccurrenceTargetRegion.getLength() == 0) {
            this.fPrevOccurrencesWrapper.reset();
            if (!this.fStickyOccurrenceAnnotations) {
                this.removeOccurrenceAnnotations();
            }
            return;
        }
        if (this.fMarkOccurrenceTargetRegion != null && this.fMarkOccurrenceTargetRegion.equals(markOccurrenceTargetRegion) && !forceUpdate) {
            return;
        }
        this.fMarkOccurrenceTargetRegion = markOccurrenceTargetRegion;
        try {
            String sequence = document.get(markOccurrenceTargetRegion.getOffset(), markOccurrenceTargetRegion.getLength());
            annotationMap = this.fWordFinder.getSequenceOccurrences(document, sequence, this.isMarkOccurrencesCaseInsensitive(), this.fMatchPartialWords);
            this.fPrevOccurrencesWrapper.setNofOccurrences(annotationMap == null ? 0 : annotationMap.size());
            this.fPrevOccurrencesWrapper.setSelectionRange(selectionRegion);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        if (annotationMap == null || annotationMap.size() == 0) {
            if (!this.fStickyOccurrenceAnnotations) {
                this.removeOccurrenceAnnotations();
            }
            return;
        }
        this.fOccurrencesFinderJob = new OccurrencesFinderJob(document, annotationMap);
        this.fOccurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    private boolean selectionExpansion(Point point) {
        return this.selectionLeftExpansion(point) || this.selectionRightExpansion(point);
    }

    private boolean selectionLeftExpansion(Point point) {
        return point.x + point.y == this.fPrevOccurrencesWrapper.getSelectionRange().x + this.fPrevOccurrencesWrapper.getSelectionRange().y && point.x <= this.fPrevOccurrencesWrapper.getSelectionRange().x;
    }

    private boolean selectionRightExpansion(Point point) {
        return point.x == this.fPrevOccurrencesWrapper.getSelectionRange().x && point.y >= this.fPrevOccurrencesWrapper.getSelectionRange().y;
    }

    private boolean isMarkOccurrencesCaseInsensitive() {
        return "ro.amiq.vhdldt.ui.editor.VhdlEditor".equals(this.getEditorID());
    }

    private Position getRangeIndicationPosition(int caretPosition) {
        if (this.fAnnotationModel != null) {
            Iterator e = this.fAnnotationModel.getAnnotationIterator();
            DVTPosition prevPosition = new DVTPosition(0, 0);
            while (e.hasNext()) {
                Object annotation = e.next();
                if (!(annotation instanceof ProjectionAnnotation)) continue;
                Position position = this.fAnnotationModel.getPosition((Annotation)((ProjectionAnnotation)annotation));
                if (prevPosition.getOffset() >= position.getOffset() || position.getOffset() > caretPosition || position.getOffset() + position.getLength() <= caretPosition) continue;
                prevPosition = position;
            }
            return prevPosition;
        }
        return null;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher(this.getBracketMatcher());
        super.configureSourceViewerDecorationSupport(support);
    }

    public void enableOccurrenceAnnotations(boolean enable) {
        if (enable) {
            this.fMarkOccurrenceAnnotations = true;
            IDocumentProvider documentProvider = this.getDocumentProvider();
            if (documentProvider == null) {
                return;
            }
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput == null) {
                return;
            }
            IDocument document = documentProvider.getDocument((Object)editorInput);
            if (document == null) {
                return;
            }
            this.updateOccurrenceAnnotations(document, this.fCursorOffset, false);
        } else {
            this.fMarkOccurrenceAnnotations = false;
            this.fMarkOccurrenceTargetRegion = null;
            this.removeOccurrenceAnnotations();
        }
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        if (event == null) {
            return;
        }
        Object[] elements = event.getElements();
        if (elements == null) {
            this.firePropertyChange(1);
            return;
        }
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof DVTEditor) {
                if (element.equals(this)) {
                    this.firePropertyChange(1);
                    return;
                }
            } else if (element instanceof IFile) {
                if (this.getEditorInput() == null) {
                    return;
                }
                IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
                if (element.equals(file)) {
                    this.firePropertyChange(1);
                    return;
                }
            }
            ++i;
        }
    }

    public void notifyListeners(int eventType, Event event) {
        this.fSourceViewer.getTextWidget().notifyListeners(eventType, event);
    }

    private void installOccurrencesFinder(boolean forceUpdate) {
        if (this.fOccurrencesFinderJobCanceler == null) {
            this.fOccurrencesFinderJobCanceler = new OccurrencesFinderJobCanceler();
            this.fOccurrencesFinderJobCanceler.install();
        }
    }

    private void uninstallOccurrencesFinder() {
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
            this.fOccurrencesFinderJob = null;
        }
        if (this.fOccurrencesFinderJobCanceler != null) {
            this.fOccurrencesFinderJobCanceler.uninstall();
            this.fOccurrencesFinderJobCanceler = null;
        }
        this.removeOccurrenceAnnotations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOccurrenceAnnotations() {
        this.fMarkOccurrenceModificationStamp = -1L;
        this.fMarkOccurrenceTargetRegion = null;
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOccurrenceAnnotations.length;
                while (i < length) {
                    annotationModel.removeAnnotation(this.fOccurrenceAnnotations[i]);
                    ++i;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    protected boolean isActivePart() {
        IWorkbenchPart part = this.getActivePart();
        return part != null && part.equals(this);
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part;
    }

    public abstract DVTWordFinder getWordFinder();

    @Override
    public void updateBackgroundHighlightPositions(String positionCategory) {
        IDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        if (this.fLineBackgroundPainter == null) {
            return;
        }
        try {
            Position[] positions = !document.containsPositionCategory(positionCategory) ? new Position[]{} : document.getPositions(positionCategory);
            LineBackgroundPainter.LineBackgroundKind positionKind = null;
            switch (positionCategory) {
                case "__dvt_inactive_code_position": {
                    positionKind = LineBackgroundPainter.LineBackgroundKind.INACTIVE;
                    break;
                }
                case "__dvt_protected_code_position": {
                    positionKind = LineBackgroundPainter.LineBackgroundKind.PROTECTED;
                    break;
                }
                case "CUSTOM_PRAGMA": {
                    positionKind = LineBackgroundPainter.LineBackgroundKind.CUSTOM;
                    break;
                }
                case "__dvt_inactive_generate_branch_position": {
                    positionKind = LineBackgroundPainter.LineBackgroundKind.INACTIVE_GENERATE_BRANCH;
                    break;
                }
                case "__dvt_pverilog_preproc_code_position": {
                    positionKind = LineBackgroundPainter.LineBackgroundKind.PVLOG_PREPROC;
                    break;
                }
                case "__dvt_pverilog_generated_code_position": {
                    positionKind = LineBackgroundPainter.LineBackgroundKind.PVLOG_GENERATED;
                    break;
                }
            }
            ArrayList<Position> positionList = new ArrayList<Position>(Arrays.asList(positions));
            this.fLineBackgroundPainter.setHighlightPositions(positionList, positionKind);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void setPrefStore(IPreferenceStore prefStore) {
        this.fPrefStore = prefStore;
    }

    public IAnnotationModel getAnnotationModel() {
        if (this.fSourceViewer == null) {
            return null;
        }
        return this.fSourceViewer.getAnnotationModel();
    }

    protected void validateState(final IEditorInput input) {
        IResource resource = (IResource)input.getAdapter(IResource.class);
        if (resource == null) {
            super.validateState(input);
            return;
        }
        DVTFileUtils.getInstance().fixFileModificationValidatorPermissions(new IResource[]{resource}, new Callable<IStatus>(){

            @Override
            public IStatus call() {
                DVTEditor.super.validateState(input);
                return Status.OK_STATUS;
            }
        }, true, null);
        final File ioFile = resource.getLocation().toFile();
        if (!ioFile.canWrite() && !this.hasShownReadOnly) {
            this.hasShownReadOnly = true;
            MessageDialog dialog = new MessageDialog(this.getSite().getShell(), "Read-only file", null, "The file you are trying to edit is read-only:", 2, new String[]{IDialogConstants.OK_LABEL}, 0){

                protected Control createCustomArea(Composite parent) {
                    Text t = new Text(parent, 0);
                    GridDataFactory.fillDefaults().align(4, 1).grab(true, false);
                    DVTColorUtil.INSTANCE.setBackground((Control)t, DVTColorUtil.INSTANCE.getBackground((Control)parent), true);
                    t.setEditable(false);
                    t.setText(ioFile.getAbsolutePath());
                    return t;
                }
            };
            dialog.open();
        }
    }

    public ITextViewer getTextViewer() {
        return this.fSourceViewer;
    }

    public int getTabWidth() {
        DVTAutoIndentDetector.DetectedIndentation detectedIndentation = DVTAutoIndentDetectionManager.INSTANCE.getDetectedIndentationForDocument(this.getDocument());
        if (detectedIndentation != null) {
            return detectedIndentation.getTabWidth();
        }
        return this.getSourceViewerConfiguration().getTabWidth((ISourceViewer)this.fSourceViewer);
    }

    @Override
    public boolean isInsertSpaces(IPreferenceStore store) {
        DVTAutoIndentDetector.DetectedIndentation detectedIndentation = DVTAutoIndentDetectionManager.INSTANCE.getDetectedIndentationForDocument(this.getDocument());
        if (detectedIndentation != null) {
            return detectedIndentation.getInsertSpaces();
        }
        return TextUtils.getEditorSpacesForTabs(store);
    }

    @Override
    public Canvas getFNotificationHostCanvas() {
        return this.getStyledText();
    }

    public StyledText getStyledText() {
        if (this.fSourceViewer == null) {
            return null;
        }
        return this.fSourceViewer.getTextWidget();
    }

    public IContentAssistant testGetContentAssistant() {
        return this.getSourceViewerConfiguration().getContentAssistant((ISourceViewer)this.fSourceViewer);
    }

    public IQuickAssistAssistant testGetQuickAssistAssistant() {
        return this.getSourceViewerConfiguration().getQuickAssistAssistant((ISourceViewer)this.fSourceViewer);
    }

    public ISourceViewer testGetSourceViewer() {
        return this.fSourceViewer;
    }

    public IHyperlinkDetector testGetRfHyperlinkDetector() {
        IHyperlinkDetector[] detectors = this.getSourceViewerConfiguration().getHyperlinkDetectors((ISourceViewer)this.fSourceViewer);
        int i = 0;
        while (i < detectors.length) {
            if (detectors[i] instanceof IHyperlinkDetector) {
                return detectors[i];
            }
            ++i;
        }
        return null;
    }

    public IHyperlinkDetector[] testGetAllHyperlinkDetectors() {
        return this.getSourceViewerConfiguration().getHyperlinkDetectors((ISourceViewer)this.fSourceViewer);
    }

    public int testGetCurrentLine() {
        StyledText styledText = this.fSourceViewer.getTextWidget();
        return styledText.getLineAtOffset(styledText.getCaretOffset());
    }

    public int testGetCurrentColumn() {
        StyledText styledText = this.fSourceViewer.getTextWidget();
        int line = styledText.getLineAtOffset(styledText.getCaretOffset());
        int offsetAtLine = styledText.getOffsetAtLine(line);
        return styledText.getCaretOffset() - offsetAtLine;
    }

    public ITextHover testGetTextHover(String contentType) {
        return this.getSourceViewerConfiguration().getTextHover((ISourceViewer)this.fSourceViewer, contentType);
    }

    public String getTitleToolTip() {
        String tooltip = super.getTitleToolTip();
        IFile file = (IFile)this.getAdapter(IResource.class);
        if (file == null) {
            return tooltip;
        }
        if (tooltip.contains("DVT Auto-Linked")) {
            tooltip = DVTFileUtils.getInstance().resolveAutoLinkPath((IResource)file).toOSString();
        } else {
            if (file.getLocation() == null) {
                return tooltip;
            }
            tooltip = file.getLocation().toOSString();
        }
        return tooltip;
    }

    public abstract TextEditorAction testGetReferencesInWorkspaceAction();

    public abstract TextEditorAction testGetReferencesInFileAction();

    public abstract IBaseShowConstraintsAction testGetShowConstraintsAction();

    public abstract IBaseShowEmittersAction testGetShowEmittersAction();

    public IReferencesAction testGetShowReadersUsagesAction() {
        return null;
    }

    public IReferencesAction testGetShowWritersUsagesAction() {
        return null;
    }

    public abstract IBaseShowInstancesAction testGetShowInstancesAction();

    public abstract DVTSourceViewerConfiguration testGetSourceViewerConfiguration();

    public abstract IRfNamedElementAndScope testGetNamedElementAndScopeAtPosition(int var1, int var2);

    public IRfNamedElement testGetNamedElementAtPosition(int line, int column) {
        IRfNamedElementAndScope testGetNamedElementAndScopeAtPosition = this.testGetNamedElementAndScopeAtPosition(line, column);
        return testGetNamedElementAndScopeAtPosition == null ? null : testGetNamedElementAndScopeAtPosition.getIRfNamedElement();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.fDHBCCache = null;
        this.fVHBCCache = null;
        DVTLazyOutlinePage outlinePage = this.getOutlinePage();
        if (outlinePage != null) {
            outlinePage.update(true);
        }
        if (this.fSourceViewer != null) {
            this.fAnnotationModel = this.fSourceViewer.getProjectionAnnotationModel();
            this.configureSourceViewerConfiguration(this.fAnnotationModel);
        }
        try {
            if (!this.shouldUpdateMarkersOnOpen()) {
                return;
            }
            if (input == null) {
                return;
            }
            this.fCurrentFile = (IFile)input.getAdapter(IResource.class);
            if (this.fCurrentFile == null) {
                return;
            }
            if (this.fFilesystemBreadcrumbViewer != null) {
                this.updateBreadcrumb(FSBreadcrumbViewer.class, new FSBreadcrumbConfiguration(null));
            }
            for (DVTProblemsUiUpdater updater : DVTProblemsUiUpdaterRegistry.getAll()) {
                updater.update(this.fCurrentFile, false);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public abstract DVTLazyOutlinePage getOutlinePage();

    public boolean shouldUpdateMarkersOnOpen() {
        return true;
    }

    protected void createActions() {
        super.createActions();
        Object action = new SelectAndFindNextAction(this, DVTEditorMessages.getResourceBundle(), "SelectAndFindNext.", (IWorkbenchPart)this, true);
        action.setActionDefinitionId(SELECT_AND_FIND_NEXT_ACTION_ID);
        this.setAction(SELECT_AND_FIND_NEXT, (IAction)action);
        this.markAsContentDependentAction(SELECT_AND_FIND_NEXT, true);
        action = new SelectAndFindNextAction(this, DVTEditorMessages.getResourceBundle(), "SelectAndFindPrevious.", (IWorkbenchPart)this, false);
        action.setActionDefinitionId(SELECT_AND_FIND_PREVIOUS_ACTION_ID);
        this.setAction(SELECT_AND_FIND_PREVIOUS, (IAction)action);
        this.markAsContentDependentAction(SELECT_AND_FIND_PREVIOUS, true);
        IVerticalRulerInfo rulerInfo = (IVerticalRulerInfo)this.getAdapter(IVerticalRulerInfo.class);
        if (rulerInfo != null) {
            action = new SelectAnnotationRulerAction(DVTEditorMessages.getResourceBundle(), "SelectAnnotationRulerAction.", (ITextEditor)this, rulerInfo);
            action.setActionDefinitionId(SELECT_ANNOTATION_RULER_ACTION_ID);
            this.setAction(SELECT_ANNOTATION_RULER_ACTION, (IAction)action);
            this.markAsContentDependentAction(SELECT_ANNOTATION_RULER_ACTION, true);
        }
        action = new DVTTextOperationAction(DVTEditorMessages.getResourceBundle(), "Editor.QuickAssist.", (ITextEditor)this, 22);
        action.setText("Quick Fix");
        action.setHelpContextId("org.eclipse.ui.quick_assist_action_context");
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        this.setAction("QuickAssist", (IAction)action);
        this.markAsStateDependentAction("QuickAssist", true);
        action = new DVTTextOperationAction(DVTEditorMessages.getResourceBundle(), "Editor.ContentAssistContextInformation.", (ITextEditor)this, 14);
        action.setHelpContextId("org.eclipse.ui.content_assist_context_information_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistContextInformation", (IAction)action);
        this.markAsStateDependentAction("ContentAssistContextInformation", true);
        action = new JumpAroundBracketAction(this, DVTEditorMessages.getResourceBundle(), "JumpAfterRightBracket.", true);
        action.setActionDefinitionId(JUMP_AFTER_RIGHT_BRACKET_ID);
        this.setAction(JUMP_AFTER_RIGHT_BRACKET, (IAction)action);
        this.markAsContentDependentAction(JUMP_AFTER_RIGHT_BRACKET, true);
        action = new JumpAroundBracketAction(this, DVTEditorMessages.getResourceBundle(), "JumpBeforeLeftBracket.", false);
        action.setActionDefinitionId(JUMP_BEFORE_LEFT_BRACKET_ID);
        this.setAction(JUMP_BEFORE_LEFT_BRACKET, (IAction)action);
        this.markAsContentDependentAction(JUMP_BEFORE_LEFT_BRACKET, true);
        if (!new Boolean(System.getenv(DVT_HIPPIE_COMPLETION_PROPOSAL_DISABLE_ENVVAR)).booleanValue()) {
            action = new DVTHippieCompleteAction(DVTEditorMessages.getResourceBundle(), "Editor.HippieCompletion.", this);
            action.setHelpContextId("org.eclipse.ui.hippie_completion_action_context");
            action.setActionDefinitionId("org.eclipse.ui.edit.text.hippieCompletion");
            action.setText("Word Completion");
            this.setAction("HIPPIE_COMPLETION", (IAction)action);
        }
        this.installSubmenuActions();
    }

    public void setFocus() {
        super.setFocus();
        this.fSelectionCleared = false;
        this.fLastFocusedTimestamp = System.currentTimeMillis();
        this.registerToPathManager();
        Display.getCurrent().asyncExec(() -> {
            this.updateBreadcrumb(VHBreadcrumbViewer.class, null);
            if (this.fDHBreadcrumbViewer != null) {
                this.fDHBreadcrumbViewer.changeReadOnlyState();
            }
            if (this.fFilesystemBreadcrumbViewer == null) {
                this.updateBreadcrumb(FSBreadcrumbViewer.class, new FSBreadcrumbConfiguration(null));
            } else {
                this.fFilesystemBreadcrumbViewer.refresh();
            }
            this.updateScopeBreadcrumb(true);
        });
        Object page = this.getAdapter(IContentOutlinePage.class);
        if (page instanceof DVTLazyOutlinePage && ((DVTLazyOutlinePage)page).isDirty()) {
            ((DVTLazyOutlinePage)page).update(true);
            ((DVTLazyOutlinePage)page).setDirty(false);
        }
        this.handleFloatingNotifications();
    }

    public void registerToPathManager() {
        if (!DesignPathManager.getInstance().isEligible(this)) {
            return;
        }
        DesignPathManager.getInstance().registerEditor(this);
        if (DesignPathManager.getInstance().isMetadataDifferent(this)) {
            DesignPathManager.getInstance().setDirty(this, true);
        }
        if (this.fDHBreadcrumbViewer == null) {
            this.createBreadcrumb(DHBreadcrumbViewer.class, null);
        } else {
            DPMListenerManager.INSTANCE.register(this, this.fDHBreadcrumbViewer);
        }
        DPMListenerManager.INSTANCE.register(this, this.fElaborationBreadcrumbHighlightListener);
        DPMListenerManager.INSTANCE.notifyListeners(this, DPMNotification.DPMNotificationKind.SHOW_BC_NOTIFICATIONS);
    }

    public ElaborationHighlightListener getElaborationHighlightListener() {
        return this.fElaborationBreadcrumbHighlightListener;
    }

    @Override
    public void createBreadcrumb(Class<?> breadcrumbType, AbstractBreadcrumbConfiguration configuration) {
        try {
            if (this.fTopContainer == null || this.fTopContainer.isDisposed()) {
                return;
            }
            if (breadcrumbType == DHBreadcrumbViewer.class) {
                if (this.fDHBreadcrumbViewer != null) {
                    this.fDHBreadcrumbViewer.dispose();
                }
                this.fDHBreadcrumbViewer = new DHBreadcrumbViewer(this, this.fTopContainer);
                DPMListenerManager.INSTANCE.register(this, this.fDHBreadcrumbViewer);
            } else if (breadcrumbType == VHBreadcrumbViewer.class) {
                if (this.fVHBreadcrumbViewer != null) {
                    this.fVHBreadcrumbViewer.dispose();
                }
                this.fVHBreadcrumbViewer = new VHBreadcrumbViewer(this, this.fTopContainer);
            } else if (breadcrumbType == ScopeBreadcrumbViewer.class) {
                if (this.fScopeBreadcrumbViewer != null) {
                    this.fScopeBreadcrumbViewer.dispose();
                }
                this.fScopeBreadcrumbViewer = new ScopeBreadcrumbViewer(this, this.fTopContainer);
            } else if (breadcrumbType == FSBreadcrumbViewer.class) {
                if (this.fFilesystemBreadcrumbViewer != null) {
                    this.fFilesystemBreadcrumbViewer.dispose();
                }
                this.fFilesystemBreadcrumbViewer = new FSBreadcrumbViewer(this, this.fTopContainer);
            }
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public void installSelectionListener(StyledText text) {
        text.addSelectionListener(this.fSelectionListenerForEnlosingScope);
        text.addSelectionListener((SelectionListener)this.fSelectAndNotRevealListener);
    }

    public void removeSelectionListener(StyledText text) {
        text.removeSelectionListener(this.fSelectionListenerForEnlosingScope);
        text.removeSelectionListener((SelectionListener)this.fSelectAndNotRevealListener);
        this.fSelectionListenerForEnlosingScope = null;
        this.fSelectAndNotRevealListener = null;
    }

    @Override
    public void selectAndNotReveal(int selectionStart, int selectionLength) {
        ITextSelection textSelection;
        if (this.fSourceViewer == null) {
            return;
        }
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection && ((textSelection = (ITextSelection)selection).getOffset() != 0 || textSelection.getLength() != 0)) {
            this.markInNavigationHistory();
        }
        StyledText widget = this.fSourceViewer.getTextWidget();
        widget.setRedraw(false);
        this.fSourceViewer.setSelectedRange(selectionStart, selectionLength);
        this.markInNavigationHistory();
        widget.setRedraw(true);
    }

    protected void restoreSelection() {
        try {
            StyledText textWidget = this.fSourceViewer.getTextWidget();
            Field field = StyledText.class.getDeclaredField("clickCount");
            field.setAccessible(true);
            int clickCount = field.getInt(textWidget);
            if (clickCount == 1) {
                field.set(textWidget, 0);
            }
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
        super.restoreSelection();
    }

    protected void configureToggleCommentAction() {
        IAction action = this.getAction("ToggleComment");
        if (action instanceof IToggleCommentAction) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
            ((IToggleCommentAction)action).configure(sourceViewer, configuration);
        }
    }

    public static void addOverrideIndications(Map<Annotation, Position> aditions, DVTEditor editor) {
        DVTEditor.updateAnnotations(DVTEditorCommon.OverrideIndicator.class, aditions, editor);
    }

    public static void updateAnnotations(final Class<? extends Annotation> annotationClass, final Map<? extends Annotation, Position> aditions, final DVTEditor editor) {
        UIJob job = new UIJob(PlatformUI.getWorkbench().getDisplay(), "Update Override Annotations"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    IAnnotationModel annotationModel = editor.getAnnotationModel();
                    if (annotationModel == null) {
                        ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                        return Status.OK_STATUS;
                    }
                    Iterator iterator = annotationModel.getAnnotationIterator();
                    ArrayList<Annotation> deletions = new ArrayList<Annotation>();
                    while (iterator.hasNext()) {
                        Object annotation = iterator.next();
                        if (!annotationClass.isInstance(annotation)) continue;
                        if (annotationModel instanceof IAnnotationModelExtension) {
                            deletions.add((Annotation)annotation);
                            continue;
                        }
                        iterator.remove();
                    }
                    if (annotationModel instanceof IAnnotationModelExtension) {
                        ((IAnnotationModelExtension)annotationModel).replaceAnnotations(deletions.toArray(new Annotation[deletions.size()]), aditions);
                    } else {
                        for (Map.Entry entry : aditions.entrySet()) {
                            annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
                        }
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule(100L);
    }

    protected static void replaceFoldingAnnotations(final ProjectionAnnotationModel model, final Collection<Annotation> annotationsToRemove, final Map<ProjectionAnnotation, Position> aditions) {
        UIJob job = new UIJob(PlatformUI.getWorkbench().getDisplay(), "Create Semantic Folding"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    model.replaceAnnotations(annotationsToRemove.toArray(new Annotation[annotationsToRemove.size()]), aditions);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule(250L);
    }

    public final boolean isAutoInsertSingleProposals() {
        return DVTPlugin.getDefault().getPreferenceStore().getBoolean("ca.auto_insert_single");
    }

    public int getCursorLineNumber() {
        AtomicInteger result = new AtomicInteger(Integer.MAX_VALUE);
        Runnable r = () -> {
            try {
                IDocument document = this.getDocument();
                if (document == null) {
                    return;
                }
                result.set(document.getLineOfOffset(this.getCursor()) + 1);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        };
        if (Display.getCurrent() != null) {
            r.run();
        } else {
            DVTUiUtils.getActiveWorkbenchShell().getDisplay().syncExec(r);
        }
        return result.get();
    }

    public int getCursorColNumber() {
        AtomicInteger result = new AtomicInteger(Integer.MAX_VALUE);
        Runnable r = () -> {
            try {
                IDocument document = this.getDocument();
                if (document == null) {
                    return;
                }
                int cursor = this.getCursor();
                int lineOfOffset = document.getLineOfOffset(cursor);
                result.set(cursor - document.getLineOffset(lineOfOffset));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        };
        if (Display.getCurrent() != null) {
            r.run();
        } else {
            DVTUiUtils.getActiveWorkbenchShell().getDisplay().syncExec(r);
        }
        return result.get();
    }

    protected void handleEditorInputChanged() {
        DVTFileUtils.createHistoryEntryFromString((IFile)this.getAdapter(IResource.class), this.getDocument().get());
        super.handleEditorInputChanged();
    }

    @Override
    public Composite getNotificationsHostComposite() {
        return this.fNotificationsHostComposite;
    }

    @Override
    public AbstractBreadcrumbViewer getBreadcrumbViewer(Class<?> breadcrumbType) {
        if (breadcrumbType == DHBreadcrumbViewer.class) {
            return this.fDHBreadcrumbViewer;
        }
        if (breadcrumbType == VHBreadcrumbViewer.class) {
            return this.fVHBreadcrumbViewer;
        }
        if (breadcrumbType == ScopeBreadcrumbViewer.class) {
            return this.fScopeBreadcrumbViewer;
        }
        if (breadcrumbType == FSBreadcrumbViewer.class) {
            return this.fFilesystemBreadcrumbViewer;
        }
        return null;
    }

    public int getScopeBCLineCache() {
        return this.fScopeBCLineCache;
    }

    public void setScopeBCLineCache(int line) {
        this.fScopeBCLineCache = line;
    }

    public abstract DVTSourceViewerConfiguration makeSourceViewerConfiguration();

    public abstract boolean isHoverDisabled();

    public abstract String getEditorID();

    public void startHighlightJob(DVTSemanticHighlighter<IRfBaseElement> semanticHighlighter, IRfFileDef file, boolean isSemanticHighlightEnabled) {
        if (this.fHighlightJob != null) {
            this.fHighlightJob.cancel();
            this.fHighlightJob = null;
        }
        this.fHighlightJob = new SemanticHighlightJob(semanticHighlighter, file, this, isSemanticHighlightEnabled);
        this.fHighlightJob.setPriority(50);
        this.fHighlightJob.setRule(DVTHlUtils.JOB_SCHED_RULE);
        this.fHighlightJob.setSystem(true);
        this.fHighlightJob.schedule();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        boolean cancelIncremental = PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE");
        if (cancelIncremental) {
            ChangedFilesManager.cancelBuildJob();
        }
        IResource resource = (IResource)this.getAdapter(IResource.class);
        if (DVTPlugin.getDefault().getPreferenceStore().getBoolean("bufferSaveWhenOverlappingOperationInProgress") && (this.fBufferSaveInProgress || DVTJobsUtils.isBlockingJobInProgress(resource))) {
            this.fBufferSavePending.set(true);
            if (this.fPendingSaveNotification == null) {
                this.fPendingSaveNotification = new PersistentDVTNotification(this, 256, NOT_SAVED_NOTIFICATION);
                this.fPendingSaveNotification.setText(NOT_SAVED_MESSAGE);
                this.fPendingSaveNotification.create();
            }
            return;
        }
        this.doRegularSave();
    }

    private void doRegularSave() {
        WorkspaceDiskSpaceOnSaveChecker.tryDiskSpaceCheckOnSave(this);
        super.doSave(this.getProgressMonitor());
        this.fBufferSavePending.set(false);
    }

    public void deepClean() {
        this.fSHInvalidateJob = null;
        this.fReadOnlyNotificationJob = null;
        this.fPrefStore = null;
        this.fSelectionStack = null;
        this.fCurrentFile = null;
        this.fVHBCCache = null;
        this.fDHBCCache = null;
        this.fWordFinder = null;
        this.fReadOnlyNotification = null;
        IDocument document = this.getDocument();
        if (DVTUtilsCommon.INSTANCE.isOpenClonedEditorSharingSameDocument(document)) {
            return;
        }
        if (document == null) {
            return;
        }
        try {
            document.removePositionCategory("SEMANTIC_HIGHLIGHT");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        try {
            document.removePositionCategory("__dvt_folding_position");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        try {
            document.removePositionCategory("REFLECTION");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        try {
            document.removePositionCategory("__dvt_macro_position");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        try {
            document.removePositionCategory("__dvt_inactive_code_position");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        try {
            document.removePositionCategory("__dvt_protected_code_position");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        try {
            document.removePositionCategory("CUSTOM_PRAGMA");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        try {
            document.removePositionCategory("__dvt_pverilog_preproc_code_position");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        try {
            document.removePositionCategory("__dvt_pverilog_generated_code_position");
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public abstract String getCodePartition();

    public static boolean isCommentPartition(String partition) {
        if ("__vlog_sl_comment".equals(partition) || "__vlog_ml_comment".equals(partition)) {
            return true;
        }
        if ("__vhdl_sl_comment".equals(partition) || "__vhdl_ml_comment".equals(partition)) {
            return true;
        }
        if ("__e_sl_comment".equals(partition) || "__e_ml_comment".equals(partition) || "__e_sv_ml_comment".equals(partition)) {
            return true;
        }
        return "__pss_sl_comment".equals(partition) || "__pss_ml_comment".equals(partition);
    }

    private void triggerInspectViewSelectorJob(IDocument document, int cursorOffset) {
        if (INSPECT_DISABLED) {
            return;
        }
        this.fInspectViewSelectorJob.cancel();
        this.fInspectViewSelectorJob.setContent(document, cursorOffset);
        this.fInspectViewSelectorJob.schedule(300L);
    }

    public ReadOnlyNotification testGetReadOnlyNotification() {
        return this.fReadOnlyNotification;
    }

    public CopyHierarchyPathAction testHelpCopyHierarchyWirePathAction() {
        return null;
    }

    public abstract void recomputeHighlightPositionsAndInvalidateEditor();

    public boolean isVisible() {
        IWorkbenchWindow activeWorkbenchWindow = DVTUiUtils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return false;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return false;
        }
        return activePage.isPartVisible((IWorkbenchPart)this);
    }

    @Override
    public void createContentAssistNotification(Binding contentAssistBinding) {
        String message = "Autocomplete shortcut is \"" + contentAssistBinding.getTriggerSequence().toString() + "\". Click <a href=\"showKeysPrefPage\">here</a> to configure.";
        if (this.fContentAssistNotification != null) {
            Composite notificationComposite = this.fContentAssistNotification.getNotificationComposite();
            if (notificationComposite == null) {
                return;
            }
            if (!notificationComposite.isDisposed()) {
                this.fContentAssistNotification.resetText(message);
                return;
            }
        }
        this.fContentAssistNotification = new SimpleDVTNotification(this, 256, "CONTENT_ASSIST_NOTIFICATION").setText(message).setShowPreferenceKey("show.content.assist.notifications").setListener("showKeysPrefPage", new Runnable(){

            @Override
            public void run() {
                PreferencesUtil.createPreferenceDialogOn((Shell)DVTUiUtils.getActiveWorkbenchShell(), (String)DVTEditor.KEYS_PREFERENCE_PAGE_ID, null, null).open();
            }
        });
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> this.fContentAssistNotification.create());
    }

    @Override
    public void destroyContentAssistNotification() {
        if (this.fContentAssistNotification == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> this.fContentAssistNotification.destroy());
        this.fContentAssistNotification = null;
    }

    void reInstallTabsToSpacesConverter() {
        super.installTabsToSpacesConverter();
    }

    public ParserPath getParserPath() {
        IEditorInput input = this.getEditorInput();
        if (input == null) {
            return null;
        }
        IFile file = (IFile)input.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return DVTFileUtils.getInstance().resource2parser((IResource)file);
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new DVTSourceViewerDecorationSupport(viewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        }
        return this.fSourceViewerDecorationSupport;
    }

    public String toString() {
        return this.getTitle();
    }

    public abstract QuickLazyOutlineView createQuickOutlineView();

    public QuickLazyDVTVariablesView createQuickLazyDVTVariablesView() {
        return new QuickLazyDVTVariablesView(this);
    }

    protected void updateBreadcrumb(IMarker marker) {
        MarkerInfo info = ((Workspace)ResourcesPlugin.getWorkspace()).getMarkerManager().findMarkerInfo(marker.getResource(), marker.getId());
        if (info == null) {
            return;
        }
        Object elabPathAttribute = info.getAttribute("ELAB_PROBLEMS_ELEMENTPATH_ATTRIBUTE");
        if (!(elabPathAttribute instanceof String)) {
            return;
        }
        String elabPath = (String)elabPathAttribute;
        int indexOf = elabPath.indexOf(",");
        if (indexOf != -1) {
            elabPath = elabPath.substring(0, indexOf);
        }
        ElementPath bcPath = ElementPath.from(elabPath, ".");
        DesignPathManager.getInstance().updateFor(this, bcPath);
    }

    public void updateEditorNotification(ParserPath parserPath) {
    }

    public DVTProjectionViewer getFNotificationHostTextViewer() {
        return this.fSourceViewer;
    }

    public boolean shouldUseDefaultTabsToSpacesConversion() {
        return true;
    }

    public void detectIndentation() {
        SourceViewerConfiguration sourceViewerConfiguration = this.getSourceViewerConfiguration();
        if (!(sourceViewerConfiguration instanceof DVTSourceViewerConfiguration)) {
            return;
        }
        ((DVTSourceViewerConfiguration)sourceViewerConfiguration).detectIndentation();
    }

    public class BackwardStartOfWord
    extends TextEditorAction {
        public BackwardStartOfWord(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        public void run() {
            IDocumentProvider documentProvider = DVTEditor.this.getDocumentProvider();
            if (documentProvider != null) {
                IDocument document = documentProvider.getDocument((Object)DVTEditor.this.getEditorInput());
                StyledText styledText = DVTEditor.this.fSourceViewer.getTextWidget();
                int offset = DVTEditor.this.fCursorOffset;
                int widget = -1;
                do {
                    offset = DVTEditor.this.fWordFinder.goToStartOfWord(document, offset);
                    widget = DVTEditor.modelOffset2WidgetOffset((ISourceViewer)((ISourceViewer)DVTEditor.this.fSourceViewer), (int)offset);
                } while (offset > 0 && widget < 0);
                if (widget >= 0) {
                    styledText.setCaretOffset(widget);
                    styledText.showSelection();
                    this.doFireSelectionChanged(styledText);
                }
            }
        }

        private void doFireSelectionChanged(StyledText styledText) {
            Event event = new Event();
            event.x = styledText.getSelection().x;
            event.y = styledText.getSelection().y;
            styledText.notifyListeners(13, event);
        }
    }

    public class CollapseAllLevelsAction
    extends TextEditorAction {
        public CollapseAllLevelsAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        public void run() {
            try {
                try {
                    DVTEditor.this.fSourceViewer.setRedraw(false);
                    DVTEditor.this.fAnnotationModel.collapseAll(0, DVTEditor.this.getDocument().getLength());
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    DVTEditor.this.fSourceViewer.setRedraw(true);
                }
            }
            finally {
                DVTEditor.this.fSourceViewer.setRedraw(true);
            }
        }
    }

    class ContentAssistListener
    implements IDocumentListener {
        private final char AMPERSAND_CHAR = (char)37;
        private List<String> fContentAssistStrings;
        private int fMaxStringLength;
        private ContentAssistTriggerJob fTrigger = new ContentAssistTriggerJob();

        public ContentAssistListener() {
            this.initialize();
        }

        public void initialize() {
            String rawPref = DVTEditor.this.getPluginSpecificPreferenceStore().getString("ca.chars_trigger");
            this.fContentAssistStrings = new ArrayList<String>();
            this.fMaxStringLength = 0;
            for (String piece : Arrays.asList(rawPref.split(","))) {
                if (piece.isEmpty() || this.fContentAssistStrings.contains(piece)) continue;
                this.fMaxStringLength = Math.max(piece.length(), this.fMaxStringLength);
                this.fContentAssistStrings.add(piece);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            char currChar;
            if (DVTEditor.this.currentEditEvents == null) {
                DVTEditor.this.currentEditEvents = new ArrayList();
            }
            DVTEditor.this.currentEditEvents.add(event);
            if (event.getDocument() instanceof IDocumentExtension4 && ((IDocumentExtension4)event.getDocument()).getActiveRewriteSession() != null) {
                return;
            }
            if (!DVTEditor.this.isActivePart()) {
                return;
            }
            char c = currChar = event.fLength == 0 && event.fText.length() == 1 ? event.fText.charAt(0) : (char)'\u0000';
            if (currChar == '\u0000') {
                return;
            }
            String text = null;
            boolean formatString = false;
            try {
                String partitioning = DVTFileUtils.getInstance().getPartitioning((IDocumentExtension3)event.fDocument);
                String contentType = ((IDocumentExtension3)event.fDocument).getContentType(partitioning, event.fOffset, false);
                if (contentType == null) {
                    return;
                }
                boolean bl = formatString = contentType.equals("__e_string") || contentType.equals("__vlog_literal");
                if (!(formatString || contentType.equals("__dftl_partition_content_type") || contentType.equals("__vlog_escaped_id") || contentType.equals("__vhdl_psl_code"))) {
                    return;
                }
            }
            catch (BadLocationException | BadPartitioningException throwable) {
                return;
            }
            if (formatString) {
                if (currChar == '%' && this.fContentAssistStrings.contains(String.valueOf(currChar))) {
                    this.doContentAssist();
                }
                return;
            }
            for (String candidate : this.fContentAssistStrings) {
                if (currChar != candidate.charAt(candidate.length() - 1)) continue;
                try {
                    int offset = event.fOffset;
                    if (text == null) {
                        offset = Math.max(event.fOffset - this.fMaxStringLength + 1, 0);
                        text = event.fDocument.get(offset, this.fMaxStringLength);
                    }
                    if (!text.endsWith(candidate)) continue;
                    this.doContentAssist();
                    return;
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        private void doContentAssist() {
            this.fTrigger.schedule(DVTPlugin.getDefault().getPreferenceStore().getInt("ca.delay_trigger"));
        }

        class ContentAssistTriggerJob
        extends UIJob {
            public ContentAssistTriggerJob() {
                super("DVT Content Assist");
            }

            public boolean shouldSchedule() {
                return !DVTPlugin.getDefault().getPreferenceStore().getBoolean("editor.disable_auto_complete");
            }

            public boolean shouldRun() {
                return !DVTPlugin.getDefault().getPreferenceStore().getBoolean("editor.disable_auto_complete");
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ProjectionViewer viewer = (ProjectionViewer)DVTEditor.this.getSourceViewer();
                viewer.doOperation(13);
                return Status.OK_STATUS;
            }
        }
    }

    private class CursorOffsetBeforeFormatting {
        private int fCursorOffset;

        public CursorOffsetBeforeFormatting() {
            ISelection selection = DVTEditor.this.fSourceViewer.getSelection();
            if (!(selection instanceof TextSelection)) {
                return;
            }
            if (((TextSelection)selection).getLength() != 0) {
                this.fCursorOffset = -1;
                return;
            }
            this.fCursorOffset = DVTEditor.this.getCursor();
        }

        public int getCursorOffsetBeforeFormatting() {
            return this.fCursorOffset;
        }
    }

    public class DefineFoldingRegionAction
    extends TextEditorAction {
        public DefineFoldingRegionAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        private IAnnotationModel getAnnotationModel(ITextEditor editor) {
            return (IAnnotationModel)editor.getAdapter(ProjectionAnnotationModel.class);
        }

        public void run() {
            IAnnotationModel annotationModel;
            ITextSelection textSelection;
            ITextEditor editor = this.getTextEditor();
            ISelection selection = editor.getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection && !(textSelection = (ITextSelection)selection).isEmpty() && (annotationModel = this.getAnnotationModel(editor)) != null) {
                int start = textSelection.getStartLine();
                int end = textSelection.getEndLine();
                try {
                    IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                    int offset = document.getLineOffset(start);
                    int endOffset = document.getLineOffset(end + 1);
                    DVTCustomFoldingPosition position = new DVTCustomFoldingPosition(offset, endOffset - offset);
                    annotationModel.addAnnotation((Annotation)new ProjectionAnnotation(), (Position)position);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
    }

    class DocumentChangedAfterCursorMovedListener
    implements CaretListener,
    ModifyListener {
        private CaretEvent[] fLastCaretMovedEvent = new CaretEvent[2];
        private ModifyEvent fLastModifyEvent;

        DocumentChangedAfterCursorMovedListener() {
        }

        public void caretMoved(CaretEvent event) {
            if (BuildConfigManager.getCustomPragmas(DVTEditor.this.getProject()).isEmpty()) {
                return;
            }
            this.fLastCaretMovedEvent[1] = this.fLastCaretMovedEvent[0];
            this.fLastCaretMovedEvent[0] = event;
            DVTEditor.this.fReadOnlyNotificationJob.cancel();
            DVTEditor.this.fReadOnlyNotificationJob.schedule(300L);
        }

        public void modifyText(ModifyEvent e) {
            if (BuildConfigManager.getCustomPragmas(DVTEditor.this.getProject()).isEmpty()) {
                return;
            }
            if (this.fLastModifyEvent != null && this.fLastCaretMovedEvent[1] != null && this.fLastCaretMovedEvent[1].time != this.fLastModifyEvent.time) {
                DVTEditor.this.fReadOnlyNotificationJob.cancel();
                DVTEditor.this.fReadOnlyNotificationJob.schedule();
            }
            this.fLastModifyEvent = e;
            if (DVTEditor.this.fReadOnlyNotification != null && !DVTEditor.this.fReadOnlyNotification.isDestroyed()) {
                DVTEditor.this.fReadOnlyNotification.blink();
            }
        }
    }

    private class DocumentRewriteSessionListener
    implements IDocumentRewriteSessionListener {
        private DocumentRewriteSessionListener() {
        }

        public void documentRewriteSessionChanged(DocumentRewriteSessionEvent event) {
            if (!DocumentRewriteSessionEvent.SESSION_STOP.equals(event.getChangeType())) {
                return;
            }
            try {
                if (DVTEditor.this.getLanguageKind() == null) {
                    return;
                }
                IFile file = (IFile)DVTEditor.this.getEditorInput().getAdapter(IFile.class);
                if (file == null) {
                    return;
                }
                if (!file.getProject().hasNature(DVTEditor.this.getLanguageKind().NATURE_ID)) {
                    return;
                }
                DVTEditor.this.scheduleReparse(event.getDocument(), file);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public class ExpandAllLevelsAction
    extends TextEditorAction {
        public ExpandAllLevelsAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        public void run() {
            try {
                try {
                    DVTEditor.this.fSourceViewer.setRedraw(false);
                    DVTEditor.this.fAnnotationModel.expandAll(0, DVTEditor.this.getDocument().getLength());
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    DVTEditor.this.fSourceViewer.setRedraw(true);
                }
            }
            finally {
                DVTEditor.this.fSourceViewer.setRedraw(true);
            }
        }
    }

    public class FormatSourceAction
    extends TextEditorAction {
        public FormatSourceAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        public void run() {
            IResource resource;
            if (!DVTEditor.this.c()) {
                return;
            }
            DVTEditor editor = DVTEditor.this;
            IEditorInput input = editor.getEditorInput();
            if (input != null && (resource = (IResource)input.getAdapter(IResource.class)) != null && resource.getResourceAttributes() != null && resource.getResourceAttributes().isReadOnly()) {
                IWorkbenchPartReference activePartReference;
                IWorkbenchPage editorPage;
                editor.validateState(input);
                editor.updateState(input);
                IEditorSite editorSite = editor.getEditorSite();
                if (editorSite != null && (editorPage = editorSite.getPage()) != null && (activePartReference = editorPage.getActivePartReference()) != null) {
                    FileAcessEditorDecorator.getInstance().partActivated(activePartReference);
                }
                if (resource.getResourceAttributes() != null && resource.getResourceAttributes().isReadOnly()) {
                    return;
                }
            }
            if (DVTEditor.this.fPrefStore.getBoolean("format.external")) {
                DVTExternalToolFormatter.format((ITextEditor)editor, DVTEditor.this.fPrefStore.getString("format.external.command"));
                return;
            }
            ProjectionViewer viewer = (ProjectionViewer)DVTEditor.this.getSourceViewer();
            if (viewer.isEditable()) {
                try {
                    try {
                        viewer.setRedraw(false);
                        DVTEditor.this.fAnnotationModel.expandAll(0, editor.getDocument().getLength());
                        PlatformUI.getWorkbench().getDisplay().update();
                        editor.setFormattingOperationInProgress();
                        viewer.doOperation(15);
                        editor.resetFormattingOperationInProgress();
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        viewer.setRedraw(true);
                    }
                }
                finally {
                    viewer.setRedraw(true);
                }
            }
        }
    }

    public class ForwardEndOfWord
    extends TextEditorAction {
        public ForwardEndOfWord(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        public void run() {
            IDocumentProvider documentProvider = DVTEditor.this.getDocumentProvider();
            if (documentProvider != null) {
                IDocument document = documentProvider.getDocument((Object)DVTEditor.this.getEditorInput());
                StyledText styledText = DVTEditor.this.fSourceViewer.getTextWidget();
                int offset = DVTEditor.this.fCursorOffset;
                int widget = -1;
                do {
                    offset = DVTEditor.this.fWordFinder.goToEndOfWord(document, offset);
                    widget = DVTEditor.modelOffset2WidgetOffset((ISourceViewer)((ISourceViewer)DVTEditor.this.fSourceViewer), (int)offset);
                } while (offset > 0 && widget < 0);
                if (widget >= 0) {
                    styledText.setCaretOffset(widget);
                    styledText.showSelection();
                    this.doFireSelectionChanged(styledText);
                }
            }
        }

        private void doFireSelectionChanged(StyledText styledText) {
            Event event = new Event();
            event.x = styledText.getSelection().x;
            event.y = styledText.getSelection().y;
            styledText.notifyListeners(13, event);
        }
    }

    public class GoToPairMatchingBeginEndBlockOrPairBracket
    extends TextEditorAction {
        private ICharacterPairMatcher fBracketMatcher;
        private int fOffset;
        private int fLastOffset;
        private String fTextName;
        private List<LanguageKind> fBeginEndMatchSupportedLanguageKinds;

        public GoToPairMatchingBeginEndBlockOrPairBracket(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
            this.fOffset = -1;
            this.fLastOffset = -1;
            this.fTextName = null;
            this.fBeginEndMatchSupportedLanguageKinds = new ArrayList<LanguageKind>(Arrays.asList(LanguageKind.VLOG, LanguageKind.VHDL));
            this.fBracketMatcher = DVTEditor.this.getBracketMatcher();
        }

        public void update() {
            boolean result = this.computeOffsetAndSetName();
            if (!result) {
                super.update();
                return;
            }
            if (this.fTextName != null) {
                this.setText(this.fTextName);
            }
            super.update();
        }

        public void run() {
            boolean result = this.computeOffsetAndSetName();
            if (!result || DVTEditor.this.fSourceViewer == null) {
                return;
            }
            StyledText styledText = DVTEditor.this.fSourceViewer.getTextWidget();
            if (this.fOffset >= 0) {
                this.fOffset = DVTEditor.modelOffset2WidgetOffset((ISourceViewer)((ISourceViewer)DVTEditor.this.fSourceViewer), (int)(this.fOffset + 1));
                if (this.fOffset >= 0) {
                    styledText.setCaretOffset(this.fOffset);
                }
                styledText.showSelection();
                this.doFireSelectionChanged(styledText);
            }
        }

        private boolean computeOffsetAndSetName() {
            IDocument document = DVTEditor.this.getDocument();
            IDocumentProvider documentProvider = DVTEditor.this.getDocumentProvider();
            int cursor = DVTEditor.this.getCursor();
            if (this.fBracketMatcher == null || DVTEditor.this.fWordFinder == null || document == null || documentProvider == null || cursor == -1) {
                this.fLastOffset = -1;
                this.fTextName = null;
                return false;
            }
            IRegion region = DVTEditor.this.fWordFinder.getWordAtOffset(document, cursor, true);
            if ((region.getOffset() != 0 || region.getLength() != 0) && region.getOffset() == this.fLastOffset) {
                return true;
            }
            this.fLastOffset = region.getOffset();
            region = this.fBracketMatcher.match(DVTEditor.this.getDocument(), DVTEditor.this.getCursor());
            if (region == null && this.fBeginEndMatchSupportedLanguageKinds.contains((Object)DVTEditor.this.getLanguageKind())) {
                MatchBeginEndPositionInfo matchingBeginEndRegionInfo;
                boolean shouldLookForAdditionalSyntax = false;
                if (DVTEditor.this.getLanguageKind() == LanguageKind.VHDL) {
                    shouldLookForAdditionalSyntax = true;
                }
                if ((matchingBeginEndRegionInfo = DVTDocumentUtils.getMatchingBeginEndBlockForOffset(cursor, document, DVTEditor.this.fWordFinder, shouldLookForAdditionalSyntax)) == null || matchingBeginEndRegionInfo.getBeginEndRegion() == null || matchingBeginEndRegionInfo.getPositionSubType() == null) {
                    this.fLastOffset = -1;
                    this.fTextName = null;
                    return false;
                }
                IRegion matchingBeginEndRegion = matchingBeginEndRegionInfo.getBeginEndRegion();
                switch (matchingBeginEndRegionInfo.getPositionSubType()) {
                    case START: {
                        this.fOffset = matchingBeginEndRegion.getOffset() + matchingBeginEndRegion.getLength() - 1;
                        this.fTextName = "Jump To Matching End Block";
                        return true;
                    }
                    case END: {
                        this.fOffset = matchingBeginEndRegion.getOffset() == 0 ? matchingBeginEndRegion.getOffset() : matchingBeginEndRegion.getOffset() - 1;
                        this.fTextName = "Jump to Matching Begin Block";
                        return true;
                    }
                }
                this.fLastOffset = -1;
                this.fTextName = null;
                return false;
            }
            if (region != null) {
                int anchor = this.fBracketMatcher.getAnchor();
                this.fOffset = region.getOffset();
                if (anchor == 1) {
                    this.fOffset += region.getLength() - 1;
                }
                this.fTextName = "Jump To Pair Bracket";
                return true;
            }
            this.fLastOffset = -1;
            this.fTextName = null;
            return false;
        }

        private void doFireSelectionChanged(StyledText styledText) {
            Event event = new Event();
            event.x = styledText.getSelection().x;
            event.y = styledText.getSelection().y;
            styledText.notifyListeners(13, event);
        }
    }

    class InspectViewSelectorJob
    extends Job {
        private IDocument fDocument;
        private int fCursorOffset;

        public InspectViewSelectorJob() {
            super("Trigger Inspect Update From Editor Job");
        }

        public void setContent(IDocument document, int cursorOffset) {
            this.fDocument = document;
            this.fCursorOffset = cursorOffset;
        }

        public IStatus run(IProgressMonitor progressMonitor) {
            try {
                if (!InspectView.isActive()) {
                    return Status.OK_STATUS;
                }
                if (DVTEditor.this.getCodePartition() == null || DVTEditor.this.getCodePartition().isEmpty()) {
                    return Status.OK_STATUS;
                }
                if (!WAVEDROM_DISABLED) {
                    AtomicReference partition = new AtomicReference();
                    Display.getDefault().syncExec(() -> {
                        try {
                            partition.set(((IDocumentExtension3)this.fDocument).getContentType(DVTEditor.this.getCodePartition(), this.fCursorOffset, false));
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    });
                    Object wavedromContent = "";
                    if (DVTEditor.isCommentPartition((String)partition.get())) {
                        wavedromContent = WaveDromManager.getInstance().getWaveform(this.fDocument, DVTEditor.this.fCurrentFile, this.fCursorOffset, DVTEditor.this.getCodePartition(), (String)partition.get());
                    } else {
                        AtomicInteger cursor = new AtomicInteger(-1);
                        Display.getDefault().syncExec(() -> cursor.set(DVTEditor.this.getCursor()));
                        IRfNamedElementAndScope cursorElement = DVTEditor.this.getCursorElementNonUi(cursor.get());
                        wavedromContent = BitFieldUtils.getModelForEditor(DVTEditor.this, cursorElement, cursor.get());
                    }
                    if (wavedromContent instanceof BitFieldModel || wavedromContent instanceof String && !((String)wavedromContent).isEmpty()) {
                        WaveDromListener.INSTANCE.runInspectViewJob(wavedromContent);
                        return Status.OK_STATUS;
                    }
                }
                InspectViewSelectionListener.getInstance().resourceSelectionChanged((ISelection)new TextSelection(this.fDocument, this.fCursorOffset, 0));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }

    private static class LazyShowInContext
    extends ShowInContext {
        private ISelectionProvider fSelectionProvider;

        public LazyShowInContext(Object input, ISelectionProvider selectionProvider) {
            super(input, null);
            this.fSelectionProvider = selectionProvider;
        }

        public ISelection getSelection() {
            if (this.fSelectionProvider == null) {
                return null;
            }
            return this.fSelectionProvider.getSelection();
        }
    }

    private class MarkOccurencesPreferenceListener
    implements IPropertyChangeListener {
        private MarkOccurencesPreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!("editor.markOccurencesNumberOfLines".equals(event.getProperty()) || "editor.markOccurencesNumberOfMatches".equals(event.getProperty()) || "editor.markOccurencesNumberOfMatchesPerLine".equals(event.getProperty()) || "editor.markOccurencesMatchPartialWords".equals(event.getProperty()))) {
                return;
            }
            if (!DVTPlugin.getDefault().getPreferenceStore().getBoolean("markOccurrences")) {
                return;
            }
            IDocumentProvider documentProvider = DVTEditor.this.getDocumentProvider();
            if (documentProvider == null) {
                return;
            }
            IEditorInput editorInput = DVTEditor.this.getEditorInput();
            if (editorInput == null) {
                return;
            }
            IDocument document = documentProvider.getDocument((Object)editorInput);
            if (document == null) {
                return;
            }
            if ("editor.markOccurencesMatchPartialWords".equals(event.getProperty())) {
                DVTEditor.this.fMatchPartialWords = !DVTEditor.this.fMatchPartialWords;
            }
            DVTEditor.this.fPrevOccurrencesWrapper.reset();
            DVTEditor.this.updateOccurrenceAnnotations(document, DVTEditor.this.fCursorOffset, true);
        }
    }

    class OccurrencesFinderJob
    extends Job {
        private final IDocument fDocument;
        private boolean fCanceled;
        private final Map<Annotation, Position> fAnnotationMap;

        public OccurrencesFinderJob(IDocument document, Map<Annotation, Position> annotationMap) {
            super("Occurrence finder job");
            this.fDocument = document;
            this.fAnnotationMap = annotationMap;
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled(IProgressMonitor progressMonitor) {
            return this.fCanceled || progressMonitor.isCanceled() || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            if (DVTEditor.this.fSourceViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = DVTEditor.this.fSourceViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IDocumentProvider documentProvider = DVTEditor.this.getDocumentProvider();
            if (documentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)DVTEditor.this.getEditorInput());
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            if (this.isCanceled(progressMonitor)) {
                return Status.CANCEL_STATUS;
            }
            Object object = DVTEditor.this.getLockObject(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(DVTEditor.this.fOccurrenceAnnotations, this.fAnnotationMap);
                } else {
                    DVTEditor.this.removeOccurrenceAnnotations();
                    for (Map.Entry<Annotation, Position> mapEntry : this.fAnnotationMap.entrySet()) {
                        annotationModel.addAnnotation(mapEntry.getKey(), mapEntry.getValue());
                    }
                }
                DVTEditor.this.fOccurrenceAnnotations = this.fAnnotationMap.keySet().toArray(new Annotation[this.fAnnotationMap.keySet().size()]);
            }
            return Status.OK_STATUS;
        }
    }

    class OccurrencesFinderJobCanceler
    implements IDocumentListener,
    ITextInputListener {
        OccurrencesFinderJobCanceler() {
        }

        public void install() {
            StyledText text = DVTEditor.this.fSourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            DVTEditor.this.fSourceViewer.addTextInputListener(this);
            IDocument document = DVTEditor.this.fSourceViewer.getDocument();
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void uninstall() {
            IDocument document;
            DVTEditor.this.fSourceViewer.removeTextInputListener(this);
            IDocumentProvider documentProvider = DVTEditor.this.getDocumentProvider();
            if (documentProvider != null && (document = documentProvider.getDocument((Object)DVTEditor.this.getEditorInput())) != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (DVTEditor.this.fOccurrencesFinderJob != null) {
                DVTEditor.this.fOccurrencesFinderJob.doCancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == null) {
                return;
            }
            oldInput.removeDocumentListener((IDocumentListener)this);
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput == null) {
                return;
            }
            newInput.addDocumentListener((IDocumentListener)this);
        }
    }

    private class OnePreferenceListener
    implements IPropertyChangeListener {
        private OnePreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!event.getProperty().startsWith("highlight")) {
                DVTEditor.this.fPropertyChangedEvent = true;
            }
        }
    }

    public class OpenHelpSearch
    extends Action {
        public void run() {
            if (!DVTHelp.getHelpTest()) {
                return;
            }
            DVTJobsUtils.runWithBusyIndicator(new Runnable(){

                @Override
                public void run() {
                    ISelection sel = ((OpenHelpSearch)OpenHelpSearch.this).DVTEditor.this.fSourceViewer.getSelectionProvider().getSelection();
                    if (sel instanceof TextSelection && !sel.isEmpty() && ((TextSelection)sel).getText().length() != 0) {
                        PlatformUI.getWorkbench().getHelpSystem().search(((TextSelection)sel).getText());
                    } else {
                        PlatformUI.getWorkbench().getHelpSystem().displaySearch();
                    }
                }
            });
        }
    }

    class PopReadOnlyNotificationJob
    extends Job {
        public PopReadOnlyNotificationJob() {
            super("Pop up Read Only Notification");
            this.setPriority(10);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                IDocument document = DVTEditor.this.getDocument();
                if (document == null) {
                    return Status.OK_STATUS;
                }
                if (!document.containsPositionCategory("CUSTOM_PRAGMA")) {
                    if (DVTEditor.this.fReadOnlyNotification != null) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> DVTEditor.this.fReadOnlyNotification.destroy());
                    }
                    return Status.OK_STATUS;
                }
                CustomPragmaPosition potentialPosition = null;
                Position[] positionArray = document.getPositions("CUSTOM_PRAGMA");
                int n = positionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Position position = positionArray[n2];
                    if (position instanceof CustomPragmaPosition) {
                        if (position.includes(DVTEditor.this.fCursorOffset)) {
                            potentialPosition = (CustomPragmaPosition)position;
                        } else if (potentialPosition != null) break;
                    }
                    ++n2;
                }
                if (potentialPosition == null) {
                    if (DVTEditor.this.fReadOnlyNotification != null) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> DVTEditor.this.fReadOnlyNotification.destroy());
                    }
                    return Status.OK_STATUS;
                }
                if (!potentialPosition.isReadOnly()) {
                    if (DVTEditor.this.fReadOnlyNotification != null) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> DVTEditor.this.fReadOnlyNotification.destroy());
                    }
                    return Status.OK_STATUS;
                }
                CustomPragmaPosition pragmaPosition = potentialPosition;
                if (DVTEditor.this.fReadOnlyNotification != null && !DVTEditor.this.fReadOnlyNotification.isDestroyed()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> DVTEditor.this.fReadOnlyNotification.setText(pragmaPosition.getPragmaName()));
                    return Status.OK_STATUS;
                }
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    DVTEditor.this.fReadOnlyNotification = new ReadOnlyNotification(DVTEditor.this);
                    DVTEditor.this.fReadOnlyNotification.create();
                    DVTEditor.this.fReadOnlyNotification.setText(pragmaPosition.getPragmaName());
                });
                return Status.OK_STATUS;
            }
            catch (BadPositionCategoryException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return Status.OK_STATUS;
            }
        }
    }

    private class RebuildTriggerListener
    implements IDocumentListener {
        private boolean fActualChange;

        private RebuildTriggerListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            this.fActualChange = true;
            try {
                if (event.fDocument == null) {
                    return;
                }
                String oldText = event.fDocument.get(event.fOffset, event.fLength);
                if (oldText.equals(event.fText)) {
                    this.fActualChange = false;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        public void documentChanged(DocumentEvent event) {
            try {
                if (DVTEditor.this.isNoIncrementalTrigger()) {
                    return;
                }
                if (!this.fActualChange) {
                    return;
                }
                if (DVTEditor.this.getLanguageKind() == null) {
                    return;
                }
                if (event.getDocument() instanceof IDocumentExtension4 && ((IDocumentExtension4)event.getDocument()).getActiveRewriteSession() != null) {
                    return;
                }
                IFile file = (IFile)DVTEditor.this.getEditorInput().getAdapter(IFile.class);
                if (file == null) {
                    return;
                }
                if (!file.getProject().hasNature(DVTEditor.this.getLanguageKind().NATURE_ID)) {
                    return;
                }
                DVTEditor.this.scheduleReparse(event.getDocument(), file);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public class RestoreLastSelection
    extends TextEditorAction {
        public RestoreLastSelection(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        public void run() {
            if (DVTEditor.this.fSelectionStack.isEmpty()) {
                return;
            }
            Point currentSelection = DVTEditor.this.fSourceViewer.getSelectedRange();
            Point foldSelection = DVTEditor.this.fSelectionStack.pop();
            if (currentSelection.x == foldSelection.x && currentSelection.y == foldSelection.y) {
                foldSelection = DVTEditor.this.fSelectionStack.pop();
            }
            DVTEditor.this.expandSelectionAndReveal(foldSelection.x, foldSelection.y);
        }
    }

    class SHInvalidateJob
    extends UIJob {
        public SHInvalidateJob() {
            super("Invalidate Visible Text for Semantic Highlight");
            this.setPriority(10);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                if (DVTEditor.this.getDocument() == null) {
                    return Status.OK_STATUS;
                }
                DVTEditor.this.recomputeHighlightPositionsAndInvalidateEditor();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }

    public class SelectEnclosingElement
    extends SelectEnclosingElementCommon {
        public SelectEnclosingElement(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        public void run() {
            try {
                IDocumentProvider documentProvider = DVTEditor.this.getDocumentProvider();
                if (documentProvider == null) {
                    return;
                }
                IDocument document = documentProvider.getDocument((Object)DVTEditor.this.getEditorInput());
                if (document == null) {
                    return;
                }
                Point initialSelection = DVTEditor.this.fSourceViewer.getSelectedRange();
                DVTEditor.this.fSelectionStack.push(initialSelection);
                IRegion cursorLine = document.getLineInformationOfOffset(this.getCursor());
                if (cursorLine == null) {
                    return;
                }
                Point inspectSelection = DVTEditor.this.fSelectionStack.peek();
                if (inspectSelection == null) {
                    return;
                }
                SelectEnclosingElementCommon.EnclosingElementRange enclosingElementRange = this.getEnclosingElementRange(DVTEditor.this.fWordFinder.getWordAtOffset(document, this.getCursor()), inspectSelection);
                if (enclosingElementRange == null) {
                    return;
                }
                DVTEditor.this.expandSelectionAndReveal(enclosingElementRange.getOffset(), enclosingElementRange.getLength());
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return;
            }
        }

        @Override
        protected int getBeginOffset(int endOffset, IDocument document) throws BadLocationException, BadPartitioningException {
            return DVTDocumentUtils.getMatchingLeftBracketOffset(endOffset, DVTEditor.this, document);
        }

        @Override
        protected IDocument getDocument() {
            IDocumentProvider documentProvider = DVTEditor.this.getDocumentProvider();
            if (documentProvider == null) {
                return null;
            }
            return documentProvider.getDocument((Object)DVTEditor.this.getEditorInput());
        }

        @Override
        protected int getCursorLineNumber() {
            ITextEditor editor = this.getTextEditor();
            if (!(editor instanceof DVTEditor)) {
                return -1;
            }
            return ((DVTEditor)editor).getCursorLineNumber();
        }

        @Override
        protected Position[] getFoldingPositions() {
            ITextEditor editor = this.getTextEditor();
            if (!(editor instanceof DVTEditor)) {
                return null;
            }
            return ((DVTEditor)editor).getFoldingPositions();
        }

        @Override
        protected int getCursor() {
            ITextEditor editor = this.getTextEditor();
            if (!(editor instanceof DVTEditor)) {
                return -1;
            }
            return ((DVTEditor)editor).getCursor();
        }

        @Override
        public Point getPeekSelection() {
            return DVTEditor.this.fSelectionStack.peek();
        }
    }

    public class ShowActivePreprocessingAction
    extends TextEditorAction {
        public ShowActivePreprocessingAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        public void run() {
            try {
                try {
                    DVTEditor.this.fSourceViewer.setRedraw(false);
                    DVTEditor.this.fFoldingManager.showActivePreprocessing(DVTEditor.this.getDocument(), DVTEditor.this.fAnnotationModel);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    DVTEditor.this.fSourceViewer.setRedraw(true);
                }
            }
            finally {
                DVTEditor.this.fSourceViewer.setRedraw(true);
            }
        }
    }

    public class ShowFirstLevelAction
    extends TextEditorAction {
        public ShowFirstLevelAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        public void run() {
            try {
                try {
                    DVTEditor.this.fSourceViewer.setRedraw(false);
                    DVTEditor.this.fFoldingManager.expandFirst(DVTEditor.this.fAnnotationModel);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    DVTEditor.this.fSourceViewer.setRedraw(true);
                }
            }
            finally {
                DVTEditor.this.fSourceViewer.setRedraw(true);
            }
        }
    }

    public class ToggleCollapseLineAction
    extends TextEditorAction {
        public ToggleCollapseLineAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        public void run() {
            try {
                try {
                    DVTEditor.this.fSourceViewer.setRedraw(false);
                    IDocumentProvider documentProvider = DVTEditor.this.getDocumentProvider();
                    if (documentProvider != null) {
                        IDocument document = documentProvider.getDocument((Object)DVTEditor.this.getEditorInput());
                        DVTEditor.this.fFoldingManager.toggleAtOffset(DVTEditor.this.fAnnotationModel, document, DVTEditor.this.fCursorOffset);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    DVTEditor.this.fSourceViewer.setRedraw(true);
                }
            }
            finally {
                DVTEditor.this.fSourceViewer.setRedraw(true);
            }
        }
    }

    public class ToggleExpandScopeAction
    extends TextEditorAction {
        public ToggleExpandScopeAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
        }

        public void run() {
            try {
                try {
                    DVTEditor.this.fSourceViewer.setRedraw(false);
                    IDocumentProvider documentProvider = DVTEditor.this.getDocumentProvider();
                    if (documentProvider != null) {
                        IDocument document = documentProvider.getDocument((Object)DVTEditor.this.getEditorInput());
                        Position rangeIndicationPosition = DVTEditor.this.getRangeIndicationPosition(DVTEditor.this.fCursorOffset);
                        DVTEditor.this.fFoldingManager.expandAllInScope(DVTEditor.this.fAnnotationModel, document, rangeIndicationPosition);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    DVTEditor.this.fSourceViewer.setRedraw(true);
                }
            }
            finally {
                DVTEditor.this.fSourceViewer.setRedraw(true);
            }
        }
    }
}

