/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.io.File;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IEditorAssociationOverride;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.OverrideEditor;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class DVTEditorAssociationOverride
implements IEditorAssociationOverride {
    public IEditorDescriptor[] overrideEditors(IEditorInput editorInput, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        return editorDescriptors;
    }

    public IEditorDescriptor[] overrideEditors(String fileName, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        return editorDescriptors;
    }

    public IEditorDescriptor overrideDefaultEditor(IEditorInput editorInput, IContentType contentType, IEditorDescriptor editorDescriptor) {
        try {
            if (!(editorInput instanceof FileEditorInput)) {
                return editorDescriptor;
            }
            IFile file = ((FileEditorInput)editorInput).getFile();
            if (file == null) {
                return editorDescriptor;
            }
            if (!file.exists()) {
                return editorDescriptor;
            }
            if (this.openWithWaveDiagramEditor(editorInput)) {
                return PlatformUI.getWorkbench().getEditorRegistry().findEditor("ro.amiq.dvt.diagrams.wave");
            }
            if (DVTFileUtils.isLargeFile(file.getLocationURI()) && this.wouldOpenWithTextEditor(editorDescriptor, file)) {
                return PlatformUI.getWorkbench().getEditorRegistry().findEditor("ro.amiq.dvt.ui.editor.LargeFileEditor");
            }
            if (PrecompiledDBUtils.isPrecompiledFile(file.getProject(), file.getLocationURI().getPath()) && !new File(file.getLocationURI().getPath()).exists()) {
                return PlatformUI.getWorkbench().getEditorRegistry().findEditor("ro.amiq.dvt.ui.editor.MissingPrecompiledFileEditor");
            }
            IEditorDescriptor candidate = DVTEditorAssociationOverride.getEditorDescriptor(file, editorDescriptor);
            if (candidate != null) {
                return candidate;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return editorDescriptor;
    }

    private boolean openWithWaveDiagramEditor(IEditorInput editorInput) {
        IResource iResource = (IResource)editorInput.getAdapter(IResource.class);
        if (!(iResource instanceof IFile)) {
            return false;
        }
        String fileName = ((IFile)iResource).getName();
        if (fileName == null || fileName.isEmpty()) {
            return false;
        }
        return DVTVCDUtils.isValidFileExtension(fileName);
    }

    private boolean wouldOpenWithTextEditor(IEditorDescriptor editorDescriptor, IFile file) throws CoreException {
        if (editorDescriptor == null) {
            editorDescriptor = this.systemEditorOrTextEditorStrategy(file.getName());
        }
        return Utils.isTextEditor((IEditorDescriptor)editorDescriptor);
    }

    public IEditorDescriptor systemEditorOrTextEditorStrategy(String name) {
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        if (editorReg == null) {
            return null;
        }
        IEditorDescriptor editorDesc = null;
        if (editorReg.isSystemInPlaceEditorAvailable(name)) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (editorDesc == null && editorReg.isSystemExternalEditorAvailable(name)) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (editorDesc == null) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        return editorDesc;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IEditorDescriptor getEditorDescriptor(IFile file, IEditorDescriptor editorDescriptor) {
        block19: {
            overrides = BuildConfigManager.getEditorAssociationOverrides(file.getProject());
            if (overrides != null) {
                location = file.getLocation();
                for (Map.Entry<StringMatcher, OverrideEditor> e : overrides.entrySet()) {
                    if (location == null || !e.getKey().match(location.toOSString()) || (result = e.getValue().getEditorDescriptor()) == null) continue;
                    return result;
                }
            }
            editorDescriptorId = "";
            if (editorDescriptor != null) {
                editorDescriptorId = editorDescriptor.getId();
            }
            if (!"org.eclipse.dltk.tcl.ui.editor.TclEditor".equals(editorDescriptorId)) break block19;
            return PlatformUI.getWorkbench().getEditorRegistry().findEditor("ro.amiq.dvt.tcl.ui.editor.DVTTclEditor");
            {
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
        }
        try {
            if (file.getPersistentProperty(IDE.EDITOR_KEY) != null) {
                return editorDescriptor;
            }
            ** GOTO lbl24
        }
        catch (Exception v0) {
            return editorDescriptor;
lbl24:
            // 1 sources

            editorIdOrLanguageSyntax = PropertiesManager.getSessionProperty((IResource)file, PropertyTypes.QN_IMPORTED_FILE);
            if (editorIdOrLanguageSyntax == null) {
                if (!PreprocUtils.getInstance().isPFile(file)) {
                    return editorDescriptor;
                }
                editorIdOrLanguageSyntax = PreprocUtils.getInstance().getEditorId();
            }
            languageSyntax = IBuildConfigParserConstants.LanguageSyntax.from(editorIdOrLanguageSyntax);
            editorId = "";
            if (languageSyntax == null) {
                editorId = "ro.amiq.dvt.tcl.ui.editor.DVTTclEditor".equals(editorDescriptorId) != false ? editorDescriptorId : editorIdOrLanguageSyntax;
                return PlatformUI.getWorkbench().getEditorRegistry().findEditor(editorId);
            }
            if (IBuildConfigParserConstants.LanguageSyntax.VERILOG_AMS_23 == languageSyntax || IBuildConfigParserConstants.LanguageSyntax.SYSTEMVERILOG_AMS == languageSyntax) {
                editorId = "ro.amiq.vlogdt.ui.editor.VlogAmsEditor";
                return PlatformUI.getWorkbench().getEditorRegistry().findEditor(editorId);
            }
            if (languageSyntax.languageKind == LanguageKind.VLOG) {
                editorId = "ro.amiq.vlogdt.ui.editor.VlogEditor";
                return PlatformUI.getWorkbench().getEditorRegistry().findEditor(editorId);
            }
            if (languageSyntax.languageKind == LanguageKind.VHDL) {
                editorId = "ro.amiq.vhdldt.ui.editor.VhdlEditor";
                return PlatformUI.getWorkbench().getEditorRegistry().findEditor(editorId);
            }
            if (languageSyntax.languageKind == LanguageKind.CPP) {
                editorId = "org.eclipse.cdt.ui.editor.CEditor";
                return PlatformUI.getWorkbench().getEditorRegistry().findEditor(editorId);
            }
            if (languageSyntax.languageKind == LanguageKind.SLN) {
                editorId = "ro.amiq.slndt.ui.editor.SLNEditor";
                return PlatformUI.getWorkbench().getEditorRegistry().findEditor(editorId);
            }
            if (languageSyntax.languageKind == LanguageKind.MSDL) {
                editorId = "ro.amiq.msdldt.ui.editor.MSDLEditor";
                return PlatformUI.getWorkbench().getEditorRegistry().findEditor(editorId);
            }
            if (languageSyntax.languageKind == LanguageKind.PSS) {
                editorId = "ro.amiq.pssdt.ui.editor.PSSEditor";
                return PlatformUI.getWorkbench().getEditorRegistry().findEditor(editorId);
            }
            if (languageSyntax.languageKind != LanguageKind.E) return PlatformUI.getWorkbench().getEditorRegistry().findEditor(editorId);
            editorId = "ro.amiq.edt.ui.editor.EEditor";
            return PlatformUI.getWorkbench().getEditorRegistry().findEditor(editorId);
        }
    }

    public IEditorDescriptor overrideDefaultEditor(String fileName, IContentType contentType, IEditorDescriptor editorDescriptor) {
        return editorDescriptor;
    }
}

