/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditor;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingPosition;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbTextHost;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class DVTEditorCommon
extends TextEditor
implements IDVTEditor,
IDVTBreadcrumbTextHost {
    public static final String ID = "ro.amiq.dvt.ui.editor.DVTEditor";
    public static final String INACTIVE_CODE_POSITION = "__dvt_inactive_code_position";
    public static final String PROTECTED_CODE_POSITION = "__dvt_protected_code_position";
    public static final String INACTIVE_GENERATE_BRANCH_POSITION = "__dvt_inactive_generate_branch_position";
    public static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    protected BreadcrumbInput fDHBCCache;
    protected BreadcrumbInput fVHBCCache;
    protected IFile fCurrentFile;
    protected List<DocumentEvent> currentEditEvents;

    public IFile getCurrentFile() {
        return this.fCurrentFile;
    }

    public abstract void setVisible(boolean var1);

    public static void addSemanticFolding(Set<DVTSemanticFoldingPosition> semanticFoldingPositions, DVTEditor editor) {
        DVTEditorCommon.createFoldingPositions(semanticFoldingPositions, editor);
    }

    private static void createFoldingPositions(Set<DVTSemanticFoldingPosition> computedPositions, DVTEditor editor) {
        ProjectionAnnotationModel model = editor.getProjectionAnnotationModel();
        if (model == null) {
            return;
        }
        Map<DVTSemanticFoldingPosition, Annotation> existingAnnotations = DVTFileUtils.getInstance().getAnnotationsByPositions(model);
        HashMap<ProjectionAnnotation, Position> aditions = new HashMap<ProjectionAnnotation, Position>(computedPositions.size());
        for (DVTSemanticFoldingPosition computedPosition : computedPositions) {
            if (existingAnnotations.remove(computedPosition) != null) continue;
            aditions.put(new ProjectionAnnotation(), computedPosition);
        }
        Collection<Annotation> annotationsToRemove = existingAnnotations.values();
        DVTEditor.replaceFoldingAnnotations(model, annotationsToRemove, aditions);
    }

    public static boolean isSingleLineComment(String partition) {
        if ("__e_sl_comment".equals(partition)) {
            return true;
        }
        if ("__vlog_sl_comment".equals(partition)) {
            return true;
        }
        if ("__vhdl_sl_comment".equals(partition)) {
            return true;
        }
        return "__pss_sl_comment".equals(partition);
    }

    public ICharacterPairMatcher getBracketMatcher() {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        if (!(configuration instanceof DVTSourceViewerConfiguration)) {
            return null;
        }
        return ((DVTSourceViewerConfiguration)configuration).getBracketMatcher();
    }

    @Override
    public void setBCCache(BreadcrumbInput bcInput, Class<?> breadcrumbType) {
        if (breadcrumbType == DHBreadcrumbViewer.class) {
            this.fDHBCCache = bcInput;
        }
        if (breadcrumbType == VHBreadcrumbViewer.class) {
            this.fVHBCCache = bcInput;
        }
    }

    @Override
    public BreadcrumbInput getBCCache(Class<?> breadcrumbType) {
        if (breadcrumbType == DHBreadcrumbViewer.class) {
            return this.fDHBCCache;
        }
        if (breadcrumbType == VHBreadcrumbViewer.class) {
            return this.fVHBCCache;
        }
        return null;
    }

    public String getNewLineDelimiter() {
        return DVTDocumentCommon.getLineDelimiter((IEditorPart)this);
    }

    public IRfNamedElementAndScope getCursorElement() {
        return this.getCursorElementNonUi(this.getCursor());
    }

    public IRfNamedElementAndScope getElementFromOffset(int offset) {
        return this.getCursorElementNonUi(offset);
    }

    public SourceViewerConfiguration getSourceViewerConfigurationForEditor() {
        return this.getSourceViewerConfiguration();
    }

    public void setCurrentEditEvents(List<DocumentEvent> currentEditEvents) {
        this.currentEditEvents = currentEditEvents;
    }

    public List<DocumentEvent> getCurrentEditEvents() {
        return this.currentEditEvents;
    }

    public abstract IRfNamedElementAndScope getCursorElementNonUi(int var1);

    public abstract boolean isInsertSpaces(IPreferenceStore var1);

    public static class OverrideIndicator
    extends Annotation {
        public static final String ANNOTATION_TYPE = "ro.amiq.dvt.OverrideIndicator";
        public static final int OVERRIDES_KIND = 0;
        public static final int IMPLEMENTS_KIND = 1;
        public static final int SHADOWS_KIND = 2;
        public static final int EXTENDS_KIND = 3;
        public static final int FACTORY_OVERRIDES_KIND = 4;
        public static final String OVERRIDES_PREFIX = "overrides ";
        public static final String EXTENDS_PREFIX = "extends ";
        public static final String IMPLEMENTS_PREFIX = "implements ";
        public static final String SHADOWS_PREFIX = "shadows ";
        public static final String FACTORY_OVERRIDES_PREFIX = "factory overrides";
        private int fOverrideKind;
        private int fLine;
        private IRfFileDef fFileDef;
        private String fDefaultEditorID;

        public OverrideIndicator(int overrideKind, String text, IRfFileDef fileDef, int line, String defaultEditorID) {
            super(ANNOTATION_TYPE, false, text);
            this.fOverrideKind = overrideKind;
            this.fFileDef = fileDef;
            this.fDefaultEditorID = defaultEditorID;
            this.fLine = line;
        }

        public int getOverrideKind() {
            return this.fOverrideKind;
        }

        public void open() {
            if (this.fFileDef != null) {
                IResource resource = (IResource)this.fFileDef.getAdapter(IResource.class);
                if (resource != null && resource.exists() && resource.getLocation() != null) {
                    DVTFileUtils.getInstance().openEditor(resource.getLocation().toFile(), this.fLine, this.fDefaultEditorID);
                } else {
                    ParserPath parserPath = this.fFileDef.getParserPath();
                    if (parserPath != null && parserPath.path != null) {
                        DVTFileUtils.getInstance().openEditor(new File(this.fFileDef.getParserPath().path), this.fLine, this.fDefaultEditorID);
                    }
                }
            }
        }

        public String getOverrideKindName() {
            switch (this.fOverrideKind) {
                case 0: {
                    return "OVERRIDES_KIND";
                }
                case 1: {
                    return "IMPLEMENTS_KIND";
                }
                case 2: {
                    return "SHADOWS_KIND";
                }
                case 3: {
                    return "EXTENDS_KIND";
                }
                case 4: {
                    return "FACTORY_OVERRIDES_KIND";
                }
            }
            return "N/A";
        }
    }
}

