/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTProcessRunner;

public class DVTExternalToolFormatter {
    private static final String JOB_NAME = "Format Using External Program";

    public static void format(final ITextEditor editor, final String command) {
        Job formatJob = new Job(JOB_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                File tempFile;
                String selectedText;
                monitor.beginTask(DVTExternalToolFormatter.JOB_NAME, -1);
                IDocument document = DVTFileUtils.getInstance().getDocument(editor);
                if (document == null) {
                    return new Status(4, "ro.amiq.dvt", "Format Using External Program: Internal error occurred.");
                }
                String textToFormat = document.get();
                int offset = 0;
                int length = document.getLength();
                ITextSelection selection = DVTExternalToolFormatter.getTextSelection(editor);
                boolean keepSelection = false;
                if (selection != null && !(selectedText = selection.getText()).isEmpty()) {
                    textToFormat = selectedText;
                    offset = selection.getOffset();
                    length = selection.getLength();
                    keepSelection = true;
                }
                try {
                    tempFile = File.createTempFile("DvtFormatSource", null);
                    tempFile.deleteOnExit();
                    Throwable throwable = null;
                    Object var10_12 = null;
                    try (BufferedWriter out = new BufferedWriter(new FileWriter(tempFile));){
                        out.write(textToFormat);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e1) {
                    return new Status(4, "ro.amiq.dvt", "Format Using External Program: " + e1.getMessage());
                }
                DVTProcessRunner processRunner = new DVTProcessRunner(command.replaceAll("%f", tempFile.getAbsolutePath()));
                try {
                    processRunner.run(monitor);
                }
                catch (IOException iOException) {
                    return new Status(4, "ro.amiq.dvt", "Could not execute: " + processRunner.getCommandLine());
                }
                if (processRunner.getExitValue() != 0) {
                    return new Status(4, "ro.amiq.dvt", "External program terminated with error: " + processRunner.getErrorOutput());
                }
                String formatted = DVTFileUtils.getInstance().readFileContent(tempFile);
                DVTExternalToolFormatter.replaceInDocument(document, offset, length, formatted);
                if (keepSelection) {
                    DVTExternalToolFormatter.setSelectionInDocument(editor, offset, formatted.length());
                }
                return Status.OK_STATUS;
            }
        };
        formatJob.setUser(true);
        formatJob.schedule();
    }

    private static void replaceInDocument(final IDocument document, final int offset, final int length, final String text) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DocumentRewriteSession rewriteSession = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
                    document.replace(offset, length, text);
                    ((IDocumentExtension4)document).stopRewriteSession(rewriteSession);
                }
                catch (BadLocationException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    private static ITextSelection getTextSelection(final ITextEditor editor) {
        final ISelection[] selection = new ISelection[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                selection[0] = editor.getSelectionProvider().getSelection();
            }
        });
        if (selection[0] instanceof ITextSelection) {
            return (ITextSelection)selection[0];
        }
        return null;
    }

    private static void setSelectionInDocument(final ITextEditor editor, final int offset, final int length) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                editor.getSelectionProvider().setSelection((ISelection)new TextSelection(offset, length));
            }
        });
    }
}

