/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.source.Annotation;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.IDVTFoldingPosition;

public class DVTFoldingPosition
extends DVTPosition
implements IDVTFoldingPosition {
    public static final Object ELSEIF = new Object();
    private static Map<String, TypeSubType> wordMap = new HashMap<String, TypeSubType>(){
        {
            this.put("begin", new TypeSubType(Type.BEGIN, SubType.START));
            this.put("end", new TypeSubType(Type.BEGIN, SubType.END));
            this.put("module", new TypeSubType(Type.MODULE, SubType.START));
            this.put("macromodule", new TypeSubType(Type.MODULE, SubType.START));
            this.put("connectmodule", new TypeSubType(Type.MODULE, SubType.START));
            this.put("endmodule", new TypeSubType(Type.MODULE, SubType.END));
            this.put("endconnectmodule", new TypeSubType(Type.MODULE, SubType.END));
            this.put("checker", new TypeSubType(Type.CHECKER, SubType.START));
            this.put("endchecker", new TypeSubType(Type.CHECKER, SubType.END));
            this.put("primitive", new TypeSubType(Type.PRIMITIVE, SubType.START));
            this.put("endprimitive", new TypeSubType(Type.PRIMITIVE, SubType.END));
            this.put("package", new TypeSubType(Type.PACKAGE, SubType.START));
            this.put("endpackage", new TypeSubType(Type.PACKAGE, SubType.END));
            this.put("function", new TypeSubType(Type.FUNCTION, SubType.START));
            this.put("endfunction", new TypeSubType(Type.FUNCTION, SubType.END));
            this.put("task", new TypeSubType(Type.TASK, SubType.START));
            this.put("endtask", new TypeSubType(Type.TASK, SubType.END));
            this.put("class", new TypeSubType(Type.CLASS, SubType.START));
            this.put("endclass", new TypeSubType(Type.CLASS, SubType.END));
            this.put("property", new TypeSubType(Type.PROPERTY, SubType.START));
            this.put("endproperty", new TypeSubType(Type.PROPERTY, SubType.END));
            this.put("generate", new TypeSubType(Type.GENERATE, SubType.START));
            this.put("endgenerate", new TypeSubType(Type.GENERATE, SubType.END));
            this.put("specify", new TypeSubType(Type.SPECIFY, SubType.START));
            this.put("endspecify", new TypeSubType(Type.SPECIFY, SubType.END));
            this.put("clocking", new TypeSubType(Type.CLOCKING, SubType.START));
            this.put("endclocking", new TypeSubType(Type.CLOCKING, SubType.END));
            this.put("config", new TypeSubType(Type.CONFIG, SubType.START));
            this.put("endconfig", new TypeSubType(Type.CONFIG, SubType.END));
            this.put("table", new TypeSubType(Type.TABLE, SubType.START));
            this.put("endtable", new TypeSubType(Type.TABLE, SubType.END));
            this.put("program", new TypeSubType(Type.PROGRAM, SubType.START));
            this.put("endprogram", new TypeSubType(Type.PROGRAM, SubType.END));
            this.put("interface", new TypeSubType(Type.INTERFACE, SubType.START));
            this.put("endinterface", new TypeSubType(Type.INTERFACE, SubType.END));
            this.put("case", new TypeSubType(Type.CASE, SubType.START));
            this.put("casez", new TypeSubType(Type.CASE, SubType.START));
            this.put("casex", new TypeSubType(Type.CASE, SubType.START));
            this.put("randcase", new TypeSubType(Type.CASE, SubType.START));
            this.put("endcase", new TypeSubType(Type.CASE, SubType.END));
            this.put("covergroup", new TypeSubType(Type.GROUP, SubType.START));
            this.put("endgroup", new TypeSubType(Type.GROUP, SubType.END));
            this.put("sequence", new TypeSubType(Type.SEQUENCE, SubType.START));
            this.put("randsequence", new TypeSubType(Type.SEQUENCE, SubType.START));
            this.put("endsequence", new TypeSubType(Type.SEQUENCE, SubType.END));
            this.put("fork", new TypeSubType(Type.FORK, SubType.START));
            this.put("join_none", new TypeSubType(Type.FORK, SubType.END));
            this.put("join_any", new TypeSubType(Type.FORK, SubType.END));
            this.put("join", new TypeSubType(Type.FORK, SubType.END));
            this.put("component", new TypeSubType(Type.COMPONENT, null));
            this.put("if", new TypeSubType(Type.IF, null));
            this.put("loop", new TypeSubType(Type.LOOP, null));
            this.put("process", new TypeSubType(Type.PROCESS, null));
            this.put("architecture", new TypeSubType(Type.ARCHITECTURE, null));
            this.put("record", new TypeSubType(Type.RECORD, null));
            this.put("block", new TypeSubType(Type.BLOCK, null));
            this.put("configuration", new TypeSubType(Type.CONFIGURATION, null));
            this.put("protected", new TypeSubType(Type.PROTECTED, null));
            this.put("for", new TypeSubType(Type.FOR, null));
            this.put("procedure", new TypeSubType(Type.PROCEDURE, null));
            this.put("entity", new TypeSubType(Type.ENTITY, null));
            this.put("type", new TypeSubType(Type.TYPE, null));
            this.put("when", new TypeSubType(Type.WHEN, null));
        }

        @Override
        public TypeSubType get(Object key) {
            TypeSubType result = (TypeSubType)super.get(key);
            if (result == null) {
                return TypeSubType.NULL;
            }
            return result;
        }
    };
    private static Map<Character, TypeSubType> charMap = new HashMap<Character, TypeSubType>(){
        {
            this.put(Character.valueOf('{'), new TypeSubType(Type.CURLY, SubType.START));
            this.put(Character.valueOf('}'), new TypeSubType(Type.CURLY, SubType.END));
            this.put(Character.valueOf('('), new TypeSubType(Type.PAREN, SubType.START));
            this.put(Character.valueOf(')'), new TypeSubType(Type.PAREN, SubType.END));
        }

        @Override
        public TypeSubType get(Object key) {
            TypeSubType result = (TypeSubType)super.get(key);
            if (result == null) {
                return TypeSubType.NULL;
            }
            return result;
        }
    };
    private Type type;
    private SubType subType;
    private Annotation annotation;
    private Object meta;

    public DVTFoldingPosition(int offset, int length, Type type, SubType subType, Object meta) {
        super(offset, length);
        this.type = type;
        this.subType = subType;
        this.meta = meta;
    }

    public DVTFoldingPosition(int offset, int length, Type type, SubType subType) {
        this(offset, length, type, subType, null);
    }

    public DVTFoldingPosition(int offset, int length, char c) {
        this(offset, length, DVTFoldingPosition.charMap.get((Object)Character.valueOf((char)c)).type, DVTFoldingPosition.charMap.get((Object)Character.valueOf((char)c)).subType, null);
    }

    public DVTFoldingPosition(int offset, int length, String word) {
        this(offset, length, DVTFoldingPosition.wordMap.get((Object)word).type, DVTFoldingPosition.wordMap.get((Object)word).subType, null);
    }

    public DVTFoldingPosition(int offset, int length, String word, SubType subType) {
        this(offset, length, DVTFoldingPosition.wordMap.get((Object)word).type, subType, null);
    }

    @Override
    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    public void setMeta(Object meta) {
        this.meta = meta;
    }

    public Object getMeta() {
        return this.meta;
    }

    @Override
    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Type getType() {
        return this.type;
    }

    public SubType getSubType() {
        return this.subType;
    }

    @Override
    public int compareTo(IDVTFoldingPosition epos) {
        if (epos.getOffset() > this.offset) {
            return -1;
        }
        if (epos.getOffset() < this.offset) {
            return 1;
        }
        return 0;
    }

    public boolean includes(int rangeOffset, int rangeLength) {
        return this.offset <= rangeOffset && this.offset + this.length >= rangeOffset + rangeLength;
    }

    public boolean isIncludedBy(int rangeOffset, int rangeLength) {
        return rangeOffset <= this.offset && rangeOffset + rangeLength >= this.offset + this.length;
    }

    public String toString() {
        return "[" + (Object)((Object)this.subType) + " " + (Object)((Object)this.type) + "] " + super.toString();
    }

    public static enum SubType {
        START,
        END,
        ORIGINAL,
        NULL;

    }

    public static enum Type {
        USERDEF_BRACKET,
        USERDEF_REGION,
        AUTO,
        MACRO_EXPANSION,
        IFDEF,
        CURLY,
        PAREN,
        BEGIN,
        MODULE,
        CHECKER,
        PRIMITIVE,
        PACKAGE,
        FUNCTION,
        TASK,
        CLASS,
        PROPERTY,
        GENERATE,
        SPECIFY,
        CLOCKING,
        CONFIG,
        TABLE,
        PROGRAM,
        INTERFACE,
        CASE,
        GROUP,
        SEQUENCE,
        FORK,
        COMPONENT,
        IF,
        LOOP,
        PROCESS,
        ARCHITECTURE,
        RECORD,
        BLOCK,
        CONFIGURATION,
        PROTECTED,
        PROCEDURE,
        ENTITY,
        TYPE,
        FOR,
        WHEN,
        NULL;

    }

    private static class TypeSubType {
        public static final TypeSubType NULL = new TypeSubType(Type.NULL, SubType.NULL);
        Type type;
        SubType subType;

        public TypeSubType(Type type, SubType subType) {
            this.type = type;
            this.subType = subType;
        }
    }
}

