/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.IAnnotationImageProvider;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditorCommon;

public class DVTOverrideImageProvider
implements IAnnotationImageProvider {
    private static final String OVERRIDE_IMG_DESC_ID = "DVTImages.DESC_OBJ_OVERRIDES";
    private static final String IMPLEMENTS_IMG_DESC_ID = "DVTImages.DESC_OBJ_IMPLEMENTS";
    private static final String SHADOWS_IMG_DESC_ID = "DVTImages.DESC_OBJ_SHADOWS";
    private static final String EXTENDS_IMG_DESC_ID = "DVTImages.DESC_OBJ_EXTENDS";
    private static final String FACTORY_OVERRIDE_IMG_DESC_ID = "DVTImages.DESC_OBJ_FACTORY_OVERRIDES";

    public Image getManagedImage(Annotation annotation) {
        return null;
    }

    public String getImageDescriptorId(Annotation annotation) {
        if (!this.isImageProviderFor(annotation)) {
            return null;
        }
        int kind = this.getOverrideKind(annotation);
        switch (kind) {
            case 0: {
                return OVERRIDE_IMG_DESC_ID;
            }
            case 1: {
                return IMPLEMENTS_IMG_DESC_ID;
            }
            case 3: {
                return EXTENDS_IMG_DESC_ID;
            }
            case 4: {
                return FACTORY_OVERRIDE_IMG_DESC_ID;
            }
        }
        return SHADOWS_IMG_DESC_ID;
    }

    public ImageDescriptor getImageDescriptor(String imageDescritporId) {
        switch (imageDescritporId) {
            case "DVTImages.DESC_OBJ_IMPLEMENTS": {
                return DVTImages.DESC_OBJ_IMPLEMENTS;
            }
            case "DVTImages.DESC_OBJ_OVERRIDES": {
                return DVTImages.DESC_OBJ_OVERRIDES;
            }
            case "DVTImages.DESC_OBJ_SHADOWS": {
                return DVTImages.DESC_OBJ_SHADOWS;
            }
            case "DVTImages.DESC_OBJ_EXTENDS": {
                return DVTImages.DESC_OBJ_EXTENDS;
            }
            case "DVTImages.DESC_OBJ_FACTORY_OVERRIDES": {
                return DVTImages.DESC_OBJ_FACTORY_OVERRIDES;
            }
        }
        return null;
    }

    private boolean isImageProviderFor(Annotation annotation) {
        return annotation != null && "ro.amiq.dvt.OverrideIndicator".equals(annotation.getType());
    }

    private int getOverrideKind(Annotation annotation) {
        return ((DVTEditorCommon.OverrideIndicator)annotation).getOverrideKind();
    }
}

