/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.util.EnumMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.ui.commands.ICommandService;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTPairMatcherAccessor;
import ro.amiq.dvt.ui.editor.DVTPairMatcherCommon;

public class DVTPairMatcher
extends DVTPairMatcherCommon {
    private static IStateListener fVICommandListener = null;
    private static boolean fVIMode = false;
    private static Map<LanguageKind, DVTPairMatcher> matchers = new EnumMap<LanguageKind, DVTPairMatcher>(LanguageKind.class);

    public static DVTPairMatcher makePairMatcher(LanguageKind language, char[] chars, DVTPairMatcherAccessor acc) {
        DVTPairMatcher matcher = matchers.get((Object)language);
        if (matcher == null) {
            matcher = new DVTPairMatcher(chars, acc);
            matchers.put(language, matcher);
        }
        return matcher;
    }

    private DVTPairMatcher(char[] chars, DVTPairMatcherAccessor acc) {
        this.acc = acc;
        this.fPairs = new DVTPairMatcherCommon.CharPairs(chars);
    }

    @Override
    protected void setDisabled(boolean disabled) {
        this.fDisabled = disabled;
    }

    @Override
    protected boolean isInViMode() {
        if (fVICommandListener == null) {
            fVICommandListener = new IStateListener(){

                public void handleStateChange(State state, Object oldValue) {
                    fVIMode = state.getValue() instanceof Boolean ? (Boolean)state.getValue() : false;
                }
            };
            ICommandService commandService = (ICommandService)Utils.getActiveWorkbenchWindow().getService(ICommandService.class);
            Command command = commandService.getCommand("com.mbartl.viplugineclipse.LoadViAction");
            if (command == null) {
                return false;
            }
            State state = command.getState("org.eclipse.ui.commands.toggleState");
            if (state == null) {
                return false;
            }
            state.addListener(fVICommandListener);
            fVICommandListener.handleStateChange(state, null);
        }
        return fVIMode;
    }

    @Override
    public void dispose() {
        this.clear();
    }

    @Override
    public void clear() {
        this.fDocument = null;
        this.fOffset = 0;
        this.fOrbit = -1;
        this.fAnchor = -1;
        this.acc.clear();
    }
}

