/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DVTPairMatcherAccessor {
    protected String fContentType;
    protected ITypedRegion fCachedPartition;
    protected IDocument fDocument;
    protected String fPartitioning;
    protected String fDefaultContentType;

    public void init(IDocument document, int offset) {
        if (document == null) {
            this.clear();
            return;
        }
        this.fDocument = document;
        ITypedRegion partition = this.getPartition(offset);
        if (partition == null) {
            this.fContentType = this.fDefaultContentType;
            return;
        }
        this.fContentType = partition.getType();
        this.fCachedPartition = null;
    }

    protected boolean isSamePartition(ITypedRegion offsetPartition) {
        if (offsetPartition == null || this.fContentType == null) {
            return false;
        }
        return this.fContentType.equals(offsetPartition.getType());
    }

    public int getNextPosition(int offset, boolean searchForward) {
        ITypedRegion partition = this.getPartition(offset);
        if (partition == null || this.isSamePartition(partition)) {
            return this.simpleIncrement(offset, searchForward);
        }
        if (searchForward) {
            int endPartition = partition.getOffset() + partition.getLength();
            if (offset < endPartition) {
                return endPartition;
            }
        } else {
            int startPartition = partition.getOffset();
            if (offset > startPartition) {
                return startPartition - 1;
            }
        }
        return this.simpleIncrement(offset, searchForward);
    }

    protected ITypedRegion getPartition(int offset) {
        if (this.fDocument == null || this.fPartitioning == null) {
            return null;
        }
        if (this.fCachedPartition == null || !DVTPairMatcherAccessor.contains((IRegion)this.fCachedPartition, offset)) {
            try {
                this.fCachedPartition = this.fDocument instanceof IDocumentExtension3 ? ((IDocumentExtension3)this.fDocument).getPartition(this.fPartitioning, offset, false) : this.fDocument.getPartition(offset);
            }
            catch (Exception exception) {
                this.fCachedPartition = null;
            }
        }
        return this.fCachedPartition;
    }

    public boolean inPartition(int offset) {
        return this.isSamePartition(this.getPartition(offset));
    }

    protected int simpleIncrement(int offset, boolean searchForward) {
        return offset + (searchForward ? 1 : -1);
    }

    public boolean isMatch(char c, int offset, char end) {
        if (this.fDocument == null) {
            return false;
        }
        try {
            return c == end && this.inPartition(offset);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public void clear() {
        this.fContentType = null;
        this.fCachedPartition = null;
        this.fDocument = null;
    }

    protected static boolean contains(IRegion region, int pos) {
        int offset = region.getOffset();
        return offset <= pos && pos < offset + region.getLength();
    }
}

