/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTPairMatcherAccessor;
import ro.amiq.dvt.ui.editor.TextUtils;

public abstract class DVTPairMatcherCommon
implements ICharacterPairMatcher {
    protected DVTPairMatcherAccessor acc;
    protected CharPairs fPairs;
    protected IDocument fDocument;
    protected int fOffset;
    protected int fOrbit = -1;
    protected int fAnchor = -1;
    protected boolean fDisabled = false;

    public IRegion match(IDocument document, int offset) {
        if (this.fDisabled) {
            return null;
        }
        if (document == null) {
            return null;
        }
        if (offset < 0) {
            return null;
        }
        this.fDocument = document;
        this.fOffset = offset;
        this.setOrbit();
        if (this.fOrbit == -1) {
            return null;
        }
        int contentOffset = this.fOrbit == 1 ? Math.max(this.fOffset - 1, 0) : this.fOffset;
        this.acc.init(document, contentOffset);
        return this.matchPairs();
    }

    private void setOrbit() {
        try {
            char prevChar = this.getChar(this.fDocument, this.fOffset - 1);
            char currChar = this.getChar(this.fDocument, this.fOffset);
            boolean isPrevPair = this.fPairs.contains(prevChar);
            boolean isCurrPair = this.fPairs.contains(currChar);
            this.fOrbit = 1;
            if (!isPrevPair && isCurrPair) {
                this.fOrbit = 0;
            }
            if (isPrevPair && isCurrPair && this.fPairs.isEndCharacter(prevChar) && this.fPairs.isEndCharacter(currChar)) {
                this.fOrbit = 0;
            }
            if (!isPrevPair && !isCurrPair) {
                this.fOrbit = -1;
            }
            if (this.isInViMode() && isPrevPair && isCurrPair) {
                this.fOrbit = 0;
            }
        }
        catch (Exception ex) {
            this.fOrbit = -1;
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
    }

    private int directionOffset() {
        try {
            int direction;
            int n = direction = this.fPairs.isStartCharacter(this.getStartingChar()) ? 1 : -1;
            if (this.fOrbit == 1) {
                --direction;
            }
            return Math.max(0, Math.min(this.fOffset + direction, this.fDocument.getLength()));
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return -1;
        }
    }

    private IRegion matchPairs() {
        int adjustedEndOffset;
        int adjustedOffset;
        block7: {
            int pairOffset;
            boolean isForward;
            block6: {
                int directionOffset;
                char c;
                block5: {
                    try {
                        c = this.getStartingChar();
                        directionOffset = this.directionOffset();
                        if (directionOffset != -1) break block5;
                        return null;
                    }
                    catch (Exception ex) {
                        DVTLogger.INSTANCE.logError((Throwable)ex);
                        return null;
                    }
                }
                isForward = directionOffset - this.fOffset >= 0;
                pairOffset = this.findMatchingPeer(c, this.fPairs.getMatching(c), isForward, isForward ? this.fDocument.getLength() : -1, directionOffset);
                if (pairOffset != -1) break block6;
                return null;
            }
            int n = this.fAnchor = isForward ? 1 : 0;
            int n2 = !isForward ? pairOffset : (adjustedOffset = this.fOrbit == 1 ? Math.max(this.fOffset - 1, 0) : this.fOffset);
            int n3 = !isForward ? (this.fOrbit == 1 ? this.fOffset : this.fOffset + 1) : (adjustedEndOffset = pairOffset + 1);
            if (adjustedEndOffset != adjustedOffset) break block7;
            return null;
        }
        return new Region(Math.min(adjustedOffset, adjustedEndOffset), Math.abs(adjustedEndOffset - adjustedOffset));
    }

    private int findMatchingPeer(char start, char end, boolean searchForward, int boundary, int startPos) throws BadLocationException {
        int pos = startPos;
        while (pos != boundary) {
            char c = this.getChar(this.fDocument, pos);
            if (this.acc.isMatch(c, pos, end)) {
                return pos;
            }
            if (c == start && this.acc.inPartition(pos) && (pos = this.findMatchingPeer(start, end, searchForward, boundary, this.acc.getNextPosition(pos, searchForward))) == -1) {
                return -1;
            }
            pos = this.acc.getNextPosition(pos, searchForward);
        }
        return -1;
    }

    private char getStartingChar() {
        try {
            return this.fOrbit == 1 ? this.getChar(this.fDocument, this.fOffset - 1) : this.getChar(this.fDocument, this.fOffset);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return '\u0000';
        }
    }

    public int getAnchor() {
        return this.fAnchor;
    }

    private char getChar(IDocument doc, int offset) {
        return TextUtils.getChar(doc, offset);
    }

    public void dispose() {
    }

    public void clear() {
    }

    protected abstract void setDisabled(boolean var1);

    protected abstract boolean isInViMode();

    protected static class CharPairs {
        private final char[] fPairs;

        public CharPairs(char[] pairs) {
            this.fPairs = pairs;
        }

        public boolean contains(char c) {
            char[] pairs = this.fPairs;
            int i = 0;
            int n = pairs.length;
            while (i < n) {
                if (c == pairs[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean isOpeningCharacter(char c, boolean searchForward) {
            int i = 0;
            while (i < this.fPairs.length) {
                if (searchForward && this.getStartChar(i) == c) {
                    return true;
                }
                if (!searchForward && this.getEndChar(i) == c) {
                    return true;
                }
                i += 2;
            }
            return false;
        }

        public boolean isStartCharacter(char c) {
            return this.isOpeningCharacter(c, true);
        }

        public boolean isEndCharacter(char c) {
            return this.isOpeningCharacter(c, false);
        }

        public char getMatching(char c) {
            int i = 0;
            while (i < this.fPairs.length) {
                if (this.getStartChar(i) == c) {
                    return this.getEndChar(i);
                }
                if (this.getEndChar(i) == c) {
                    return this.getStartChar(i);
                }
                i += 2;
            }
            Assert.isTrue((boolean)false);
            return '\u0000';
        }

        private char getStartChar(int i) {
            return this.fPairs[i];
        }

        private char getEndChar(int i) {
            return this.fPairs[i + 1];
        }
    }
}

