/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.Position;

public class DVTPositionUpdater
extends DefaultPositionUpdater {
    private final String fCategory;

    public DVTPositionUpdater(String category) {
        super(category);
        this.fCategory = category;
    }

    public void update(DocumentEvent event) {
        DocumentRewriteSession activeRewriteSession;
        IDocument document = event.getDocument();
        if (document instanceof IDocumentExtension4 && (activeRewriteSession = ((IDocumentExtension4)document).getActiveRewriteSession()) != null && document.getNumberOfLines() > 15000) {
            return;
        }
        try {
            try {
                this.fOffset = event.getOffset();
                this.fLength = event.getLength();
                this.fReplaceLength = event.getText() == null ? 0 : event.getText().length();
                this.fDocument = document;
                Position[] category = this.fDocument.getPositions(this.fCategory);
                int i = 0;
                while (i < category.length) {
                    this.fPosition = category[i];
                    this.fOriginalPosition.offset = this.fPosition.offset;
                    this.fOriginalPosition.length = this.fPosition.length;
                    int adjustedLength = this.fPosition.length - 1;
                    if (this.fPosition.offset <= this.fOffset && this.fPosition.offset < this.fOffset + this.fLength && this.fOffset + this.fLength < this.fPosition.offset + adjustedLength) {
                        this.fPosition.length += this.fReplaceLength - this.fLength;
                    } else if (this.fPosition.offset <= this.fOffset && this.fOffset < this.fPosition.offset + adjustedLength && this.fOffset + this.fLength > this.fPosition.offset + adjustedLength) {
                        if (this.fOffset + this.fReplaceLength < this.fPosition.offset + adjustedLength) {
                            this.fPosition.length = this.fOffset + this.fReplaceLength - this.fPosition.offset;
                        }
                    } else if (this.fOffset < this.fPosition.offset && this.fPosition.offset < this.fOffset + this.fLength && this.fOffset + this.fLength < this.fPosition.offset + adjustedLength) {
                        if (this.fOffset + this.fReplaceLength < this.fPosition.offset) {
                            this.fPosition.delete();
                            try {
                                this.fDocument.removePosition(this.fCategory, this.fPosition);
                            }
                            catch (BadPositionCategoryException badPositionCategoryException) {}
                        } else {
                            this.fPosition.length += this.fReplaceLength - this.fLength;
                        }
                    } else if (this.fOffset <= this.fPosition.offset && this.fOffset + this.fLength <= this.fPosition.offset) {
                        this.fPosition.offset += this.fReplaceLength - this.fLength;
                    } else if (this.fOffset < this.fPosition.offset && this.fPosition.offset + adjustedLength < this.fOffset + this.fLength) {
                        if (this.fPosition.offset < this.fOffset + this.fReplaceLength && this.fOffset + this.fReplaceLength < this.fPosition.offset + adjustedLength) {
                            this.fPosition.length = this.fOffset + this.fReplaceLength - this.fPosition.offset;
                        } else if (this.fOffset + this.fReplaceLength < this.fPosition.offset) {
                            this.fPosition.delete();
                            try {
                                this.fDocument.removePosition(this.fCategory, this.fPosition);
                            }
                            catch (BadPositionCategoryException badPositionCategoryException) {}
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                this.fDocument = null;
            }
        }
        finally {
            this.fDocument = null;
        }
    }
}

