/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCustomFoldingPosition;
import ro.amiq.dvt.ui.editor.DVTFoldingPosition;
import ro.amiq.dvt.ui.editor.DVTPresentationReconcilerCommon;
import ro.amiq.dvt.ui.editor.IDVTFoldingPosition;

public class DVTPresentationReconciler
extends DVTPresentationReconcilerCommon {
    private ProjectionAnnotationModel fAnnotationModel;
    private UpdateFoldingStructureJob fUpdater = new UpdateFoldingStructureJob();

    public void setProjectionAnnotationModel(ProjectionAnnotationModel annotationModel) {
        this.fAnnotationModel = annotationModel;
        this.computeFoldingRegions(this.fViewer, this.fAnnotationModel);
    }

    @Override
    public void install(ITextViewer viewer) {
        super.install(viewer);
        this.fViewer = viewer;
    }

    @Override
    public void uninstall() {
        super.uninstall();
        this.fViewer = null;
        this.fAnnotationModel = null;
    }

    @Override
    protected TextPresentation createPresentation(IRegion damage, IDocument document) {
        TextPresentation result = super.createPresentation(damage, document);
        this.computeFoldingRegions(this.fViewer, this.fAnnotationModel);
        return result;
    }

    public void expandFirst(ProjectionAnnotationModel model) {
        if (model == null) {
            return;
        }
        Object level1 = null;
        Object[] positions = this.getAllAnnotationPositions(model);
        Arrays.sort(positions);
        int i = 0;
        while (i < positions.length) {
            Object position = positions[i];
            ProjectionAnnotation annotation = (ProjectionAnnotation)position.getAnnotation();
            if (level1 == null || !level1.includes(position.getOffset())) {
                level1 = position;
                if (annotation.isCollapsed()) {
                    model.expand((Annotation)annotation);
                }
            } else if (!annotation.isCollapsed()) {
                model.collapse((Annotation)annotation);
            }
            ++i;
        }
    }

    public void showActivePreprocessing(IDocument document, ProjectionAnnotationModel model) {
        try {
            if (model == null) {
                return;
            }
            List<DVTFoldingPosition> dvtPositions = this.getAnnotationsPosition(model);
            Collections.sort(dvtPositions);
            if (!document.containsPositionCategory("__dvt_inactive_code_position")) {
                return;
            }
            List<Position> inactivePositions = Arrays.asList(document.getPositions("__dvt_inactive_code_position"));
            Iterator<Position> inactivePositionsIterator = inactivePositions.iterator();
            if (!inactivePositionsIterator.hasNext()) {
                return;
            }
            Position inactivePosition = inactivePositionsIterator.next();
            for (DVTFoldingPosition dvtPosition : dvtPositions) {
                model.expand(dvtPosition.getAnnotation());
                while (dvtPosition.offset > inactivePosition.getOffset() + inactivePosition.getLength()) {
                    if (inactivePositionsIterator.hasNext()) {
                        inactivePosition = inactivePositionsIterator.next();
                        continue;
                    }
                    return;
                }
                if (dvtPosition.offset < inactivePosition.offset || dvtPosition.offset + 1 >= inactivePosition.offset + inactivePosition.length) continue;
                model.collapse(dvtPosition.getAnnotation());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void toggleAtOffset(ProjectionAnnotationModel model, IDocument document, int offset) {
        if (model == null) {
            return;
        }
        Object[] allPositions = this.getAllAnnotationPositions(model);
        Arrays.sort(allPositions);
        int i = 0;
        while (i < allPositions.length) {
            Object position = allPositions[i];
            try {
                if (document.getLineOfOffset(offset) == document.getLineOfOffset(position.getOffset())) {
                    ProjectionAnnotation annotation = (ProjectionAnnotation)position.getAnnotation();
                    if (!annotation.isCollapsed()) {
                        model.collapse((Annotation)annotation);
                        break;
                    }
                    if (!annotation.isCollapsed()) break;
                    model.expand((Annotation)annotation);
                    break;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            ++i;
        }
    }

    private IDVTFoldingPosition[] getAllAnnotationPositions(ProjectionAnnotationModel model) {
        List<IDVTFoldingPosition> customAnnotationsPositions;
        ArrayList<IDVTFoldingPosition> result = new ArrayList<IDVTFoldingPosition>();
        List<DVTFoldingPosition> dvtAnnotationsPositions = this.getAnnotationsPosition(model);
        if (dvtAnnotationsPositions != null) {
            result.addAll(dvtAnnotationsPositions);
        }
        if ((customAnnotationsPositions = this.getCustomFoldingPositions(model)) != null) {
            result.addAll(customAnnotationsPositions);
        }
        return result.toArray(new IDVTFoldingPosition[result.size()]);
    }

    private List<IDVTFoldingPosition> getCustomFoldingPositions(ProjectionAnnotationModel model) {
        ArrayList<IDVTFoldingPosition> positions = new ArrayList<IDVTFoldingPosition>();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Position position;
            Object annotation = e.next();
            if (!(annotation instanceof ProjectionAnnotation) || !((position = model.getPosition((Annotation)((ProjectionAnnotation)annotation))) instanceof DVTCustomFoldingPosition)) continue;
            ((DVTCustomFoldingPosition)position).setAnnotation((Annotation)((ProjectionAnnotation)annotation));
            positions.add((DVTCustomFoldingPosition)position);
        }
        return positions;
    }

    public void expandAllInScope(ProjectionAnnotationModel model, IDocument document, Position scopePosition) {
        if (model == null || scopePosition == null) {
            return;
        }
        model.expandAll(scopePosition.getOffset(), scopePosition.getLength());
    }

    private void computeFoldingRegions(ITextViewer viewer, ProjectionAnnotationModel model) {
        if (this.fNofLinesFolding == 0 || System.getProperty("ro.amiq.dvt.ui.editor.disableFolding") != null) {
            return;
        }
        if (model == null) {
            return;
        }
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        if (document == null) {
            return;
        }
        this.computeFoldingRegions(document, model);
    }

    @Override
    protected void updateAnnotations(ProjectionAnnotationModel model, ProjectionAnnotation[] deletions, HashMap<ProjectionAnnotation, DVTFoldingPosition> aditions) {
        this.fUpdater.setUpdateAnnotations(model, deletions, aditions);
        this.fUpdater.schedule(250L);
    }

    static class UpdateFoldingStructureJob
    extends UIJob {
        private ProjectionAnnotation[] fDeletions;
        private HashMap<ProjectionAnnotation, DVTFoldingPosition> fAditions;
        private ProjectionAnnotationModel fModel;

        public UpdateFoldingStructureJob() {
            super("Update Folding Structure");
            this.setPriority(50);
            this.setSystem(true);
        }

        public void setUpdateAnnotations(ProjectionAnnotationModel model, ProjectionAnnotation[] deletions, HashMap<ProjectionAnnotation, DVTFoldingPosition> aditions) {
            this.fDeletions = deletions;
            this.fAditions = aditions;
            this.fModel = model;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                this.fModel.replaceAnnotations((Annotation[])this.fDeletions, this.fAditions);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

