/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTFoldingPosition;
import ro.amiq.dvt.ui.editor.PresentationReconciler;

public abstract class DVTPresentationReconcilerCommon
extends PresentationReconciler {
    @Deprecated
    public static final String DISABLE_FOLDING_PROPERTY = "ro.amiq.dvt.ui.editor.disableFolding";
    public static final String FOLDING_POSITION = "__dvt_folding_position";
    public static final String MACRO_POSITION = "__dvt_macro_position";
    protected int fNofLinesFolding = 10000;

    public void setNofLinesFolding(int nofLines) {
        this.fNofLinesFolding = nofLines;
    }

    public void computeFoldingRegions(IDocument document, ProjectionAnnotationModel model) {
        if (document == null) {
            return;
        }
        int documentLength = document.getLength();
        if (document instanceof IDocumentExtension4 && ((IDocumentExtension4)document).getActiveRewriteSession() != null) {
            return;
        }
        if (document.getNumberOfLines() >= this.fNofLinesFolding) {
            return;
        }
        try {
            if (!document.containsPositionCategory(FOLDING_POSITION)) {
                return;
            }
            FoldingStack foldingStack = new FoldingStack(document, this.getAnnotationsPosition(model));
            Position[] positionArray = document.getPositions(FOLDING_POSITION);
            int n = positionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Position p = positionArray[n2];
                if (p instanceof DVTFoldingPosition && !p.isDeleted && documentLength > p.getOffset()) {
                    foldingStack.process((DVTFoldingPosition)p);
                }
                ++n2;
            }
            this.updateFoldingStructure(foldingStack.getDeletions(), foldingStack.getInsertions(), model);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected List<DVTFoldingPosition> getAnnotationsPosition(ProjectionAnnotationModel model) {
        ArrayList<DVTFoldingPosition> positions = new ArrayList<DVTFoldingPosition>();
        if (model == null) {
            return positions;
        }
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Position position;
            Object annotation = e.next();
            if (!(annotation instanceof ProjectionAnnotation) || !((position = model.getPosition((Annotation)((ProjectionAnnotation)annotation))) instanceof DVTFoldingPosition)) continue;
            ((DVTFoldingPosition)position).setAnnotation((Annotation)((ProjectionAnnotation)annotation));
            positions.add((DVTFoldingPosition)position);
        }
        return positions;
    }

    private boolean positionsCross(DVTFoldingPosition p1, DVTFoldingPosition p2) {
        int p1Start = p1.getOffset();
        int p1End = p1Start + p1.getLength();
        int p2Start = p2.getOffset();
        int p2End = p2Start + p2.getLength();
        return p1Start <= p2Start && p1End > p2Start && p1End <= p2End || p1Start >= p2Start && p1Start < p2End && p1End >= p2End;
    }

    private void updateFoldingStructure(List<DVTFoldingPosition> remove, List<DVTFoldingPosition> insert, ProjectionAnnotationModel model) {
        ProjectionAnnotation[] deletions = null;
        HashMap<ProjectionAnnotation, DVTFoldingPosition> aditions = null;
        int removeSize = remove.size();
        int insertSize = insert.size();
        if (removeSize > 0) {
            deletions = new ProjectionAnnotation[removeSize];
        }
        if (insertSize > 0) {
            aditions = new HashMap<ProjectionAnnotation, DVTFoldingPosition>(insertSize);
        }
        int maximumSize = Math.max(removeSize, insertSize);
        int i = 0;
        while (i < maximumSize) {
            if (deletions != null && i < remove.size()) {
                deletions[i] = (ProjectionAnnotation)remove.get(i).getAnnotation();
            }
            if (aditions != null && i < insert.size()) {
                aditions.put(new ProjectionAnnotation(), insert.get(i));
            }
            ++i;
        }
        this.updateAnnotations(model, deletions, aditions);
    }

    protected abstract void updateAnnotations(ProjectionAnnotationModel var1, ProjectionAnnotation[] var2, HashMap<ProjectionAnnotation, DVTFoldingPosition> var3);

    private class FoldingStack {
        private Map<DVTFoldingPosition.Type, Stack<Integer>> foldingStack = new EnumMap<DVTFoldingPosition.Type, Stack<Integer>>(DVTFoldingPosition.Type.class);
        private HashMap<Integer, DVTFoldingPosition> resultByEndLine = new HashMap();
        private HashMap<Integer, DVTFoldingPosition> resultByStartLine = new HashMap();
        private Map<DVTFoldingPosition.Type, List<DVTFoldingPosition>> resultByType = new EnumMap<DVTFoldingPosition.Type, List<DVTFoldingPosition>>(DVTFoldingPosition.Type.class);
        private LinkedHashSet<DVTFoldingPosition> insertions = new LinkedHashSet();
        private IDocument document;
        private LinkedHashSet<DVTFoldingPosition> existingPositions;
        private LinkedHashSet<DVTFoldingPosition> deletions;
        private int nestedCases = 0;
        boolean isFirstWhen;

        public FoldingStack(IDocument document, List<DVTFoldingPosition> existingPositions) {
            this.document = document;
            this.existingPositions = new LinkedHashSet<DVTFoldingPosition>(existingPositions);
            this.deletions = new LinkedHashSet<DVTFoldingPosition>(existingPositions);
        }

        public void process(DVTFoldingPosition currentPosition) throws BadLocationException {
            Stack<Integer> stack = this.foldingStack.get((Object)currentPosition.getType());
            if (stack == null) {
                stack = new Stack();
                this.foldingStack.put(currentPosition.getType(), stack);
            }
            if (currentPosition.getSubType() == DVTFoldingPosition.SubType.START) {
                if (currentPosition.getType() == DVTFoldingPosition.Type.CASE) {
                    ++this.nestedCases;
                    this.isFirstWhen = true;
                } else if (currentPosition.getType() == DVTFoldingPosition.Type.WHEN && this.nestedCases > 0) {
                    if (this.isFirstWhen) {
                        this.isFirstWhen = false;
                    } else if (!stack.isEmpty()) {
                        this.createResult(DVTFoldingPosition.Type.WHEN, stack.pop(), this.document.getLineOfOffset(currentPosition.getOffset()) - 1);
                    }
                }
                stack.push(this.document.getLineOfOffset(currentPosition.getOffset() + 1));
            } else if (currentPosition.getSubType() == DVTFoldingPosition.SubType.END && !stack.isEmpty()) {
                if (currentPosition.getType() == DVTFoldingPosition.Type.CASE) {
                    Stack<Integer> whenStack = this.foldingStack.get((Object)DVTFoldingPosition.Type.WHEN);
                    --this.nestedCases;
                    if (this.nestedCases < 0) {
                        this.nestedCases = 0;
                    }
                    if (whenStack != null && !whenStack.isEmpty()) {
                        this.createResult(DVTFoldingPosition.Type.WHEN, whenStack.pop(), this.document.getLineOfOffset(currentPosition.getOffset()) - 1);
                    }
                }
                this.createResult(currentPosition.getType(), stack.pop(), this.document.getLineOfOffset(currentPosition.getOffset() + 1));
            }
        }

        private void createResult(DVTFoldingPosition.Type type, int startLine, int endLine) throws BadLocationException {
            DVTFoldingPosition existingPosition;
            List<DVTFoldingPosition> userDefined;
            if (startLine == endLine) {
                return;
            }
            int startOffset = this.document.getLineOffset(startLine);
            int endOffset = this.document.getLineOffset(endLine) + this.document.getLineLength(endLine);
            DVTFoldingPosition resultPosition = new DVTFoldingPosition(startOffset, endOffset - startOffset, type, null);
            if (type != DVTFoldingPosition.Type.USERDEF_BRACKET && (userDefined = this.resultByType.get((Object)DVTFoldingPosition.Type.USERDEF_BRACKET)) != null) {
                for (DVTFoldingPosition p : userDefined) {
                    if (!DVTPresentationReconcilerCommon.this.positionsCross(p, resultPosition)) continue;
                    return;
                }
            }
            if (type != DVTFoldingPosition.Type.USERDEF_REGION && (userDefined = this.resultByType.get((Object)DVTFoldingPosition.Type.USERDEF_REGION)) != null) {
                for (DVTFoldingPosition p : userDefined) {
                    if (!DVTPresentationReconcilerCommon.this.positionsCross(p, resultPosition)) continue;
                    return;
                }
            }
            if ((existingPosition = this.resultByStartLine.get(startLine)) != null) {
                if (existingPosition.getType() != DVTFoldingPosition.Type.PAREN) {
                    return;
                }
                int existingPositionEndLine = this.document.getLineOfOffset(existingPosition.length + existingPosition.offset);
                if (existingPositionEndLine > endLine) {
                    return;
                }
                this.resultByEndLine.remove(existingPositionEndLine);
                this.insertions.remove(existingPosition);
            }
            if (this.resultByEndLine.containsKey(startLine)) {
                DVTFoldingPosition overlap = this.resultByEndLine.remove(startLine);
                this.insertions.remove(overlap);
                int newLength = overlap.getLength() - this.document.getLineLength(startLine);
                if (newLength < 0) {
                    newLength = 1;
                }
                overlap.setLength(newLength);
                this.addResult(overlap, this.document.getLineOfOffset(overlap.offset), startLine - 1);
            }
            this.addResult(resultPosition, startLine, endLine);
        }

        private void addResult(DVTFoldingPosition resultPosition, int startLine, int endLine) {
            this.resultByStartLine.put(startLine, resultPosition);
            this.deletions.remove(resultPosition);
            if (!this.existingPositions.contains(resultPosition)) {
                this.insertions.add(resultPosition);
            }
            this.resultByEndLine.put(endLine, resultPosition);
            List<DVTFoldingPosition> positionsByType = this.resultByType.get((Object)resultPosition.getType());
            if (positionsByType == null) {
                positionsByType = new ArrayList<DVTFoldingPosition>();
                this.resultByType.put(resultPosition.getType(), positionsByType);
            }
            positionsByType.add(resultPosition);
        }

        public List<DVTFoldingPosition> getInsertions() {
            return new ArrayList<DVTFoldingPosition>(this.insertions);
        }

        public List<DVTFoldingPosition> getDeletions() {
            return new ArrayList<DVTFoldingPosition>(this.deletions);
        }
    }
}

