/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BlockTextSelection;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.PaintManager;
import org.eclipse.jface.text.TabsToSpacesConverter;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.DVTContentFormatter;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.DVTDocumentCommon;

public class DVTProjectionViewer
extends ProjectionViewer {
    private IAutoEditStrategy fTabsToSpacesConverter;
    private volatile ISelection fCachedSelection;
    private volatile boolean fSelectionChanged = true;
    private DVTEditor fEditor;
    private TabsToSpacesConverter fDetectIndentationTabsToSpacesConverter;

    public DVTProjectionViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles, DVTEditor editor) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
        this.fEditor = editor;
        StyledText textWidget = this.getTextWidget();
        textWidget.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTProjectionViewer.this.fSelectionChanged = true;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DVTProjectionViewer.this.fSelectionChanged = true;
            }
        });
        textWidget.addCaretListener(new CaretListener(){

            public void caretMoved(CaretEvent event) {
                DVTProjectionViewer.this.fSelectionChanged = true;
            }
        });
        textWidget.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                DVTProjectionViewer.this.fSelectionChanged = true;
            }

            public void keyPressed(KeyEvent e) {
                DVTProjectionViewer.this.fSelectionChanged = true;
            }
        });
        textWidget.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                DVTProjectionViewer.this.fSelectionChanged = true;
            }
        });
    }

    public void doOperation(int operation) {
        String autoformatOnPastePref;
        if (operation == 13 || operation == 14) {
            this.hideContextInfo();
            if (operation == 13) {
                this.fContentAssistant.showContextInformation();
            }
        }
        if (operation == 15 && this.fContentFormatter instanceof DVTContentFormatter) {
            ((DVTContentFormatter)this.fContentFormatter).setFormatFromEditor();
        }
        if (operation == 5 && (autoformatOnPastePref = this.getAutoformatOnPastePref()) != null && !autoformatOnPastePref.isEmpty() && !"Disabled".equals(autoformatOnPastePref)) {
            this.formatClipboardContents(autoformatOnPastePref);
        }
        super.doOperation(operation);
    }

    private String getAutoformatOnPastePref() {
        IPreferenceStore store = DVTPlugin.getDefault().getPreferenceStore();
        if (store == null) {
            return null;
        }
        return store.getString("format.format_on_paste");
    }

    private void formatClipboardContents(String autoindentOnPastePref) {
        try {
            String formattedClipboardContents;
            if (this.fEditor == null) {
                return;
            }
            if (autoindentOnPastePref == null) {
                return;
            }
            String codePartition = this.fEditor.getCodePartition();
            if ("__vlog_partitioning".equals(codePartition)) {
                return;
            }
            IDocument document = this.fEditor.getDocument();
            if (document == null) {
                return;
            }
            int currLine = document.getLineOfOffset(this.fEditor.getCursor());
            String currLineIndent = DVTDocumentCommon.getIndentOfLine(document, currLine, -1);
            if (currLineIndent == null) {
                return;
            }
            String clipboardContents = Utils.pasteFromClipboard();
            if (clipboardContents == null) {
                return;
            }
            String EOpenDelimiter = "<'";
            String ECloseDelimiter = "'>";
            if ("__e_partitioning".equals(codePartition)) {
                clipboardContents = String.valueOf(EOpenDelimiter) + clipboardContents + ECloseDelimiter;
            }
            if ((formattedClipboardContents = "Full formatting".equals(autoindentOnPastePref) ? Utils.formatString(() -> this.fEditor.makeSourceViewerConfiguration(), clipboardContents, this.fEditor.getDocument(), currLineIndent, false) : Utils.indentString(() -> this.fEditor.makeSourceViewerConfiguration(), clipboardContents, this.fEditor.getDocument(), currLineIndent, false)) == null) {
                formattedClipboardContents = clipboardContents;
            }
            if ("__e_partitioning".equals(codePartition)) {
                formattedClipboardContents = formattedClipboardContents.substring(EOpenDelimiter.length(), formattedClipboardContents.length() - ECloseDelimiter.length());
            }
            ro.amiq.dvt.utils.Utils.copyToClipboard(this.removeLeadingWS(formattedClipboardContents), 3);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String removeLeadingWS(String content) {
        int i = 0;
        while (i < content.length()) {
            char c = content.charAt(i);
            if (c != ' ' && c != '\t') {
                return content.substring(i);
            }
            ++i;
        }
        return content;
    }

    private void hideContextInfo() {
        try {
            Field proposalPopupField = ContentAssistant.class.getDeclaredField("fContextInfoPopup");
            proposalPopupField.setAccessible(true);
            Object proposalPopup = proposalPopupField.get(this.fContentAssistant);
            if (proposalPopup == null) {
                return;
            }
            Method m = proposalPopup.getClass().getDeclaredMethod("hide", new Class[0]);
            m.setAccessible(true);
            m.invoke(proposalPopup, new Object[0]);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void setTabsToSpacesConverter(IAutoEditStrategy converter) {
        this.fTabsToSpacesConverter = converter;
    }

    protected void customizeDocumentCommand(DocumentCommand command) {
        if (this.isIgnoringAutoEditStrategies()) {
            return;
        }
        boolean pasteCommand = command.text != null && command.text.length() > 1;
        IDocument document = this.getDocument();
        ArrayList strategies = (ArrayList)this.selectContentTypePlugin(command.offset, this.fAutoIndentStrategies);
        if (strategies == null) {
            return;
        }
        switch (strategies.size()) {
            case 0: {
                break;
            }
            case 1: {
                IAutoEditStrategy autoEditStrategy;
                if (this.getTextWidget().getBlockSelection() || (autoEditStrategy = (IAutoEditStrategy)strategies.iterator().next()) == null) break;
                autoEditStrategy.customizeDocumentCommand(document, command);
                break;
            }
            default: {
                strategies = new ArrayList(strategies);
                for (IAutoEditStrategy autoEditStrategy : strategies) {
                    if (autoEditStrategy == null) continue;
                    autoEditStrategy.customizeDocumentCommand(document, command);
                }
            }
        }
        if (this.fEditor.shouldUseDefaultTabsToSpacesConversion()) {
            String autoformatOnPastePref;
            if (pasteCommand && PrefConst.isDetectIndentationEnabled() && (autoformatOnPastePref = this.getAutoformatOnPastePref()) != null && !autoformatOnPastePref.isEmpty() && !"Disabled".equals(autoformatOnPastePref)) {
                return;
            }
            if (this.fTabsToSpacesConverter != null) {
                this.fTabsToSpacesConverter.customizeDocumentCommand(document, command);
            }
        } else {
            this.useDetectIndentationTabsToSpacesConversion(document, command);
        }
    }

    private void useDetectIndentationTabsToSpacesConversion(IDocument document, DocumentCommand command) {
        if (command.text == null || !command.text.isEmpty() && command.text.indexOf(9) == -1) {
            return;
        }
        boolean detectedInsertSpaces = this.fEditor.isInsertSpaces(DVTPlugin.getDefault().getPreferenceStore());
        if (!detectedInsertSpaces) {
            return;
        }
        if (this.fTabsToSpacesConverter != null) {
            ((TabsToSpacesConverter)this.fTabsToSpacesConverter).setNumberOfSpacesPerTab(this.fEditor.getTabWidth());
            this.fTabsToSpacesConverter.customizeDocumentCommand(document, command);
            ((TabsToSpacesConverter)this.fTabsToSpacesConverter).setNumberOfSpacesPerTab(this.fEditor.getSourceViewerConfigurationForEditor().getTabWidth((ISourceViewer)this));
            return;
        }
        if (this.fDetectIndentationTabsToSpacesConverter == null) {
            this.fDetectIndentationTabsToSpacesConverter = new TabsToSpacesConverter();
        }
        this.fDetectIndentationTabsToSpacesConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
        this.fDetectIndentationTabsToSpacesConverter.setNumberOfSpacesPerTab(this.fEditor.getTabWidth());
        this.fDetectIndentationTabsToSpacesConverter.customizeDocumentCommand(document, command);
    }

    public ISelection getSelection() {
        StyledText textWidget = this.getTextWidget();
        if (textWidget == null) {
            return super.getSelection();
        }
        boolean isSelectionChanged = this.fSelectionChanged | this.fCachedSelection == null;
        if (isSelectionChanged) {
            boolean isBlockSelection = textWidget.getBlockSelection();
            this.fCachedSelection = this.internalGetSelection(textWidget, isBlockSelection);
            this.fSelectionChanged = false;
        } else {
            boolean isCachedBlockSelection = this.fCachedSelection instanceof BlockTextSelection;
            boolean isBlockSelection = textWidget.getBlockSelection();
            if (isCachedBlockSelection ^ isBlockSelection) {
                this.fCachedSelection = this.internalGetSelection(textWidget, isBlockSelection);
                this.fSelectionChanged = false;
            }
        }
        return this.fCachedSelection;
    }

    public Point getSelectedRange() {
        IDocument document = this.getDocument();
        if (document == null) {
            return new Point(0, 0);
        }
        return super.getSelectedRange();
    }

    public ISelection internalGetSelection(StyledText textWidget, boolean isBlockSelection) {
        if (textWidget != null && isBlockSelection) {
            Point sel = textWidget.getSelection();
            int startOffset = sel.x;
            int endOffset = sel.y;
            IDocument document = this.getDocument();
            int documentLength = document.getLength();
            if (startOffset > documentLength) {
                return TextSelection.emptySelection();
            }
            if (endOffset > documentLength) {
                endOffset = documentLength;
            }
            Rectangle bounds = textWidget.getBlockSelectionBounds();
            int clientAreaX = textWidget.getHorizontalPixel();
            int startX = bounds.x - clientAreaX;
            int endX = bounds.x + bounds.width - clientAreaX;
            int avgCharWidth = this.getAverageCharWidth();
            int startVirtuals = this.computeVirtualChars(startOffset, startX, avgCharWidth);
            int endVirtuals = this.computeVirtualChars(endOffset, endX, avgCharWidth);
            Point modelSelection = this.widgetSelection2ModelSelection(new Point(startOffset, endOffset - startOffset));
            if (modelSelection == null) {
                return TextSelection.emptySelection();
            }
            startOffset = modelSelection.x;
            endOffset = modelSelection.x + modelSelection.y;
            try {
                int startLine = document.getLineOfOffset(startOffset);
                int endLine = document.getLineOfOffset(endOffset);
                int startColumn = startOffset - document.getLineOffset(startLine) + startVirtuals;
                int endColumn = endOffset - document.getLineOffset(endLine) + endVirtuals;
                if (startColumn < 0) {
                    endColumn += startColumn;
                    startColumn = 0;
                }
                if (startLine == -1 || endLine == -1) {
                    return TextSelection.emptySelection();
                }
                return new BlockTextSelection(document, startLine, startColumn, endLine, endColumn, textWidget.getTabs());
            }
            catch (Exception exception) {
                return TextSelection.emptySelection();
            }
        }
        Point p = this.getSelectedRange();
        if (p.x == -1 || p.y == -1) {
            return TextSelection.emptySelection();
        }
        if (this.getDocument() == null) {
            return null;
        }
        return new TextSelection(this.getDocument(), p.x, p.y);
    }

    private int computeVirtualChars(int offset, int x, int avgCharWidth) {
        int diff = x - this.getTextWidget().getLocationAtOffset((int)offset).x;
        return diff / avgCharWidth;
    }

    public DVTEditor getEditor() {
        return this.fEditor;
    }

    protected ITextHover getTextHover(int offset, int stateMask) {
        if (this.fEditor == null) {
            return null;
        }
        boolean hoverDisabled = this.fEditor.isHoverDisabled();
        if (hoverDisabled && !this.fEditor.isAltPressed()) {
            return null;
        }
        return super.getTextHover(offset, stateMask);
    }

    public void configure(SourceViewerConfiguration configuration) {
        if (this.fEditor == null && configuration instanceof DVTSourceViewerConfiguration) {
            this.fEditor = ((DVTSourceViewerConfiguration)configuration).getEditor();
            if (this.fEditor != null && this.fTabsToSpacesConverter == null) {
                this.fEditor.reInstallTabsToSpacesConverter();
            }
        }
        super.configure(configuration);
    }

    public void unconfigure() {
        this.fTabsToSpacesConverter = null;
        this.fCachedSelection = null;
        this.fEditor = null;
        super.unconfigure();
    }

    public PaintManager getPaintManager() {
        return super.getPaintManager();
    }

    public void replaceCodeAutoEditStrategies(List<IAutoEditStrategy> codeAutoEditStrategies) {
        this.fAutoIndentStrategies.replace("__dftl_partition_content_type", codeAutoEditStrategies);
        this.fAutoIndentStrategies.replace("__vlog_literal", codeAutoEditStrategies);
    }

    public void replaceSLCommentAutoEditStrategies(List<IAutoEditStrategy> commentAutoEditStrategies) {
        this.fAutoIndentStrategies.replace("__vlog_sl_comment", commentAutoEditStrategies);
    }
}

