/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPairMatcher;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfigurationCommon;
import ro.amiq.dvt.ui.editor.formatter.detectindentation.DVTAutoIndentDetectionManager;
import ro.amiq.dvt.ui.editor.formatter.detectindentation.DVTAutoIndentDetector;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseCodeFormattingStrategy;
import ro.amiq.dvt.ui.editor.hover.DVTInformationControl;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipControlCreator;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;

public abstract class DVTSourceViewerConfiguration
extends DVTSourceViewerConfigurationCommon {
    private static final int NORMAL_MODE = 1;
    private static final int TESTING_MODE = 2;
    private static final int PREVIEW_MODE = 3;
    private int fMode;
    protected boolean fInsertSpaces;
    private MonoReconciler fReconciler;

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return parent -> {
            if (CommentUtils.getInstance().shouldUseOldTooltip()) {
                return new DVTInformationControl(parent, "");
            }
            return new DVTTooltipControlCreator(false).createInformationControl(parent);
        };
    }

    protected DVTSourceViewerConfiguration() {
        this.setTabWidth(this.fPreferenceStore == null ? 4 : this.fPreferenceStore.getInt("tabWidth"));
        this.setInsertSpaces(this.fPreferenceStore != null && this.fPreferenceStore.getBoolean("spacesForTabs"));
    }

    protected DVTSourceViewerConfiguration(IPreferenceStore combinedPreferenceStore) {
        super(combinedPreferenceStore);
        this.fMode = 1;
        this.setTabWidth(this.fPreferenceStore == null ? 4 : this.fPreferenceStore.getInt("tabWidth"));
        this.setInsertSpaces(this.fPreferenceStore != null && this.fPreferenceStore.getBoolean("spacesForTabs"));
    }

    @Override
    public void disableBracketMatcher(boolean disable) {
        if (this.fBracketMatcher instanceof DVTPairMatcher) {
            ((DVTPairMatcher)this.fBracketMatcher).setDisabled(disable);
        }
    }

    @Override
    public void setIncrementalReconciler(boolean incremental) {
        if (this.fReconciler != null) {
            this.fReconciler.setIsIncrementalReconciler(incremental);
        }
    }

    public void setReconciler(MonoReconciler reconciler) {
        this.fReconciler = reconciler;
    }

    @Override
    public boolean isTesting() {
        return this.fMode == 2;
    }

    public void setTesting() {
        this.fMode = 2;
    }

    @Override
    public boolean isPreview() {
        return this.fMode == 3;
    }

    public void setPreview() {
        this.fMode = 3;
    }

    public void setNormal() {
        this.fMode = 1;
    }

    public RGB getLineMarginColor() {
        return PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)"printMarginColor");
    }

    @Override
    public void refreshLineDelimiter() {
        this.fLineDelimiter = DVTDocumentCommon.getLineDelimiter(null);
    }

    @Override
    public void connectCFDocumentPartitioner(IDocument document) {
    }

    @Override
    public void disconnectCFDocumentPartitioner(IDocument document) {
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        IInformationControlCreator controlCreator = parent -> new DVTInformationControl(parent, "");
        InformationPresenter presenter = new InformationPresenter(controlCreator);
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        return presenter;
    }

    @Override
    public void refreshTabWidth(int tabWidth) {
        if (!PrefConst.isDetectIndentationEnabled()) {
            this.setTabWidth(tabWidth);
        }
    }

    @Override
    public void refreshInsertSpaces(boolean insertSpaces) {
        if (!PrefConst.isDetectIndentationEnabled()) {
            this.setInsertSpaces(insertSpaces);
        }
    }

    public boolean getInsertSpaces() {
        return this.fInsertSpaces;
    }

    public void setInsertSpaces(boolean insertSpaces) {
        this.fInsertSpaces = insertSpaces;
    }

    public void detectIndentation() {
        if (!PrefConst.isDetectIndentationEnabled()) {
            return;
        }
        DVTEditor editor = this.getEditor();
        if (editor == null) {
            return;
        }
        IDocument document = editor.getDocument();
        if (document == null) {
            return;
        }
        this.detectIndentation(document, true);
    }

    @Override
    public void detectIndentation(IDocument document) {
        if (!PrefConst.isDetectIndentationEnabled()) {
            return;
        }
        if (document == null) {
            return;
        }
        this.detectIndentation(document, false);
    }

    private void detectIndentation(IDocument document, boolean storeDocumentInManager) {
        try {
            DVTAutoIndentDetector.DetectedIndentation storedDetectedIndentation = DVTAutoIndentDetectionManager.INSTANCE.getDetectedIndentationForDocument(document);
            if (storedDetectedIndentation != null) {
                this.fTabWidth = storedDetectedIndentation.getTabWidth();
                this.fInsertSpaces = storedDetectedIndentation.getInsertSpaces();
                return;
            }
            DVTBaseCodeFormattingStrategy codeFormattingStrategy = this.getCodeFormattingStrategy();
            Set<String> allPreprocs = codeFormattingStrategy != null ? codeFormattingStrategy.getAllPreprocs() : null;
            DVTAutoIndentDetector.DetectedIndentation detectedIndentation = DVTAutoIndentDetector.INSTANCE.detectIndentation(document, this.fPreferenceStore, allPreprocs);
            this.fTabWidth = detectedIndentation.getTabWidth();
            this.fInsertSpaces = detectedIndentation.getInsertSpaces();
            if (storeDocumentInManager) {
                DVTAutoIndentDetectionManager.INSTANCE.setDetectedIndendationForDocument(document, detectedIndentation);
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public abstract DVTEditor getEditor();
}

