/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import ro.amiq.dvt.ui.editor.DVTAnnotationPainter;

public class DVTSourceViewerDecorationSupport
extends SourceViewerDecorationSupport {
    private ISourceViewer fSourceViewer;
    private IAnnotationAccess fAnnotationAccess;
    private static AnnotationPainter.ITextStyleStrategy fgBoxStrategy = new AnnotationPainter.BoxStrategy(1);
    private static AnnotationPainter.ITextStyleStrategy fgDashedBoxStrategy = new AnnotationPainter.BoxStrategy(2);
    private static AnnotationPainter.IDrawingStrategy fgNullStrategy = new AnnotationPainter.NullStrategy();
    private static AnnotationPainter.ITextStyleStrategy fgUnderlineStrategy = new AnnotationPainter.UnderlineStrategy(0);
    private static AnnotationPainter.IDrawingStrategy fgIBeamStrategy = new IBeamStrategy();
    private static AnnotationPainter.ITextStyleStrategy fgSquigglesStrategy = new AnnotationPainter.UnderlineStrategy(3);
    private static AnnotationPainter.ITextStyleStrategy fgProblemUnderlineStrategy = new AnnotationPainter.UnderlineStrategy(2);

    public DVTSourceViewerDecorationSupport(ISourceViewer sourceViewer, IOverviewRuler overviewRuler, IAnnotationAccess annotationAccess, ISharedTextColors sharedTextColors) {
        super(sourceViewer, overviewRuler, annotationAccess, sharedTextColors);
        this.fSourceViewer = sourceViewer;
        this.fAnnotationAccess = annotationAccess;
    }

    protected AnnotationPainter createAnnotationPainter() {
        DVTAnnotationPainter painter = new DVTAnnotationPainter(this.fSourceViewer, this.fAnnotationAccess);
        painter.addDrawingStrategy("NONE", fgNullStrategy);
        painter.addDrawingStrategy("IBEAM", fgIBeamStrategy);
        painter.addTextStyleStrategy("SQUIGGLES", fgSquigglesStrategy);
        painter.addTextStyleStrategy("PROBLEM_UNDERLINE", fgProblemUnderlineStrategy);
        painter.addTextStyleStrategy("BOX", fgBoxStrategy);
        painter.addTextStyleStrategy("DASHED_BOX", fgDashedBoxStrategy);
        painter.addTextStyleStrategy("UNDERLINE", fgUnderlineStrategy);
        return painter;
    }

    private static final class IBeamStrategy
    implements AnnotationPainter.IDrawingStrategy {
        private IBeamStrategy() {
        }

        public void draw(Annotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
            if (gc != null) {
                Point left = textWidget.getLocationAtOffset(offset);
                int x1 = left.x;
                int y1 = left.y;
                gc.setForeground(color);
                gc.drawLine(x1, y1, x1, left.y + textWidget.getLineHeight(offset) - 1);
            } else {
                int contentLength = textWidget.getCharCount();
                if (offset >= contentLength) {
                    textWidget.redraw();
                    return;
                }
                char ch = textWidget.getTextRange(offset, 1).charAt(0);
                if (ch == '\r' || ch == '\n') {
                    int nextLine = textWidget.getLineAtOffset(offset) + 1;
                    if (nextLine >= textWidget.getLineCount()) {
                        textWidget.redraw();
                        return;
                    }
                    int nextLineOffset = textWidget.getOffsetAtLine(nextLine);
                    length = nextLineOffset - offset;
                } else {
                    length = 1;
                }
                textWidget.redrawRange(offset, length, true);
            }
        }
    }
}

