/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public abstract class DVTWordFinder {
    protected char getChar(IDocument document, int offset) {
        return TextUtils.getChar(document, offset);
    }

    public abstract IRegion getWordAtOffset(IDocument var1, int var2);

    public IRegion getWordAtOffset(IDocument document, int offset, String customChars) {
        return this.getWordAtOffset(document, offset);
    }

    public abstract IRegion getWordAtOffset(IDocument var1, int var2, boolean var3);

    public Map<Annotation, Position> getSequenceOccurrences(IDocument document, String sequence, boolean caseInsensitive, boolean matchPartialWords) {
        int documentLength;
        int wordLength;
        int firstOverflowedLineIndex;
        int occurencesIndex;
        int maxNumberOfOccurrencesPerLine;
        int maxNumberOfOccurrences;
        LinkedHashMap<Annotation, DVTPosition> annotationMap;
        block23: {
            int maxNumberOfLines;
            block22: {
                block21: {
                    block20: {
                        annotationMap = null;
                        maxNumberOfLines = DVTPlugin.getDefault().getPreferenceStore().getInt("editor.markOccurencesNumberOfLines");
                        maxNumberOfOccurrences = DVTPlugin.getDefault().getPreferenceStore().getInt("editor.markOccurencesNumberOfMatches");
                        maxNumberOfOccurrencesPerLine = DVTPlugin.getDefault().getPreferenceStore().getInt("editor.markOccurencesNumberOfMatchesPerLine");
                        occurencesIndex = 0;
                        firstOverflowedLineIndex = -1;
                        if (sequence != null && document != null) break block20;
                        return null;
                    }
                    if (caseInsensitive) {
                        sequence = DVTStringUtil.toLowerCase(sequence);
                    }
                    if ((wordLength = sequence.length()) != 0) break block21;
                    return null;
                }
                documentLength = document.getLength();
                if (documentLength >= wordLength) break block22;
                return null;
            }
            if (document.getNumberOfLines() <= maxNumberOfLines) break block23;
            return null;
        }
        try {
            byte[] buffer = new byte[wordLength];
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, 0, true);
            int i = 0;
            while (i < wordLength) {
                int ch = scanner.read();
                buffer[i] = caseInsensitive ? (byte)Character.toLowerCase(ch) : (byte)ch;
                ++i;
            }
            byte[] wordBytes = sequence.getBytes();
            int occurencesPerLine = 0;
            while (scanner.getOffset() <= documentLength && (annotationMap == null || annotationMap.size() < maxNumberOfOccurrences)) {
                if (Arrays.equals(buffer, wordBytes)) {
                    if (occurencesPerLine < maxNumberOfOccurrencesPerLine) {
                        ++occurencesIndex;
                        int offset = scanner.getOffset();
                        char before = ' ';
                        if (offset > wordLength) {
                            before = this.getChar(document, offset - wordLength - 1);
                        }
                        char after = ' ';
                        if (offset < documentLength) {
                            after = this.getChar(document, offset);
                        }
                        if (matchPartialWords || !Character.isJavaIdentifierPart(after) && !Character.isJavaIdentifierPart(before)) {
                            if (annotationMap == null) {
                                annotationMap = new LinkedHashMap<Annotation, DVTPosition>();
                            }
                            annotationMap.put(new Annotation("ro.amiq.dvt.ui.occurrences", false, sequence), new DVTPosition(scanner.getOffset() - wordLength, wordLength));
                        }
                    }
                    ++occurencesPerLine;
                }
                if (occurencesPerLine > maxNumberOfOccurrencesPerLine && firstOverflowedLineIndex == -1) {
                    firstOverflowedLineIndex = occurencesIndex;
                }
                int i2 = 0;
                while (i2 < wordLength - 1) {
                    buffer[i2] = buffer[i2 + 1];
                    ++i2;
                }
                int ch = scanner.read();
                if (ch == 10) {
                    occurencesPerLine = 0;
                }
                byte by = buffer[wordLength - 1] = caseInsensitive ? (byte)Character.toLowerCase(ch) : (byte)ch;
            }
            if (annotationMap != null) {
                int index = 0;
                boolean occurrencesOverflow = occurencesIndex >= maxNumberOfOccurrences;
                for (Annotation annotation : annotationMap.keySet()) {
                    annotation.setText(String.valueOf(annotation.getText()) + " (" + (index >= firstOverflowedLineIndex - 1 ? "about" : "") + " " + ++index + "/" + annotationMap.size() + (occurrencesOverflow ? "+" : "") + ")");
                }
            }
            return annotationMap;
        }
        catch (Exception exception) {
            return annotationMap;
        }
    }

    public IRegion getRegionOfWordWithPrefix(IDocument document, String prefix, int startOffset, Set<String> skipWords, IRegion skipRegion) {
        int documentLength;
        int prefixLength;
        block16: {
            block15: {
                block14: {
                    if (prefix != null && document != null) break block14;
                    return null;
                }
                prefixLength = prefix.length();
                if (prefixLength != 0) break block15;
                return null;
            }
            documentLength = document.getLength();
            if (documentLength >= prefixLength) break block16;
            return null;
        }
        try {
            byte[] buffer = new byte[prefixLength];
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, startOffset, true);
            int i = 0;
            while (i < prefixLength) {
                buffer[i] = (byte)scanner.read();
                ++i;
            }
            byte[] wordBytes = prefix.getBytes();
            while (scanner.getOffset() <= documentLength) {
                String match = Arrays.toString(buffer);
                if (Arrays.equals(buffer, wordBytes) && !skipWords.contains(match)) {
                    IRegion matchingWordRegion;
                    int offset = scanner.getOffset();
                    char before = ' ';
                    if (offset > prefixLength) {
                        before = this.getChar(document, offset - prefixLength - 1);
                    }
                    char after = ' ';
                    if (offset < documentLength) {
                        after = this.getChar(document, offset);
                    }
                    if (!Character.isJavaIdentifierPart(before) && Character.isJavaIdentifierPart(after) && (matchingWordRegion = this.getWordAtOffset(document, offset, true)) != null && !matchingWordRegion.equals(new Region(0, 0)) && skipRegion.getOffset() != matchingWordRegion.getOffset()) {
                        int wordLength;
                        int wordOffset = matchingWordRegion.getOffset();
                        String matchingWord = document.get(wordOffset, wordLength = matchingWordRegion.getLength());
                        if (matchingWord.startsWith("`")) {
                            matchingWord = matchingWord.substring(1);
                            matchingWordRegion = new Region(wordOffset + 1, wordLength - 1);
                        }
                        if (!skipWords.contains(matchingWord)) {
                            return matchingWordRegion;
                        }
                    }
                }
                int i2 = 0;
                while (i2 < prefixLength - 1) {
                    buffer[i2] = buffer[i2 + 1];
                    ++i2;
                }
                buffer[prefixLength - 1] = (byte)scanner.read();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int goToStartOfWord(IDocument document, int offset) {
        int pos = offset;
        boolean stopWhenWS = false;
        DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, pos - 1), false);
        while (pos >= 0) {
            char c = (char)scanner.read();
            if (!Character.isJavaIdentifierPart(c) && stopWhenWS) {
                return Math.max(pos, 0);
            }
            if (Character.isJavaIdentifierPart(c) && !stopWhenWS) {
                stopWhenWS = true;
            }
            --pos;
        }
        return 0;
    }

    public int goToEndOfWord(IDocument document, int offset) {
        int c;
        int pos = offset;
        boolean stopWhenWS = false;
        DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, pos, true);
        while ((c = scanner.read()) != -1) {
            if (!Character.isJavaIdentifierPart(c) && stopWhenWS) {
                return pos;
            }
            if (Character.isJavaIdentifierPart(c) && !stopWhenWS) {
                stopWhenWS = true;
            }
            ++pos;
        }
        return document.getLength();
    }
}

