/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DirtyEditorSaver
extends Job
implements IPropertyChangeListener {
    private static final long ONE_SECOND = 1000L;
    private static final String BG_JOB_NAME = "DVT Auto-Save Background Job";
    private static final String FG_JOB_NAME = "DVT Auto-Save Foreground Job";
    private static DirtyEditorSaver fInstance;
    private IPreferenceStore fPrefStore;
    private Job fSaveJob;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DirtyEditorSaver getInstance() {
        Class<DirtyEditorSaver> clazz = DirtyEditorSaver.class;
        synchronized (DirtyEditorSaver.class) {
            if (fInstance == null) {
                fInstance = new DirtyEditorSaver();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fInstance;
        }
    }

    private DirtyEditorSaver() {
        super(BG_JOB_NAME);
        this.setSystem(true);
        this.setUser(false);
        this.setPriority(50);
    }

    public void start() {
        try {
            this.fPrefStore = DVTPlugin.getDefault().getPreferenceStore();
            this.fPrefStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.schedule();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void stop() {
        if (this.fPrefStore != null) {
            this.fPrefStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.fPrefStore = null;
        this.cancel();
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (!this.isEnabled()) {
            return Status.OK_STATUS;
        }
        this.schedule(this.getDelay());
        try {
            IWorkbenchWindow[] workbenchWindows;
            final ArrayList<IEditorReference> dirtyEditorReferences = new ArrayList<IEditorReference>();
            IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = workbenchWindows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = workbenchWindow.getPages();
                int n3 = iWorkbenchPageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                    int n5 = iEditorReferenceArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IEditorReference reference = iEditorReferenceArray[n6];
                        if (reference.isDirty()) {
                            dirtyEditorReferences.add(reference);
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
            if (dirtyEditorReferences.isEmpty()) {
                return Status.OK_STATUS;
            }
            if (this.fSaveJob != null) {
                this.fSaveJob.cancel();
            }
            this.fSaveJob = new Job(FG_JOB_NAME){

                protected IStatus run(final IProgressMonitor monitor) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            for (IEditorReference reference : dirtyEditorReferences) {
                                reference.getEditor(false).doSave(monitor);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            this.fSaveJob.setUser(true);
            this.fSaveJob.setSystem(false);
            this.fSaveJob.schedule();
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
        return Status.OK_STATUS;
    }

    private long getDelay() {
        return (long)DVTPlugin.getDefault().getPreferenceStore().getInt("saveDirtyEditorsInterval") * 1000L;
    }

    private boolean isEnabled() {
        return DVTPlugin.getDefault().getPreferenceStore().getBoolean("saveDirtyEditors");
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("saveDirtyEditors") || event.getProperty().equals("saveDirtyEditorsInterval")) {
            this.cancel();
            this.schedule(this.getDelay());
        }
    }
}

