/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.MultiPageEditorPart;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.views.ViewsUtils;

public enum EditorMaximizeListener {
    INSTANCE;

    private static final String ORG_ECLIPSE_UI_WINDOW_MAXIMIZE_PART = "org.eclipse.ui.window.maximizePart";
    private MouseListener fMaximizeDblClickListener;
    private IExecutionListener fMaximizeCommandListener;

    public final void editorOpened(DVTEditor editor) {
        this.addMaximizeCommandListener();
        this.addMaximizeDblClickListener(editor);
    }

    private void addMaximizeDblClickListener(DVTEditor editor) {
        CTabFolder tabFolder;
        if (this.fMaximizeDblClickListener == null) {
            this.fMaximizeDblClickListener = new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    EditorMaximizeListener.this.showNotification();
                }
            };
        }
        if ((tabFolder = this.getTabFolder(editor)) == null) {
            return;
        }
        tabFolder.removeMouseListener(this.fMaximizeDblClickListener);
        tabFolder.addMouseListener(this.fMaximizeDblClickListener);
        tabFolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EditorMaximizeListener.this.fMaximizeDblClickListener != null) {
                    tabFolder.removeMouseListener(EditorMaximizeListener.this.fMaximizeDblClickListener);
                }
            }
        });
    }

    private CTabFolder getTabFolder(DVTEditor editor) {
        CTabFolder result = null;
        Composite parent = editor.getNotificationsHostComposite();
        while (parent != null) {
            if (!((parent = parent.getParent()) instanceof CTabFolder)) continue;
            result = (CTabFolder)parent;
        }
        return result;
    }

    private void addMaximizeCommandListener() {
        if (this.fMaximizeDblClickListener != null) {
            return;
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        if (commandService == null) {
            return;
        }
        this.fMaximizeCommandListener = new IExecutionListener(){

            public void postExecuteSuccess(String commandId, Object returnValue) {
                if (!EditorMaximizeListener.ORG_ECLIPSE_UI_WINDOW_MAXIMIZE_PART.equals(commandId)) {
                    return;
                }
                EditorMaximizeListener.this.showNotification();
            }

            public void preExecute(String commandId, ExecutionEvent event) {
            }

            public void postExecuteFailure(String commandId, ExecutionException exception) {
            }

            public void notHandled(String commandId, NotHandledException exception) {
            }
        };
        commandService.addExecutionListener(this.fMaximizeCommandListener);
    }

    private void showNotification() {
        DVTUiUtils.getActiveWorkbenchShell().getDisplay().timerExec(200, () -> this.showNotificationDelayed());
    }

    private void showNotificationDelayed() {
        IWorkbenchPage page = DVTUiUtils.getActivePage();
        if (page == null) {
            return;
        }
        IEditorPart activeEditor = page.getActiveEditor();
        if (!(activeEditor instanceof IDVTEditor)) {
            return;
        }
        if (page.getPartState(page.getReference((IWorkbenchPart)activeEditor)) != 1) {
            return;
        }
        if (activeEditor instanceof MultiPageEditorPart) {
            Object activePage = ((MultiPageEditorPart)activeEditor).getSelectedPage();
            if (!(activePage instanceof DVTEditor)) {
                return;
            }
            ViewsUtils.showDidYouKnowEditorNotification((DVTEditor)activePage);
            return;
        }
        ViewsUtils.showDidYouKnowEditorNotification((DVTEditor)activeEditor);
    }
}

