/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor;

import org.apache.commons.lang.SystemUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.FloatFieldEditor;
import ro.amiq.dvt.utils.IntegerFieldEditor;

public class EditorsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "ro.amiq.dvt.EditorsPreferencePage";
    private Link fTextEditorsLink;
    private Group scalability;
    private FloatFieldEditor maximumSizeOfFile;
    private IntegerFieldEditor codeFormattingMaxLinesField;
    private Group fCodeFormattingGroup;
    private ComboFieldEditor fAutoformatOnPaste;
    private FloatFieldEditor fMaximumSizeOfFile;
    private static final int MAX_NUMBER_OF_CHARACTERS = 8;
    private IntegerFieldEditor fMaximumWaveformLength;
    private static final int MAX_WAVEFORM_SIZE_WIDTH = 8;
    private IntegerFieldEditor tooltipMaxNoChars;
    private static final int MAX_TOOLTIP_SIZE_WIDTH = 8;
    private Group fTooltip;
    private ComboFieldEditor fTooltipFormatter;
    private BooleanFieldEditor fTooltipParamDefaultValue;
    private BooleanFieldEditor fAutoDetectIndentation;
    private Group fMarkOccurences;
    private IntegerFieldEditor fMarkOccurencesNofLinesField;
    private IntegerFieldEditor fMarkOccurencesNofMatchesField;
    private IntegerFieldEditor fMarkOccurencesNofMatchesPerLineField;
    private BooleanFieldEditor fMarkOccurencesMatchPartialOccurences;
    private Group fFindAndReplace;
    private BooleanFieldEditor fPreserveClipboardSelection;

    public EditorsPreferencePage() {
        super(1);
        this.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.setDescription("General settings for all DVT editors");
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        this.scalability = new Group(this.getFieldEditorParent(), 16);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)this.scalability);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 0).applyTo((Control)this.scalability);
        this.scalability.setText("Scalability");
        Composite maximumSizeOfFileContainer = new Composite((Composite)this.scalability, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 0).applyTo((Control)maximumSizeOfFileContainer);
        this.maximumSizeOfFile = new FloatFieldEditor("editor.maxiumSizeOfFile", "Confirm opening files larger than (MB)", 8, maximumSizeOfFileContainer);
        this.maximumSizeOfFile.setEmptyStringAllowed(false);
        this.maximumSizeOfFile.setTextLimit(8);
        this.addField((FieldEditor)this.maximumSizeOfFile);
        Composite codeFormattingContainer = new Composite((Composite)this.scalability, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 0).applyTo((Control)codeFormattingContainer);
        this.codeFormattingMaxLinesField = new IntegerFieldEditor("disable.codeformatting", "Disable code formatting in files with more than (lines)", 8, codeFormattingContainer);
        this.codeFormattingMaxLinesField.setEmptyStringAllowed(false);
        this.codeFormattingMaxLinesField.setTextLimit(8);
        this.addField((FieldEditor)this.codeFormattingMaxLinesField);
        Composite container = new Composite((Composite)this.scalability, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 0).applyTo((Control)container);
        this.fMaximumWaveformLength = new IntegerFieldEditor("wavedrom.waveform.size", "Disable preview in tooltips and Inspect View for WaveDrom  descriptions larger than (chars)", 8, container);
        this.addField((FieldEditor)this.fMaximumWaveformLength);
        Composite tooltipMaxNoCharacters = new Composite((Composite)this.scalability, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 0).applyTo((Control)tooltipMaxNoCharacters);
        this.tooltipMaxNoChars = new IntegerFieldEditor("tooltip.size", "Trim comments displayed in tooltips to (chars)", 8, tooltipMaxNoCharacters);
        this.tooltipMaxNoChars.setEmptyStringAllowed(false);
        this.tooltipMaxNoChars.setTextLimit(8);
        this.addField((FieldEditor)this.tooltipMaxNoChars);
        this.fTooltip = new Group(this.getFieldEditorParent(), 16);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)this.fTooltip);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 0).applyTo((Control)this.fTooltip);
        this.fTooltip.setText("Tooltip");
        Composite tooltipFormatterContainer = new Composite((Composite)this.fTooltip, 0);
        String[][] optionNames = this.getFormattersNameAndId();
        this.fTooltipFormatter = new ComboFieldEditor("tooltipMarkupLanguage", "Markup language", optionNames, tooltipFormatterContainer);
        this.addField((FieldEditor)this.fTooltipFormatter);
        Composite tooltipParamDefaultValue = new Composite((Composite)this.fTooltip, 0);
        this.fTooltipParamDefaultValue = new BooleanFieldEditor("Display parameter default value alongside actual value", "Display parameter default value alongside actual value", tooltipParamDefaultValue);
        this.addField((FieldEditor)this.fTooltipParamDefaultValue);
        if (!EclipseUtils.hasWorkingBrowser()) {
            this.fTooltipFormatter.setEnabled(false, tooltipFormatterContainer);
            Composite noteContainer = new Composite((Composite)this.fTooltip, 0);
            GridLayoutFactory.fillDefaults().applyTo(noteContainer);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)noteContainer);
            this.createNoteComposite(this.fTooltip.getFont(), noteContainer, "Note:", "The browser component needed to display rich formatted tooltips is not supported by your OS.\nComments will be displayed in Verbatim.");
        }
        this.fCodeFormattingGroup = new Group(this.getFieldEditorParent(), 16);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)this.fCodeFormattingGroup);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 0).applyTo((Control)this.fCodeFormattingGroup);
        this.fCodeFormattingGroup.setText("Code Formatting");
        this.fTextEditorsLink = new Link((Composite)this.fCodeFormattingGroup, 64);
        GridData gd = new GridData(4, 0x1000000, true, false, 2, 1);
        gd.widthHint = 100;
        this.fTextEditorsLink.setLayoutData((Object)gd);
        this.fTextEditorsLink.setText("Overrides Insert Spaces for Tabs and Tab Width from <a href=\"org.eclipse.ui.preferencePages.GeneralTextEditor\">Text Editors</a> preference page based on the file contents.");
        this.fTextEditorsLink.setFont(this.fCodeFormattingGroup.getFont());
        DVTUiUtils.setPlatformLinkColor((Link)this.fTextEditorsLink);
        this.fTextEditorsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)EditorsPreferencePage.this.fTextEditorsLink.getShell(), (String)e.text, null, null);
            }
        });
        Composite autoDetectIndentation = new Composite((Composite)this.fCodeFormattingGroup, 0);
        this.fAutoDetectIndentation = new BooleanFieldEditor("format.indent.auto_detect", "Auto-detect indentation", autoDetectIndentation);
        this.addField((FieldEditor)this.fAutoDetectIndentation);
        Composite autoformatOnPasteContainer = new Composite((Composite)this.fCodeFormattingGroup, 0);
        this.fAutoformatOnPaste = new ComboFieldEditor("format.format_on_paste", "Automatically format the code pasted from clipboard", this.getAutoformatOnPasteOptions(), autoformatOnPasteContainer);
        this.addField((FieldEditor)this.fAutoformatOnPaste);
        this.fMarkOccurences = new Group(this.getFieldEditorParent(), 16);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)this.fMarkOccurences);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 0).applyTo((Control)this.fMarkOccurences);
        this.fMarkOccurences.setText("Mark occurrences");
        Dialog.applyDialogFont((Control)this.fMarkOccurences);
        Composite markOccurencesContainer = new Composite((Composite)this.fMarkOccurences, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 0).applyTo((Control)markOccurencesContainer);
        this.fMarkOccurencesMatchPartialOccurences = new BooleanFieldEditor("editor.markOccurencesMatchPartialWords", "Match partial words", markOccurencesContainer);
        this.addField((FieldEditor)this.fMarkOccurencesMatchPartialOccurences);
        this.fMarkOccurencesNofLinesField = new IntegerFieldEditor("editor.markOccurencesNumberOfLines", "Maximum number of lines in file", 8, markOccurencesContainer);
        this.fMarkOccurencesNofLinesField.setEmptyStringAllowed(false);
        this.fMarkOccurencesNofLinesField.setTextLimit(8);
        this.addField((FieldEditor)this.fMarkOccurencesNofLinesField);
        this.fMarkOccurencesNofMatchesField = new IntegerFieldEditor("editor.markOccurencesNumberOfMatches", "Maximum number of matches", 8, markOccurencesContainer);
        this.fMarkOccurencesNofMatchesField.setEmptyStringAllowed(false);
        this.fMarkOccurencesNofMatchesField.setTextLimit(8);
        this.addField((FieldEditor)this.fMarkOccurencesNofMatchesField);
        this.fMarkOccurencesNofMatchesPerLineField = new IntegerFieldEditor("editor.markOccurencesNumberOfMatchesPerLine", "Maximum number of matches per line", 8, markOccurencesContainer);
        this.fMarkOccurencesNofMatchesPerLineField.setEmptyStringAllowed(false);
        this.fMarkOccurencesNofMatchesPerLineField.setTextLimit(8);
        this.addField((FieldEditor)this.fMarkOccurencesNofMatchesPerLineField);
        if (SystemUtils.IS_OS_LINUX) {
            this.fFindAndReplace = new Group(this.getFieldEditorParent(), 16);
            GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)this.fFindAndReplace);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(2, 0).applyTo((Control)this.fFindAndReplace);
            this.fFindAndReplace.setText("Find and Replace");
            this.fPreserveClipboardSelection = new BooleanFieldEditor("ro.amiq.dvt.PRESERVE_CLIPBOARD_CONTENT", "Preserve selection clipboard content", (Composite)this.fFindAndReplace);
            this.addField((FieldEditor)this.fPreserveClipboardSelection);
        }
    }

    private String[][] getFormattersNameAndId() {
        int len = PrefConst.TOOLTIP_MARKUP_LANGUAGES.length;
        String[][] result = new String[len][2];
        int i = 0;
        while (i < len) {
            result[i][0] = PrefConst.TOOLTIP_MARKUP_LANGUAGES[i];
            result[i][1] = PrefConst.TOOLTIP_MARKUP_LANGUAGES[i];
            ++i;
        }
        return result;
    }

    private String[][] getAutoformatOnPasteOptions() {
        int len = PrefConst.CF_AUTOFORMAT_ON_PASTE_OPTIONS.length;
        String[][] result = new String[len][2];
        int i = 0;
        while (i < len) {
            result[i][0] = PrefConst.CF_AUTOFORMAT_ON_PASTE_OPTIONS[i];
            result[i][1] = PrefConst.CF_AUTOFORMAT_ON_PASTE_OPTIONS[i];
            ++i;
        }
        return result;
    }

    public void dispose() {
        if (this.scalability != null) {
            this.scalability.dispose();
        }
        if (this.fCodeFormattingGroup != null) {
            this.fCodeFormattingGroup.dispose();
        }
        if (this.fMaximumSizeOfFile != null) {
            this.fMaximumSizeOfFile.dispose();
        }
        if (this.fMaximumWaveformLength != null) {
            this.fMaximumWaveformLength.dispose();
        }
        if (this.fTooltipParamDefaultValue != null) {
            this.fTooltipParamDefaultValue.dispose();
        }
        if (this.fMarkOccurences != null) {
            this.fMarkOccurences.dispose();
        }
        if (this.fFindAndReplace != null) {
            this.fFindAndReplace.dispose();
        }
        if (this.fPreserveClipboardSelection != null) {
            this.fPreserveClipboardSelection.dispose();
        }
        super.dispose();
    }
}

